/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph;

import java.io.File;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphHandler;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.ModelManager;
import mchorse.metamorph.capabilities.CapabilityHandler;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.capabilities.morphing.MorphingStorage;
import mchorse.metamorph.config.MetamorphConfig;
import mchorse.metamorph.entity.EntityMorph;
import mchorse.metamorph.network.Dispatcher;
import mchorse.vanilla_pack.MobMorphFactory;
import mchorse.vanilla_pack.VanillaMorphFactory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CommonProxy {
    public ModelManager models = new ModelManager();
    public MetamorphConfig config;
    public Configuration forge;
    public File morphs;
    public File blacklist;

    public void preLoad(FMLPreInitializationEvent event) {
        Dispatcher.register();
        MorphManager.INSTANCE.models = this.models;
        MorphManager.INSTANCE.factories.add(new MobMorphFactory());
        MorphManager.INSTANCE.factories.add(new VanillaMorphFactory());
        File config = new File(event.getModConfigurationDirectory(), "metamorph/config.cfg");
        File morphs = new File(event.getModConfigurationDirectory(), "metamorph/morphs.json");
        File blacklist = new File(event.getModConfigurationDirectory(), "metamorph/blacklist.json");
        this.forge = new Configuration(config);
        this.config = new MetamorphConfig(this.forge);
        this.morphs = morphs;
        this.blacklist = blacklist;
        EntityRegistry.registerModEntity(EntityMorph.class, (String)"Morph", (int)0, (Object)Metamorph.instance, (int)64, (int)3, (boolean)false);
    }

    public void load() {
        MinecraftForge.EVENT_BUS.register((Object)this.config);
        MinecraftForge.EVENT_BUS.register((Object)new MorphHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        CapabilityManager.INSTANCE.register(IMorphing.class, (Capability.IStorage)new MorphingStorage(), Morphing.class);
        MorphManager.INSTANCE.register();
        if (this.morphs.exists()) {
            MorphUtils.loadMorphSettings(MorphManager.INSTANCE, this.morphs);
        } else {
            MorphUtils.generateFile(this.morphs, "{}");
        }
        if (this.blacklist.exists()) {
            MorphUtils.loadBlacklist(MorphManager.INSTANCE, this.blacklist);
        } else {
            MorphUtils.generateFile(this.blacklist, "[]");
        }
    }
}

