/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import com.google.common.collect.Lists;
import java.util.List;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class EntityUtils {
    private static List<String> removeAttributes = Lists.newArrayList((Object[])new String[]{"generic.followRange"});

    public static NBTTagCompound stripEntityNBT(NBTTagCompound tag) {
        tag.func_82580_o("Dimension");
        tag.func_82580_o("HurtTime");
        tag.func_82580_o("DeathTime");
        tag.func_82580_o("HurtByTimestamp");
        tag.func_82580_o("Health");
        tag.func_82580_o("PortalCooldown");
        tag.func_82580_o("Leashed");
        tag.func_82580_o("Air");
        tag.func_82580_o("id");
        tag.func_82580_o("Invulnerable");
        tag.func_82580_o("ArmorDropChances");
        tag.func_82580_o("HandDropChances");
        tag.func_82580_o("HandItems");
        tag.func_82580_o("Inventory");
        tag.func_82580_o("LeftHanded");
        tag.func_82580_o("CanPickUpLoot");
        tag.func_82580_o("Pos");
        tag.func_82580_o("Motion");
        tag.func_82580_o("Rotation");
        tag.func_82580_o("FallDistance");
        tag.func_82580_o("FallFlying");
        tag.func_82580_o("OnGround");
        tag.func_82580_o("Fire");
        tag.func_82580_o("ArmorItems");
        tag.func_82580_o("UUIDLeast");
        tag.func_82580_o("UUIDMost");
        if (tag.func_74764_b("Attributes")) {
            NBTTagList attributes = tag.func_150295_c("Attributes", 10);
            for (int i = attributes.func_74745_c() - 1; i >= 0; --i) {
                if (!removeAttributes.contains(attributes.func_150305_b(i).func_74779_i("Name"))) continue;
                attributes.func_74744_a(i);
            }
        }
        tag.func_82580_o("Peek");
        tag.func_82580_o("AttachFace");
        tag.func_82580_o("APX");
        tag.func_82580_o("APY");
        tag.func_82580_o("APZ");
        tag.func_82580_o("Anger");
        tag.func_82580_o("HurtBy");
        return tag;
    }

    public static boolean compareData(NBTTagCompound a, NBTTagCompound b) {
        if (a.func_186856_d() != b.func_186856_d()) {
            return false;
        }
        for (String key : a.func_150296_c()) {
            NBTBase aTag = a.func_74781_a(key);
            NBTBase bTag = b.func_74781_a(key);
            if (bTag == null) {
                return false;
            }
            if (!(aTag instanceof NBTBase.NBTPrimitive) && !(aTag instanceof NBTTagString) || aTag.equals((Object)bTag)) continue;
            return false;
        }
        return true;
    }

    public static EntityEquipmentSlot slotForIndex(int index) {
        EntityEquipmentSlot slot = EntityEquipmentSlot.MAINHAND;
        switch (index) {
            case 1: {
                slot = EntityEquipmentSlot.OFFHAND;
                break;
            }
            case 2: {
                slot = EntityEquipmentSlot.FEET;
                break;
            }
            case 3: {
                slot = EntityEquipmentSlot.LEGS;
                break;
            }
            case 4: {
                slot = EntityEquipmentSlot.CHEST;
                break;
            }
            case 5: {
                slot = EntityEquipmentSlot.HEAD;
            }
        }
        return slot;
    }

    public static AbstractMorph getMorph(EntityLivingBase entity) {
        if (entity instanceof IMorphProvider) {
            return ((IMorphProvider)entity).getMorph();
        }
        IMorphing cap = (IMorphing)entity.getCapability(MorphingProvider.MORPHING_CAP, null);
        if (cap != null) {
            return cap.getCurrentMorph();
        }
        return null;
    }

    public static String getPose(EntityLivingBase entity, String custom, boolean sneak) {
        boolean empty = custom.isEmpty();
        if (!empty && !sneak) {
            return custom;
        }
        if (entity.func_184613_cA()) {
            return "flying";
        }
        if (entity.func_184218_aH()) {
            return "riding";
        }
        if (entity.func_70093_af()) {
            return sneak && !empty ? custom : "sneaking";
        }
        return "standing";
    }
}

