/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import mchorse.metamorph.api.events.AcquireMorphEvent;
import mchorse.metamorph.api.events.MorphEvent;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketAcquireMorph;
import mchorse.metamorph.network.common.PacketMorph;
import mchorse.metamorph.network.common.PacketMorphPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MorphAPI {
    public static boolean demorph(EntityPlayer player) {
        return MorphAPI.morph(player, null, false);
    }

    public static boolean morph(EntityPlayer player, AbstractMorph morph, boolean force) {
        IMorphing morphing = Morphing.get(player);
        if (morphing == null) {
            return false;
        }
        MorphEvent event = new MorphEvent(player, morph, force);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean morphed = morphing.setCurrentMorph(event.morph, player, event.force);
        if (!player.field_70170_p.field_72995_K && morphed) {
            Dispatcher.sendTo(new PacketMorph(morph), (EntityPlayerMP)player);
            Dispatcher.updateTrackers((Entity)player, new PacketMorphPlayer(player.func_145782_y(), morph));
        }
        return morphed;
    }

    public static boolean acquire(EntityPlayer player, AbstractMorph morph) {
        if (morph == null) {
            return false;
        }
        AcquireMorphEvent event = new AcquireMorphEvent(player, morph);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean acquired = Morphing.get(player).acquireMorph(event.morph);
        if (!player.field_70170_p.field_72995_K && acquired) {
            Dispatcher.sendTo(new PacketAcquireMorph(event.morph), (EntityPlayerMP)player);
        }
        return acquired;
    }
}

