/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.util.ArrayList;
import java.util.List;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.entity.EntityMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MorphHandler {
    public static List<Runnable> FUTURE_TASKS_CLIENT = new ArrayList<Runnable>();
    public static List<Runnable> FUTURE_TASKS_SERVER = new ArrayList<Runnable>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        block5: {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            EntityPlayer player = event.player;
            IMorphing capability = Morphing.get(player);
            this.runFutureTasks(player);
            if (capability == null || !capability.isMorphed()) {
                if (!Metamorph.proxy.config.disable_pov) {
                    player.eyeHeight = player.getDefaultEyeHeight();
                }
                return;
            }
            try {
                capability.getCurrentMorph().update((EntityLivingBase)player, capability);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (player.field_70170_p.field_72995_K) break block5;
                MorphAPI.demorph(player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerKillEntity(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (target.field_70170_p.field_72995_K || source instanceof FakePlayer) {
            return;
        }
        if (!(source instanceof EntityPlayer) || target instanceof EntityPlayer || Metamorph.proxy.config.prevent_kill_acquire) {
            return;
        }
        EntityPlayer player = (EntityPlayer)source;
        IMorphing capability = Morphing.get(player);
        if (capability == null) {
            return;
        }
        String name = MorphManager.INSTANCE.morphNameFromEntity(target);
        if (!MorphManager.INSTANCE.hasMorph(name)) {
            Metamorph.log("Morph by key '" + name + "' doesn't exist!");
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", name);
        tag.func_74782_a("EntityData", (NBTBase)EntityUtils.stripEntityNBT(target.serializeNBT()));
        AbstractMorph morph = MorphManager.INSTANCE.morphFromNBT(tag);
        if (!Metamorph.proxy.config.prevent_ghosts || !capability.acquiredMorph(morph)) {
            EntityMorph morphEntity = new EntityMorph(player.field_70170_p, player.func_110124_au(), morph);
            morphEntity.func_70080_a(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, target.field_70177_z, target.field_70125_A);
            player.field_70170_p.func_72838_d((Entity)morphEntity);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        Entity source = event.getSource().func_76346_g();
        Entity target = event.getEntity();
        if (source instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source;
            IMorphing capability = Morphing.get(player);
            if (capability == null || !capability.isMorphed()) {
                return;
            }
            capability.getCurrentMorph().attack(target, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        EntityLivingBase source = event.getEntityLiving();
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            IMorphing morphing = Morphing.get(player);
            if (morphing == null || !morphing.isMorphed()) {
                return;
            }
            if (morphing.getCurrentMorph().hostile && source.func_94060_bK() != target && source instanceof EntityLiving) {
                ((EntityLiving)event.getEntity()).func_70624_b(null);
            }
        }
    }

    private void runFutureTasks(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && !FUTURE_TASKS_CLIENT.isEmpty()) {
            FUTURE_TASKS_CLIENT.remove(0).run();
        }
        if (!player.field_70170_p.field_72995_K && !FUTURE_TASKS_SERVER.isEmpty()) {
            FUTURE_TASKS_SERVER.remove(0).run();
        }
    }
}

