/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;

public class MorphList {
    public Map<String, List<MorphCell>> morphs = new HashMap<String, List<MorphCell>>();

    public boolean hasMorph(String name) {
        return this.morphs.containsKey(name);
    }

    public void addMorph(String name, AbstractMorph morph) {
        this.addMorph(name, "", "", morph);
    }

    public void addMorph(String name, String category, AbstractMorph morph) {
        this.addMorph(name, category, "", morph);
    }

    public void addMorph(String name, String category, String variant, AbstractMorph morph) {
        if (MorphManager.isBlacklisted(name) || this.hasMorph(name)) {
            return;
        }
        ArrayList<MorphCell> list = new ArrayList<MorphCell>();
        list.add(new MorphCell(morph, category, variant));
        this.morphs.put(name, list);
    }

    public void addMorphVariant(String name, String category, String variant, AbstractMorph morph) {
        if (MorphManager.isBlacklisted(name)) {
            return;
        }
        if (this.hasMorph(name)) {
            this.morphs.get(name).add(new MorphCell(morph, category, variant));
        } else {
            this.addMorph(name, category, variant, morph);
        }
    }

    public void removeVariant(String name, int index) {
        List<MorphCell> list;
        if (this.hasMorph(name) && !(list = this.morphs.get(name)).isEmpty() && index >= 0 && index < list.size()) {
            list.remove(index);
        }
    }

    public static class MorphCell {
        public AbstractMorph morph;
        public String category;
        public String variant;

        public MorphCell(AbstractMorph morph, String category, String variant) {
            this.morph = morph;
            this.category = category;
            this.variant = variant;
        }
    }
}

