/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.json.MorphSettingsAdapter;

public class MorphUtils {
    private static Gson gson = new GsonBuilder().registerTypeAdapter(MorphSettings.class, (Object)new MorphSettingsAdapter()).create();

    public static void loadMorphSettings(MorphManager manager, InputStream input) {
        Scanner scanner = new Scanner(input, "UTF-8");
        Type type = new TypeToken<Map<String, MorphSettings>>(){}.getType();
        Map data = (Map)gson.fromJson(scanner.useDelimiter("\\A").next(), type);
        scanner.close();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            MorphSettings settings = (MorphSettings)entry.getValue();
            if (manager.settings.containsKey(key)) {
                manager.settings.get(key).merge(settings);
                continue;
            }
            manager.settings.put(key, settings);
        }
    }

    public static void loadMorphSettings(MorphManager manager, File config) {
        try {
            MorphUtils.loadMorphSettings(manager, new FileInputStream(config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateFile(File config, String content) {
        config.getParentFile().mkdirs();
        try {
            PrintWriter writer = new PrintWriter(config);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void loadBlacklist(MorphManager instance, File blacklist) {
        try {
            MorphUtils.loadBlacklist(instance, new FileInputStream(blacklist));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadBlacklist(MorphManager instance, FileInputStream input) {
        Scanner scanner = new Scanner((InputStream)input, "UTF-8");
        Type type = new TypeToken<List<String>>(){}.getType();
        List data = (List)gson.fromJson(scanner.useDelimiter("\\A").next(), type);
        instance.blacklist.addAll(data);
        scanner.close();
    }
}

