/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mchorse.metamorph.api.models.Model;
import net.minecraft.util.ResourceLocation;

public class ModelAdapter
implements JsonDeserializer<Model>,
JsonSerializer<Model> {
    public static Gson plainGSON = new GsonBuilder().create();

    public Model deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Model model = (Model)plainGSON.fromJson(json, Model.class);
        JsonObject object = json.getAsJsonObject();
        if (object.has("default")) {
            String type = object.get("default").getAsString();
            model.defaultTexture = new ResourceLocation(type);
        }
        return model;
    }

    public JsonElement serialize(Model src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serial = plainGSON.toJsonTree((Object)src, typeOfSrc);
        JsonObject map = serial.getAsJsonObject();
        map.remove("model");
        map.remove("defaultTexture");
        map.remove("scale");
        map.remove("limbs");
        map.remove("poses");
        if (!src.model.isEmpty()) {
            map.addProperty("model", src.model);
        }
        if (src.defaultTexture != null) {
            map.addProperty("default", src.defaultTexture.toString());
        }
        if (src.scale[0] != 1.0f || src.scale[1] != 1.0f || src.scale[2] != 1.0f) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[0])));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[1])));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[2])));
            map.add("scale", (JsonElement)array);
        }
        map.add("limbs", context.serialize(src.limbs));
        map.add("poses", context.serialize(src.poses));
        return map;
    }
}

