/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mchorse.metamorph.api.json.ModelAdapter;
import mchorse.metamorph.api.json.ModelPoseAdapter;
import mchorse.metamorph.api.models.Model;

public class ModelLimbAdapter
implements JsonSerializer<Model.Limb> {
    public JsonElement serialize(Model.Limb src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serial = ModelAdapter.plainGSON.toJsonTree((Object)src, typeOfSrc);
        JsonObject map = serial.getAsJsonObject();
        map.remove("holding");
        map.remove("parent");
        map.remove("name");
        map.remove("opacity");
        map.remove("color");
        if (!src.holding.isEmpty()) {
            map.addProperty("holding", src.holding);
        }
        if (!src.parent.isEmpty()) {
            map.addProperty("parent", src.parent);
        }
        if (!ModelPoseAdapter.isDefault(src.color, 1.0f)) {
            ModelPoseAdapter.addFloatArray(map, "color", src.color);
        }
        if (src.opacity != 1.0f) {
            map.addProperty("opacity", (Number)Float.valueOf(src.opacity));
        }
        this.addBoolean(map, "mirror", src.mirror, false);
        this.addBoolean(map, "looking", src.looking, false);
        this.addBoolean(map, "idle", src.idle, false);
        this.addBoolean(map, "swinging", src.swinging, false);
        this.addBoolean(map, "swiping", src.swiping, false);
        this.addBoolean(map, "invert", src.invert, false);
        return map;
    }

    private void addBoolean(JsonObject map, String name, boolean value, boolean defaultValue) {
        map.remove(name);
        if (value != defaultValue) {
            map.addProperty(name, Boolean.valueOf(value));
        }
    }
}

