/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.models;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mchorse.metamorph.api.json.ModelAdapter;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class Model {
    public static final List<String> REQUIRED_POSES = Arrays.asList("standing", "sneaking", "sleeping", "flying");
    public String scheme = "1.3";
    public String name = "";
    public ResourceLocation defaultTexture;
    public int[] texture = new int[]{64, 32};
    public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public String model = "";
    public Map<String, Limb> limbs = new HashMap<String, Limb>();
    public Map<String, Pose> poses = new HashMap<String, Pose>();

    public static Model parse(InputStream stream) throws Exception {
        Scanner scanner = new Scanner(stream, "UTF-8");
        Model model = Model.parse(scanner.useDelimiter("\\A").next());
        scanner.close();
        return model;
    }

    public static Model parse(String json) throws Exception {
        Gson gson = new GsonBuilder().registerTypeAdapter(Model.class, (Object)new ModelAdapter()).create();
        Model data = (Model)gson.fromJson(json, Model.class);
        for (String key : REQUIRED_POSES) {
            if (data.poses.containsKey(key)) continue;
            throw new Exception(I18n.func_135052_a((String)"blockbuster.parsing.lacks_pose", (Object[])new Object[]{data.name, key}));
        }
        data.fillInMissing();
        return data;
    }

    public Limb addLimb(String name) {
        Limb limb = new Limb();
        limb.name = name;
        this.limbs.put(name, limb);
        for (Pose pose : this.poses.values()) {
            pose.limbs.put(name, new Transform());
        }
        return limb;
    }

    public void removeLimb(Limb limb) {
        this.limbs.remove(limb.name);
        ArrayList<Limb> limbsToRemove = new ArrayList<Limb>();
        for (Limb child : this.limbs.values()) {
            if (!child.parent.equals(limb.name)) continue;
            limbsToRemove.add(child);
        }
        for (Pose pose : this.poses.values()) {
            pose.limbs.remove(limb.name);
        }
        for (Limb limbToRemove : limbsToRemove) {
            this.removeLimb(limbToRemove);
        }
    }

    public void fillInMissing() {
        for (Map.Entry<String, Limb> entry : this.limbs.entrySet()) {
            String key = entry.getKey();
            for (Pose pose : this.poses.values()) {
                if (pose.limbs.containsKey(key)) continue;
                pose.limbs.put(key, new Transform());
            }
            entry.getValue().name = key;
        }
    }

    public Pose getPose(String key) {
        Pose pose = this.poses.get(key);
        return pose == null ? this.poses.get("standing") : pose;
    }

    public Model clone() {
        Model b = new Model();
        b.texture = new int[]{this.texture[0], this.texture[1]};
        b.scale = new float[]{this.scale[0], this.scale[1], this.scale[2]};
        b.name = this.name;
        b.scheme = this.scheme;
        b.model = this.model;
        b.defaultTexture = this.defaultTexture == null ? null : new ResourceLocation(this.defaultTexture.toString());
        for (Map.Entry<String, Limb> entry : this.limbs.entrySet()) {
            b.limbs.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<String, Object> entry : this.poses.entrySet()) {
            b.poses.put(entry.getKey(), ((Pose)entry.getValue()).clone());
        }
        return b;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("scheme", (Object)this.scheme).add("name", (Object)this.name).add("texture", (Object)Arrays.toString(this.texture)).add("limbs", this.limbs).add("poses", this.poses).toString();
    }

    public static class Transform {
        public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
        public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};

        public Transform clone() {
            Transform b = new Transform();
            b.translate = new float[]{this.translate[0], this.translate[1], this.translate[2]};
            b.rotate = new float[]{this.rotate[0], this.rotate[1], this.rotate[2]};
            b.scale = new float[]{this.scale[0], this.scale[1], this.scale[2]};
            return b;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("translate", (Object)this.translate).add("scale", (Object)this.scale).add("rotate", (Object)this.rotate).toString();
        }
    }

    public static class Pose {
        public float[] size = new float[]{1.0f, 1.0f, 1.0f};
        public Map<String, Transform> limbs = new HashMap<String, Transform>();

        public Pose clone() {
            Pose b = new Pose();
            b.size = new float[]{this.size[0], this.size[1], this.size[2]};
            for (Map.Entry<String, Transform> entry : this.limbs.entrySet()) {
                b.limbs.put(entry.getKey(), entry.getValue().clone());
            }
            return b;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("size", (Object)this.size).add("limbs", this.limbs).toString();
        }
    }

    public static class Limb {
        public String name = "";
        public String parent = "";
        public int[] size = new int[]{4, 4, 4};
        public int[] texture = new int[]{0, 0};
        public float[] anchor = new float[]{0.5f, 0.5f, 0.5f};
        public float[] color = new float[]{1.0f, 1.0f, 1.0f};
        public float opacity = 1.0f;
        public boolean mirror;
        public String holding = "";
        public boolean swiping;
        public boolean looking;
        public boolean swinging;
        public boolean idle;
        public boolean invert;

        public Limb clone() {
            Limb b = new Limb();
            b.anchor = new float[]{this.anchor[0], this.anchor[1], this.anchor[2]};
            b.size = new int[]{this.size[0], this.size[1], this.size[2]};
            b.texture = new int[]{this.texture[0], this.texture[1]};
            b.color = new float[]{this.color[0], this.color[1], this.color[2]};
            b.opacity = this.opacity;
            b.idle = this.idle;
            b.invert = this.invert;
            b.looking = this.looking;
            b.mirror = this.mirror;
            b.swinging = this.swinging;
            b.swiping = this.swiping;
            b.name = this.name;
            b.parent = this.parent;
            b.holding = this.holding;
            return b;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("parent", (Object)this.parent).add("size", (Object)Arrays.toString(this.size)).add("texture", (Object)Arrays.toString(this.texture)).add("anchor", (Object)Arrays.toString(this.anchor)).add("mirror", this.mirror).toString();
        }
    }
}

