/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs;

import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMorph {
    public IAbility[] abilities = new IAbility[0];
    public IAction action;
    public IAttackAbility attack;
    public int health = 20;
    public float speed = 0.1f;
    public boolean hostile = false;
    public boolean hands = false;
    public String name = "";
    @SideOnly(value=Side.CLIENT)
    public Render<? extends Entity> renderer;

    @SideOnly(value=Side.CLIENT)
    public abstract void renderOnScreen(EntityPlayer var1, int var2, int var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void render(EntityLivingBase var1, double var2, double var4, double var6, float var8, float var9);

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public void update(EntityLivingBase target, IMorphing cap) {
        if (!Metamorph.proxy.config.disable_health) {
            this.setMaxHealth(target, this.health);
        }
        if (this.speed != 0.1f) {
            target.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.speed);
        }
        for (IAbility ability : this.abilities) {
            ability.update(target);
        }
    }

    public void morph(EntityLivingBase target) {
        this.setHealth(target, this.health);
        target.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
        for (IAbility ability : this.abilities) {
            ability.onMorph(target);
        }
    }

    public void demorph(EntityLivingBase target) {
        this.setHealth(target, 20);
        for (IAbility ability : this.abilities) {
            ability.onDemorph(target);
        }
    }

    protected void updateSize(EntityLivingBase target, float width, float height) {
        if (target instanceof EntityPlayer && !Metamorph.proxy.config.disable_pov) {
            ((EntityPlayer)target).eyeHeight = height * 0.9f;
        }
        if (width != target.field_70130_N || height != target.field_70131_O) {
            AxisAlignedBB aabb = target.func_174813_aQ();
            target.field_70130_N = width;
            target.field_70131_O = height;
            target.func_174826_a(new AxisAlignedBB(target.field_70165_t - (double)(width / 2.0f), aabb.field_72338_b, target.field_70161_v - (double)(width / 2.0f), target.field_70165_t + (double)(width / 2.0f), aabb.field_72338_b + (double)height, target.field_70161_v + (double)(width / 2.0f)));
        }
    }

    protected void setHealth(EntityLivingBase target, int health) {
        if (Metamorph.proxy.config.disable_health) {
            return;
        }
        float ratio = target.func_110143_aJ() / target.func_110138_aP();
        float proportionalHealth = Math.round((float)health * ratio);
        this.setMaxHealth(target, health);
        target.func_70606_j(proportionalHealth <= 0.0f ? 1.0f : proportionalHealth);
    }

    protected void setMaxHealth(EntityLivingBase target, int health) {
        if (target.func_110138_aP() != (float)health) {
            target.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
        }
    }

    public void action(EntityLivingBase target) {
        if (this.action != null) {
            this.action.execute(target);
        }
    }

    public void attack(Entity target, EntityLivingBase source) {
        if (this.attack != null) {
            this.attack.attack(target, source);
        }
    }

    public abstract AbstractMorph clone(boolean var1);

    public abstract float getWidth(EntityLivingBase var1);

    public abstract float getHeight(EntityLivingBase var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMorph) {
            AbstractMorph morph = (AbstractMorph)obj;
            return morph.name.equals(this.name);
        }
        return super.equals(obj);
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74778_a("Name", this.name);
    }

    public void fromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("Name");
    }
}

