/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs;

import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.models.Model;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.client.gui.utils.GuiUtils;
import mchorse.metamorph.client.model.ModelCustom;
import mchorse.metamorph.client.render.RenderCustomModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomMorph
extends AbstractMorph {
    public Model model;
    public Model.Pose pose;
    public String currentPose = "";
    public boolean currentPoseOnSneak = false;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        Model data;
        ModelCustom model = ModelCustom.MODELS.get(this.name);
        if (model != null && (data = model.model) != null && data.defaultTexture != null) {
            model.pose = this.pose == null ? model.model.poses.get("standing") : this.pose;
            model.field_78095_p = 0.0f;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(data.defaultTexture);
            GuiUtils.drawModel((ModelBase)model, player, x, y, scale, alpha);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        if (this.renderer == null || !(this.renderer instanceof RenderCustomModel)) {
            return false;
        }
        RenderCustomModel renderer = (RenderCustomModel)this.renderer;
        renderer.setupModel((EntityLivingBase)player);
        if (renderer.func_177087_b() == null) {
            return false;
        }
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            renderer.renderRightArm(player);
        } else {
            renderer.renderLeftArm(player);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        RenderCustomModel render = (RenderCustomModel)this.renderer;
        render.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    @Override
    public void update(EntityLivingBase target, IMorphing cap) {
        this.updateSize(target, cap);
        super.update(target, cap);
    }

    public void updateSize(EntityLivingBase target, IMorphing cap) {
        String poseName = EntityUtils.getPose(target, this.currentPose, this.currentPoseOnSneak);
        this.pose = this.model.getPose(poseName);
        if (this.pose != null) {
            float[] pose = this.pose.size;
            this.updateSize(target, pose[0], pose[1]);
        }
    }

    @Override
    public AbstractMorph clone(boolean isRemote) {
        CustomMorph morph = new CustomMorph();
        morph.name = this.name;
        morph.abilities = this.abilities;
        morph.attack = this.attack;
        morph.action = this.action;
        morph.model = this.model;
        if (isRemote) {
            morph.renderer = this.renderer;
        }
        return morph;
    }

    @Override
    public float getWidth(EntityLivingBase target) {
        return this.pose != null ? this.pose.size[0] : 0.6f;
    }

    @Override
    public float getHeight(EntityLivingBase target) {
        return this.pose != null ? this.pose.size[1] : 1.8f;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (obj instanceof CustomMorph) {
            return equals && this.currentPose.equals(((CustomMorph)obj).currentPose);
        }
        return equals;
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        tag.func_74778_a("Pose", this.currentPose);
        tag.func_74757_a("Sneak", this.currentPoseOnSneak);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.currentPose = tag.func_74779_i("Pose");
        this.currentPoseOnSneak = tag.func_74767_n("Sneak");
    }
}

