/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client;

import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.elements.GuiOverlay;
import mchorse.metamorph.client.gui.elements.GuiSurvivalMorphs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderingHandler {
    private GuiSurvivalMorphs overlay;
    private GuiOverlay morphOverlay;
    private RenderManager manager;

    public RenderingHandler(GuiSurvivalMorphs overlay, GuiOverlay morphOverlay) {
        this.overlay = overlay;
        this.morphOverlay = morphOverlay;
        this.manager = Minecraft.func_71410_x().func_175598_ae();
    }

    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (!this.overlay.inGUI) {
                this.overlay.render(resolution.func_78326_a(), resolution.func_78328_b());
            }
            this.morphOverlay.render(resolution.func_78326_a(), resolution.func_78328_b());
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        IMorphing capability = Morphing.get(player);
        if (capability == null || !capability.isMorphed()) {
            return;
        }
        AbstractMorph morph = capability.getCurrentMorph();
        event.setCanceled(true);
        morph.render((EntityLivingBase)player, event.getX(), event.getY(), event.getZ(), player.field_70177_z, event.getPartialRenderTick());
    }

    @SubscribeEvent
    public void onNameRender(RenderLivingEvent.Specials.Pre<EntityLivingBase> event) {
        float factor;
        boolean canRenderName;
        EntityLivingBase render = EntityMorph.renderEntity;
        if (render == null) {
            return;
        }
        event.setCanceled(true);
        EntityLivingBase entity = event.getEntity();
        boolean bl = canRenderName = Minecraft.func_71382_s() && render != this.manager.field_78734_h && !entity.func_184207_aI();
        if (!canRenderName) {
            return;
        }
        double dist = entity.func_70068_e(this.manager.field_78734_h);
        float f = factor = entity.func_70093_af() ? 32.0f : 64.0f;
        if (dist < (double)(factor * factor)) {
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.renderEntityName(entity, render.func_145748_c_().func_150254_d(), event.getX(), event.getY(), event.getZ());
        }
    }

    protected void renderEntityName(EntityLivingBase entity, String name, double x, double y, double z) {
        if (name.isEmpty()) {
            return;
        }
        int maxDistance = 64;
        double dist = entity.func_70068_e(this.manager.field_78734_h);
        if (dist <= (double)(maxDistance * maxDistance)) {
            this.renderNameplate(entity, name, x, y, z, maxDistance);
        }
    }

    protected void renderNameplate(EntityLivingBase entityIn, String str, double x, double y, double z, int maxDistance) {
        boolean flag = entityIn.func_70093_af();
        GlStateManager.func_179094_E();
        float f = flag ? 0.25f : 0.0f;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + entityIn.field_70131_O + 0.5f - f), (float)((float)z));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.manager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.manager.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.manager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        if (!flag) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = str.equals("deadmau5") ? -10 : 0;
        FontRenderer fontrenderer = this.manager.func_78716_a();
        int j = fontrenderer.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        if (!flag) {
            fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, flag ? 0x20FFFFFF : -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

