/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.elements;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import mchorse.metamorph.api.MorphList;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.client.gui.utils.GuiScrollPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GuiCreativeMorphs
extends GuiScrollPane {
    private static final int cellH = 60;
    private int perRow;
    private int selected = -1;
    private int selectedMorph = -1;
    private String previousFilter = "";
    private List<MorphCategory> categories = new ArrayList<MorphCategory>();
    public int shiftX = 0;

    public GuiCreativeMorphs(int perRow, AbstractMorph selected, IMorphing morphing) {
        this.perRow = perRow;
        this.compileCategories(morphing);
        this.initiateCategories(selected);
        this.setScrollSpeed(4);
    }

    public GuiCreativeMorphs(int perRow, AbstractMorph selected) {
        this(perRow, selected, null);
    }

    protected void compileCategories(IMorphing morphing) {
        HashMap<String, MorphCategory> categories = new HashMap<String, MorphCategory>();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (List<MorphList.MorphCell> morphs : MorphManager.INSTANCE.getMorphs((World)world).morphs.values()) {
            for (MorphList.MorphCell morph : morphs) {
                MorphCategory category = (MorphCategory)categories.get(morph.category);
                if (category == null) {
                    category = new MorphCategory(morph.category, morph.category);
                    categories.put(morph.category, category);
                }
                String variant = morph.variant.isEmpty() ? morph.variant : " (" + morph.variant + ")";
                String title = MorphManager.INSTANCE.morphDisplayNameFromMorph(morph.morph) + variant;
                category.cells.add(new MorphCell(title, morph.morph, 0));
            }
        }
        this.categories.addAll(categories.values());
        Collections.sort(this.categories, new Comparator<MorphCategory>(){

            @Override
            public int compare(MorphCategory a, MorphCategory b) {
                return a.title.compareTo(b.title);
            }
        });
        if (morphing != null) {
            MorphCategory category = new MorphCategory("acquired", "acquired");
            this.categories.add(0, category);
            for (AbstractMorph morph : morphing.getAcquiredMorphs()) {
                category.cells.add(new MorphCell(MorphManager.INSTANCE.morphDisplayNameFromMorph(morph), morph, 0));
            }
        }
    }

    protected void initiateCategories(AbstractMorph morph) {
        int i = 0;
        int y = 0;
        int selectedCat = -1;
        int selectedMorph = -1;
        this.scrollHeight = 0;
        for (MorphCategory category : this.categories) {
            int j = 0;
            Collections.sort(category.cells, new Comparator<MorphCell>(){

                @Override
                public int compare(MorphCell a, MorphCell b) {
                    return a.name.compareTo(b.name);
                }
            });
            category.height = MathHelper.func_76123_f((float)((float)category.cells.size() / (float)this.perRow));
            category.y = this.scrollHeight + 20;
            this.scrollHeight += category.height * 60 + 20;
            for (MorphCell cell : category.cells) {
                if (selectedCat == -1 && morph != null && cell.morph.equals(morph)) {
                    selectedCat = i;
                    selectedMorph = j;
                    y = category.y + j / this.perRow * 60;
                }
                cell.index = j++;
            }
            ++i;
        }
        this.scrollHeight += 10;
        this.scrollTo(y);
        this.selected = selectedCat;
        this.selectedMorph = selectedMorph;
    }

    public void setFilter(String filter) {
        if (filter.equals(this.previousFilter)) {
            return;
        }
        this.scrollY = 0;
        this.scrollHeight = 0;
        this.previousFilter = filter;
        for (MorphCategory cat : this.categories) {
            int i = 0;
            for (MorphCell cell : cat.cells) {
                boolean bl = filter.isEmpty() ? false : (cell.hidden = cell.name.toLowerCase().indexOf(filter.toLowerCase()) == -1);
                if (cell.hidden) continue;
                ++i;
            }
            cat.height = MathHelper.func_76123_f((float)((float)i / (float)this.perRow));
            cat.y = this.scrollHeight + 20;
            this.scrollHeight += i == 0 ? 0 : cat.height * 60 + 20;
        }
    }

    public void setSelected(AbstractMorph morph) {
        this.initiateCategories(morph);
    }

    public MorphCell getSelected() {
        if (this.selected >= 0 && this.selected < this.categories.size()) {
            MorphCategory category = this.categories.get(this.selected);
            if (this.selectedMorph >= 0 && this.selectedMorph < category.cells.size()) {
                return category.cells.get(this.selectedMorph);
            }
        }
        return null;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.isInside(mouseX, mouseY) || this.dragging) {
            return;
        }
        int y = mouseY - this.y + this.scrollY - 10;
        int x = (mouseX - this.x) / (this.w / this.perRow);
        int i = 0;
        MorphCategory cat = null;
        for (MorphCategory category : this.categories) {
            if (y >= category.y && y < category.y + category.height * 60) {
                cat = category;
                break;
            }
            ++i;
        }
        if (cat != null) {
            y = (y - cat.y) / 60;
            this.selected = i;
            this.selectedMorph = -1;
            int j = 0;
            int index = x + y * this.perRow;
            for (MorphCell cell : cat.cells) {
                if (cell.hidden) continue;
                if (j == index) {
                    this.selectedMorph = cell.index;
                    break;
                }
                ++j;
            }
        } else {
            this.selected = -1;
            this.selectedMorph = -1;
        }
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawPane(int mouseX, int mouseY, float partialTicks) {
        int m = this.w / this.perRow;
        int j = 0;
        for (MorphCategory category : this.categories) {
            int h = (MathHelper.func_76123_f((float)(category.cells.size() / this.perRow)) + 1) * 60;
            if (category.height == 0 || category.y < this.scrollY - h || category.y > this.scrollY + this.h) {
                ++j;
                continue;
            }
            int k = 0;
            this.func_73731_b(this.field_146289_q, category.title, this.x + this.shiftX + 1, category.y + this.y, -1);
            for (MorphCell cell : category.cells) {
                int x = k % this.perRow * m + this.x;
                int y = k / this.perRow * 60 + category.y + this.y;
                if (cell.hidden) continue;
                if (y < this.scrollY - 15) {
                    ++k;
                    continue;
                }
                float scale = 21.5f;
                cell.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, x + m / 2, y + 50, scale);
                if (j == this.selected && cell.index == this.selectedMorph) {
                    this.renderSelected(x + 1, y + 10, m - 2, 60, cell.error);
                }
                ++k;
            }
            ++j;
        }
    }

    private void renderSelected(int x, int y, int width, int height, boolean error) {
        int color = error ? -65536 : -3355444;
        this.func_73730_a(x, x + width - 1, y, color);
        this.func_73730_a(x, x + width - 1, y + height - 1, color);
        this.func_73728_b(x, y, y + height - 1, color);
        this.func_73728_b(x + width - 1, y, y + height - 1, color);
    }

    public static class MorphCell {
        public String name;
        public AbstractMorph morph;
        public int index;
        public boolean hidden = false;
        public boolean first = true;
        public boolean error = false;

        public MorphCell(String name, AbstractMorph morph, int index) {
            this.name = name;
            this.morph = morph;
            this.index = index;
        }

        public void render(EntityPlayer player, int x, int y, float scale) {
            if (this.first) {
                try {
                    this.morph.renderOnScreen(player, x, y, scale, 1.0f);
                }
                catch (Exception e) {
                    String name = this.morph != null ? this.morph.name : "unknown";
                    System.out.println("Failed to render morph by name " + name + "!");
                    e.printStackTrace();
                    this.error = true;
                }
                this.first = false;
            } else if (!this.error) {
                this.morph.renderOnScreen(player, x, y, scale, 1.0f);
            }
        }
    }

    public static class MorphCategory {
        public static final String KEY = "morph.category.";
        public List<MorphCell> cells = new ArrayList<MorphCell>();
        public String title;
        public String key;
        public int height;
        public int y;

        public MorphCategory(String title, String key) {
            String result = I18n.func_135052_a((String)(KEY + title), (Object[])new Object[0]);
            if (title.isEmpty()) {
                result = I18n.func_135052_a((String)"morph.category.unknown", (Object[])new Object[0]);
            } else if (result.equals(KEY + title)) {
                result = I18n.func_135052_a((String)"morph.category.modded", (Object[])new Object[]{title});
            }
            this.title = result;
            this.key = key;
        }
    }
}

