/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import mchorse.metamorph.client.gui.utils.GuiUtils;
import mchorse.metamorph.network.Dispatcher;
import mchorse.metamorph.network.common.PacketFavoriteMorph;
import mchorse.metamorph.network.common.PacketRemoveMorph;
import mchorse.metamorph.network.common.PacketSelectMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiSurvivalMorphs
extends Gui {
    private MorphCell latest;
    private Map<Integer, MorphRemove> toRemove = new HashMap<Integer, MorphRemove>();
    public boolean inGUI = false;
    public boolean showFavorites = false;
    public Minecraft mc = Minecraft.func_71410_x();
    public List<MorphType> morphs = new ArrayList<MorphType>();
    public int index = 0;
    public int timer = 0;

    public void setupMorphs(IMorphing morphing) {
        HashMap<String, MorphType> separated = new HashMap<String, MorphType>();
        List<Integer> favorites = morphing.getFavorites();
        int i = 0;
        for (AbstractMorph morph : morphing.getAcquiredMorphs()) {
            MorphType list = (MorphType)separated.get(morph.name);
            if (list == null) {
                list = new MorphType();
                separated.put(morph.name, list);
            }
            list.morphs.add(new MorphCell(i, morph, favorites.indexOf(i) >= 0));
            ++i;
        }
        this.morphs.clear();
        this.morphs.addAll(separated.values());
        if (this.showFavorites) {
            Iterator<MorphType> it = this.morphs.iterator();
            while (it.hasNext()) {
                MorphType type = it.next();
                if (!type.hasFavorites()) {
                    it.remove();
                    continue;
                }
                Iterator<MorphCell> cellIt = type.morphs.iterator();
                while (cellIt.hasNext()) {
                    if (cellIt.next().favorite) continue;
                    cellIt.remove();
                }
            }
        }
        int j = 0;
        for (MorphType type : this.morphs) {
            for (MorphCell cell : type.morphs) {
                cell.typeIndex = j;
            }
            ++j;
        }
        Collections.sort(this.morphs, new Comparator<MorphType>(){

            @Override
            public int compare(MorphType a, MorphType b) {
                return a.morphs.get((int)0).morph.name.compareTo(b.morphs.get((int)0).morph.name);
            }
        });
        this.index = MathHelper.func_76125_a((int)this.index, (int)-1, (int)(this.getMorphCount() - 1));
    }

    public void skip(int factor) {
        int length = this.getMorphCount();
        this.timer = this.getDelay();
        if (length == 0) {
            return;
        }
        this.timer = this.getDelay();
        if (factor > 0) {
            this.index = length - 1;
        } else if (factor < 0) {
            this.index = -1;
        }
    }

    public void advance(int factor) {
        int length = this.getMorphCount();
        if (length == 0) {
            return;
        }
        this.timer = this.getDelay();
        this.index += factor;
        this.index = MathHelper.func_76125_a((int)this.index, (int)-1, (int)(length - 1));
    }

    public void up() {
        this.timer = this.getDelay();
        if (this.index >= 0) {
            this.morphs.get(this.index).up();
        }
    }

    public void down() {
        this.timer = this.getDelay();
        if (this.index >= 0) {
            this.morphs.get(this.index).down();
        }
    }

    public void favorite(int index) {
        if (this.latest != null && this.latest.index == index) {
            boolean bl = this.latest.favorite = Morphing.get((EntityPlayer)this.mc.field_71439_g).getFavorites().indexOf(index) >= 0;
            if (this.showFavorites && !this.latest.favorite) {
                this.toRemove.put(index, new MorphRemove(index, this.latest.typeIndex));
                this.remove(index);
            }
            this.latest = null;
        }
    }

    public void remove(int index) {
        MorphRemove toRemove = this.toRemove.get(index);
        if (toRemove != null) {
            MorphType type = this.morphs.get(toRemove.typeIndex);
            Iterator<MorphCell> it = type.morphs.iterator();
            while (it.hasNext()) {
                if (it.next().index != index) continue;
                it.remove();
                break;
            }
            if (type.morphs.isEmpty()) {
                this.morphs.remove(toRemove.typeIndex);
            } else {
                type.clamp();
            }
            this.toRemove.remove(index);
            this.setupMorphs(Morphing.get((EntityPlayer)this.mc.field_71439_g));
            this.index = MathHelper.func_76125_a((int)this.index, (int)-1, (int)(this.getMorphCount() - 1));
        }
    }

    private int getDelay() {
        int frameRate = this.mc.field_71474_y.field_74350_i;
        if (frameRate > 120) {
            frameRate = 120;
        }
        return frameRate * 2;
    }

    private int getMorphCount() {
        return this.morphs.size();
    }

    public void selectCurrent() {
        IMorphing morphing = Morphing.get((EntityPlayer)this.mc.field_71439_g);
        boolean isSame = false;
        boolean morphed = morphing.isMorphed();
        int index = this.getSelected();
        if (index == -1) {
            boolean bl = isSame = !morphed;
        }
        if (index >= 0 && morphed) {
            isSame = morphing.getCurrentMorph().equals(morphing.getAcquiredMorphs().get(index));
        }
        if (!isSame) {
            Dispatcher.sendToServer(new PacketSelectMorph(index));
            this.timer = 0;
        }
    }

    public int getSelected() {
        return this.index == -1 ? -1 : this.morphs.get((int)this.index).current().index;
    }

    public MorphCell getCurrent() {
        if (this.index < 0) {
            return null;
        }
        if (this.morphs.isEmpty() || this.index >= this.morphs.size()) {
            return null;
        }
        return this.morphs.get(this.index).current();
    }

    public void exitGUI() {
        this.timer = 0;
        this.inGUI = false;
    }

    public void remove() {
        if (this.index == -1) {
            return;
        }
        int index = this.getSelected();
        if (!this.toRemove.containsKey(index)) {
            this.toRemove.put(index, new MorphRemove(index, this.index));
            Dispatcher.sendToServer(new PacketRemoveMorph(index));
        }
    }

    public void favorite(MorphCell cell) {
        if (this.latest == null) {
            this.latest = cell;
            this.latest.favorite = !this.latest.favorite;
            Dispatcher.sendToServer(new PacketFavoriteMorph(cell.index));
        }
    }

    public void toggleFavorites() {
        this.showFavorites = !this.showFavorites;
        this.setupMorphs(Morphing.get((EntityPlayer)this.mc.field_71439_g));
    }

    public void render(int width, int height) {
        if (!this.inGUI && this.timer <= 0) {
            return;
        }
        --this.timer;
        int w = (int)((float)width * 0.8f);
        int h = (int)((float)height * 0.3f);
        w -= w % 20;
        h -= h % 2;
        int x1 = width / 2 - w / 2;
        int y1 = height / 2 - h / 2;
        int x2 = width / 2 + w / 2;
        int y2 = height / 2 + h / 2;
        if (this.inGUI) {
            GuiUtils.scissor(0, 30, width, height - 30, width, height);
            w = width - 20;
            h = (int)((float)height * 0.375f);
        } else {
            Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)-1728053248);
            GuiUtils.scissor(x1, y1, w, h, width, height);
        }
        this.renderMenu(width, height, w, h);
        GlStateManager.func_179126_j();
    }

    public void renderMenu(int width, int height, int w, int h) {
        boolean renderDemorph = Metamorph.proxy.config.show_demorph;
        EntityPlayerSP player = this.mc.field_71439_g;
        String label = "Demorph";
        int scale = (int)((float)height * 0.17f / 2.0f);
        int margin = width / 10;
        scale -= scale % 2;
        margin -= margin % 2;
        if (this.inGUI) {
            margin = width / 7;
            scale = (int)((double)((float)height * 0.17f) / 1.4);
        }
        int offset = this.index * margin;
        int maxScroll = this.getMorphCount() * margin - w / 2 - margin / 2 + 2 - (renderDemorph ? 0 : margin);
        offset = (int)MathHelper.func_76131_a((float)offset, (float)0.0f, (float)maxScroll);
        int c = this.morphs.size();
        for (int i = 0; i <= c; ++i) {
            String name;
            boolean selected;
            int x = width / 2 - w / 2 + (renderDemorph ? i : i - 1) * margin + margin / 2 + 1;
            int y = height / 2 + h / 5;
            boolean bl = selected = this.index + 1 == i;
            if ((double)offset > (double)(w / 2) - (double)margin * 1.5) {
                x = (int)((double)x - ((double)offset - ((double)(w / 2) - (double)margin * 1.5)));
            }
            MorphType type = i != 0 ? this.morphs.get(i - 1) : null;
            AbstractMorph morph = i != 0 ? type.current().morph : null;
            String string = name = Metamorph.proxy.config.hide_username ? "Demorph" : player.func_70005_c_();
            if (i != 0) {
                name = MorphManager.INSTANCE.morphDisplayNameFromMorph(morph);
            }
            if (i == 0) {
                if (renderDemorph) {
                    this.renderPlayer((EntityPlayer)player, x, y - 2, scale);
                }
            } else {
                boolean renderUp = type.index < type.morphs.size() - 1;
                boolean renderDown = type.index > 0;
                int shift = this.inGUI ? h : (int)((double)scale * 2.5);
                this.renderMorph((EntityPlayer)player, type.current(), x, y - 2, margin, h, scale);
                if (selected) {
                    int ay;
                    if (renderUp) {
                        this.renderMorph((EntityPlayer)player, type.morphs.get(type.index + 1), x, y - shift, margin, h, scale);
                        ay = height / 2 - h / 2 + 4;
                        Gui.func_73734_a((int)(x - 1), (int)ay, (int)(x + 1), (int)(ay + 1), (int)-1);
                        Gui.func_73734_a((int)(x - 2), (int)(ay + 1), (int)(x + 2), (int)(ay + 2), (int)-1);
                        Gui.func_73734_a((int)(x - 3), (int)(ay + 2), (int)(x + 3), (int)(ay + 3), (int)-1);
                    }
                    if (renderDown) {
                        this.renderMorph((EntityPlayer)player, type.morphs.get(type.index - 1), x, y + shift, margin, h, scale);
                        ay = height / 2 + h / 2 - 7;
                        Gui.func_73734_a((int)(x - 3), (int)ay, (int)(x + 3), (int)(ay + 1), (int)-1);
                        Gui.func_73734_a((int)(x - 2), (int)(ay + 1), (int)(x + 2), (int)(ay + 2), (int)-1);
                        Gui.func_73734_a((int)(x - 1), (int)(ay + 2), (int)(x + 1), (int)(ay + 3), (int)-1);
                    }
                }
            }
            if (!selected) continue;
            if (i != 0 || i == 0 && renderDemorph) {
                this.renderSelected(x - margin / 2, height / 2 - h / 2 + 1, margin, h - 2);
            }
            label = name;
        }
        GL11.glDisable((int)3089);
        int labelY = this.inGUI ? height - 24 : height / 2 + h / 2 + 4;
        this.func_73732_a(this.mc.field_71466_p, label, width / 2, labelY, -1);
    }

    public void renderSelected(int x, int y, int width, int height) {
        int color = -3355444;
        this.func_73730_a(x, x + width - 1, y, color);
        this.func_73730_a(x, x + width - 1, y + height - 1, color);
        this.func_73728_b(x, y, y + height - 1, color);
        this.func_73728_b(x + width - 1, y, y + height - 1, color);
    }

    public void renderMorph(EntityPlayer player, MorphCell morph, int x, int y, int w, int h, float scale) {
        morph.morph.renderOnScreen(player, x, y, scale, 1.0f);
        if (morph.favorite) {
            GlStateManager.func_179141_d();
            this.mc.field_71446_o.func_110577_a(new ResourceLocation("metamorph", "textures/gui/icons.png"));
            if (this.inGUI) {
                this.func_175174_a(x + w / 2 - 16, (float)y - (float)h / 1.5f, 0, 0, 16, 16);
            } else {
                this.func_73729_b(x - w / 2, y - 16, 0, 0, 16, 16);
            }
        }
    }

    public void renderPlayer(EntityPlayer player, int x, int y, int scale) {
        EntityPlayerSP entity = (EntityPlayerSP)player;
        RenderLivingBase render = (RenderLivingBase)this.mc.func_175598_ae().func_78713_a((Entity)entity);
        ModelBase model = render.func_177087_b();
        model.field_78091_s = false;
        model.field_78095_p = 0.0f;
        this.mc.field_71446_o.func_110577_a(entity.func_110306_p());
        GuiUtils.drawModel(model, player, x, y, scale);
    }

    public void clickMorph(int mouseX, int mouseY, int width, int height) {
        int w = width - 20;
        int h = (int)((float)height * 0.375f);
        boolean renderDemorph = Metamorph.proxy.config.show_demorph;
        int scale = (int)((float)height * 0.17f / 2.0f);
        int margin = width / 10;
        scale -= scale % 2;
        margin -= margin % 2;
        if (this.inGUI) {
            margin = width / 7;
            scale = (int)((double)((float)height * 0.17f) / 1.4);
        }
        int offset = this.index * margin;
        int maxScroll = this.getMorphCount() * margin - w / 2 - margin / 2 + 2;
        offset = (int)MathHelper.func_76131_a((float)offset, (float)0.0f, (float)maxScroll);
        int x = mouseX - 10;
        int y = mouseY - (height / 2 - h / 2);
        if (!renderDemorph) {
            x += margin;
        }
        if ((double)offset > (double)(w / 2) - (double)margin * 1.5) {
            x = (int)((double)x + ((double)offset - ((double)(w / 2) - (double)margin * 1.5)));
        }
        int index = x / margin - 1;
        if (y >= 0 && y < h) {
            if (index < this.getMorphCount() && index >= -1) {
                this.index = index;
            }
        } else if (index != -1 && this.index == index) {
            MorphType morph = this.morphs.get(index);
            if (y < 0) {
                morph.up();
            } else if (y > h) {
                morph.down();
            }
        }
    }

    public static class MorphRemove {
        public int index;
        public int typeIndex;

        public MorphRemove(int index, int typeIndex) {
            this.index = index;
            this.typeIndex = typeIndex;
        }
    }

    public static class MorphCell {
        public int index;
        public int typeIndex;
        public boolean favorite;
        public AbstractMorph morph;

        public MorphCell(int index, AbstractMorph morph, boolean favorite) {
            this.index = index;
            this.morph = morph;
            this.favorite = favorite;
        }
    }

    public static class MorphType {
        public List<MorphCell> morphs = new ArrayList<MorphCell>();
        public int index;

        public MorphCell current() {
            return this.morphs.get(this.index);
        }

        public boolean hasFavorites() {
            for (MorphCell cell : this.morphs) {
                if (!cell.favorite) continue;
                return true;
            }
            return false;
        }

        public void remove() {
            this.morphs.remove(this.index);
            this.clamp();
        }

        public void up() {
            ++this.index;
            this.clamp();
        }

        public void down() {
            --this.index;
            this.clamp();
        }

        public void clamp() {
            this.index = MathHelper.func_76125_a((int)this.index, (int)0, (int)(this.morphs.size() - 1));
        }
    }
}

