/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.gui.utils;

import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScrollPane
extends GuiScreen {
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected int scrollY = 0;
    protected int scrollHeight = 0;
    protected int scrollSpeed = 2;
    protected boolean dragging = false;
    protected boolean hidden = false;
    public boolean scrollOutside = false;

    public void updateRect(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void setHeight(int height) {
        this.scrollHeight = height;
        this.scrollBy(0);
    }

    public int getHeight() {
        return this.scrollHeight;
    }

    public boolean isInside(int x, int y) {
        return !this.hidden && x >= this.x && x <= this.x + this.w && y >= this.y && y <= this.y + this.h;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setScrollSpeed(int speed) {
        this.scrollSpeed = speed;
    }

    public void scrollBy(int y) {
        this.scrollTo(this.scrollY + y);
    }

    public void scrollTo(int y) {
        this.scrollY = this.scrollHeight > this.h ? MathHelper.func_76125_a((int)y, (int)0, (int)(this.scrollHeight - this.h + 2)) : 0;
    }

    public void func_146274_d() throws IOException {
        int scroll;
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if ((this.scrollOutside || this.isInside(x, y)) && (scroll = -Mouse.getEventDWheel()) != 0 && this.scrollHeight > this.h) {
            this.scrollBy((int)Math.copySign(this.scrollSpeed, scroll));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseY < this.y || mouseY > this.y + this.h) {
            return;
        }
        int x = this.x + this.w - 8;
        int y = this.y + 3;
        if (mouseX >= x && mouseX <= x + 5 && mouseY >= y && mouseY <= y + this.h - 6) {
            this.dragging = true;
        }
        super.func_73864_a(mouseX, mouseY + this.scrollY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.dragging = false;
        if (mouseY < this.y || mouseY > this.y + this.h) {
            return;
        }
        super.func_146286_b(mouseX, mouseY + this.scrollY, state);
    }

    protected abstract void drawPane(int var1, int var2, float var3);

    protected void drawBackground() {
        Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)-6250336);
        Gui.func_73734_a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.w - 1), (int)(this.y + this.h - 1), (int)-16777216);
    }

    protected void drawScrollBar() {
        if (this.scrollHeight < this.h) {
            return;
        }
        float progress = (float)this.scrollY / (float)(this.scrollHeight - this.h + 2);
        int x = this.x + this.w - 8;
        float y = (float)(this.y + 3) + progress * (float)(this.h - 26);
        Gui.func_73734_a((int)x, (int)((int)y), (int)(x + 5), (int)((int)y + 20), (int)-6250336);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.hidden) {
            return;
        }
        if (this.dragging) {
            int y = mouseY - this.y - 3;
            int h = this.h - 26;
            float progress = (float)y / (float)h;
            this.scrollTo((int)(progress * (float)(this.scrollHeight - this.h + 2)));
        }
        float rx = (float)this.field_146297_k.field_71443_c / (float)this.field_146294_l;
        float ry = (float)this.field_146297_k.field_71440_d / (float)this.field_146295_m;
        this.drawBackground();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-this.scrollY), (float)0.0f);
        int x = (int)((float)(this.x + 1) * rx);
        int y = (int)((float)this.field_146297_k.field_71440_d - (float)(this.y + this.h - 1) * ry);
        int w = (int)((float)(this.w - 2) * rx);
        int h = (int)((float)(this.h - 2) * ry);
        GL11.glScissor((int)x, (int)y, (int)w, (int)h);
        GL11.glEnable((int)3089);
        this.drawPane(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY + this.scrollY, partialTicks);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
        this.drawScrollBar();
    }
}

