/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.model;

import java.util.HashMap;
import java.util.Map;
import mchorse.metamorph.api.models.Model;
import mchorse.metamorph.client.model.ModelCustomRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCustom
extends ModelBiped {
    public static Map<String, ModelCustom> MODELS = new HashMap<String, ModelCustom>();
    public Model model;
    public Model.Pose pose;
    public ModelCustomRenderer[] limbs;
    public ModelCustomRenderer[] renderable;
    public ModelCustomRenderer[] left;
    public ModelCustomRenderer[] right;

    public ModelCustom(Model model) {
        this.model = model;
        this.field_78090_t = model.texture[0];
        this.field_78089_u = model.texture[1];
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        for (ModelCustomRenderer limb : this.renderable) {
            limb.func_78785_a(scale);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        for (ModelCustomRenderer limb : this.limbs) {
            boolean mirror = limb.limb.mirror;
            boolean invert = limb.limb.invert;
            float factor = mirror ^ invert ? -1.0f : 1.0f;
            float PI = (float)Math.PI;
            this.applyLimbPose(limb);
            if (limb.limb.looking) {
                limb.field_78795_f += headPitch * ((float)Math.PI / 180);
                limb.field_78796_g += netHeadYaw * ((float)Math.PI / 180);
            }
            if (limb.limb.swinging) {
                boolean flag = entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184599_cB() > 4;
                float f = 1.0f;
                if (flag) {
                    f = (float)(entityIn.field_70159_w * entityIn.field_70159_w + entityIn.field_70181_x * entityIn.field_70181_x + entityIn.field_70179_y * entityIn.field_70179_y);
                    f /= 0.2f;
                    f = f * f * f;
                }
                if (f < 1.0f) {
                    f = 1.0f;
                }
                float f2 = mirror ^ invert ? 1.0f : 0.0f;
                float f3 = limb.limb.holding.isEmpty() ? 1.4f : 1.0f;
                limb.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + PI * f2)) * f3 * limbSwingAmount / f;
            }
            if (limb.limb.idle) {
                limb.field_78808_h += (MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f) * factor;
                limb.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f * factor;
            }
            if (limb.limb.swiping && this.field_78095_p > 0.0f) {
                float swing = this.field_78095_p;
                float bodyY = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * PI * 2.0f)) * 0.2f;
                swing = 1.0f - swing;
                swing = swing * swing * swing;
                swing = 1.0f - swing;
                float sinSwing = MathHelper.func_76126_a((float)(swing * PI));
                float sinSwing2 = MathHelper.func_76126_a((float)(this.field_78095_p * PI)) * 0.7f * 0.75f;
                limb.field_78795_f -= sinSwing * 1.2f + sinSwing2;
                limb.field_78796_g += bodyY * 2.0f * factor;
                limb.field_78808_h += MathHelper.func_76126_a((float)(this.field_78095_p * PI)) * -0.4f * factor;
            }
            if (limb.limb.holding.isEmpty() || !limb.limb.parent.isEmpty()) continue;
            boolean right = limb.limb.holding.equals("right");
            ModelBiped.ArmPose pose = right ? this.field_187076_m : this.field_187075_l;
            ModelBiped.ArmPose opposite = right ? this.field_187075_l : this.field_187076_m;
            switch (pose) {
                case BLOCK: {
                    limb.field_78795_f = limb.field_78795_f * 0.5f - 0.9424779f;
                    limb.field_78796_g = 0.5235988f * (float)(right ? -1 : 1);
                    break;
                }
                case ITEM: {
                    limb.field_78795_f = limb.field_78795_f * 0.5f - PI / 10.0f;
                }
            }
            float rotateAngleX = headPitch * ((float)Math.PI / 180);
            float rotateAngleY = netHeadYaw * ((float)Math.PI / 180);
            if (right && pose == ModelBiped.ArmPose.BOW_AND_ARROW) {
                limb.field_78796_g = -0.1f + rotateAngleY - 0.4f;
                limb.field_78796_g = 0.1f + rotateAngleY;
                limb.field_78795_f = -1.5707964f + rotateAngleX;
                limb.field_78795_f = -1.5707964f + rotateAngleX;
                continue;
            }
            if (right || opposite != ModelBiped.ArmPose.BOW_AND_ARROW) continue;
            limb.field_78796_g = -0.1f + rotateAngleY;
            limb.field_78796_g = 0.1f + rotateAngleY + 0.4f;
            limb.field_78795_f = -1.5707964f + rotateAngleX;
            limb.field_78795_f = -1.5707964f + rotateAngleX;
        }
    }

    public void applyLimbPose(ModelCustomRenderer limb) {
        limb.applyTransform(this.pose.limbs.get(limb.limb.name));
    }

    public ModelCustomRenderer[] getRenderForArm(EnumHandSide side) {
        if (side == EnumHandSide.LEFT) {
            return this.left;
        }
        if (side == EnumHandSide.RIGHT) {
            return this.right;
        }
        return null;
    }
}

