/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.model.parsing;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.models.Model;
import mchorse.metamorph.client.model.ModelCustom;
import mchorse.metamorph.client.model.ModelCustomRenderer;
import mchorse.metamorph.client.model.parsing.IModelCustom;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelParser {
    public static void parse(String key, Model data) {
        ModelParser.parse(key, data, ModelCustom.class);
    }

    public static void parse(String key, Model data, Class<? extends ModelCustom> clazz) {
        try {
            ModelCustom model = new ModelParser().parseModel(data, clazz);
            ModelCustom.MODELS.put(key, model);
        }
        catch (Exception e) {
            System.out.println("Model for key '" + key + "' couldn't converted to ModelCustom!");
            e.printStackTrace();
        }
    }

    public ModelCustom parseModel(Model data, Class<? extends ModelCustom> clazz) throws Exception {
        ModelCustom model = clazz.getConstructor(Model.class).newInstance(data);
        this.generateLimbs(data, model);
        if (model instanceof IModelCustom) {
            IModelCustom result = (IModelCustom)((Object)model);
            result.onGenerated();
        }
        return model;
    }

    private void generateLimbs(Model data, ModelCustom model) {
        Model.Limb limb;
        HashMap<String, ModelCustomRenderer> limbs = new HashMap<String, ModelCustomRenderer>();
        ArrayList<Model.Limb> renderable = new ArrayList<Model.Limb>();
        ArrayList<ModelCustomRenderer> left = new ArrayList<ModelCustomRenderer>();
        ArrayList<ModelCustomRenderer> right = new ArrayList<ModelCustomRenderer>();
        Model.Pose standing = data.poses.get("standing");
        for (Map.Entry<String, Model.Limb> entry : data.limbs.entrySet()) {
            limb = entry.getValue();
            Model.Transform transform = standing.limbs.get(entry.getKey());
            ModelCustomRenderer renderer = new ModelCustomRenderer((ModelBase)model, limb, transform);
            float w = limb.size[0];
            float h = limb.size[1];
            float d = limb.size[2];
            float ax = 1.0f - limb.anchor[0];
            float ay = limb.anchor[1];
            float az = limb.anchor[2];
            renderer.field_78809_i = limb.mirror;
            renderer.func_78789_a(-ax * w, -ay * h, -az * d, (int)w, (int)h, (int)d);
            renderer.applyTransform(transform);
            if (limb.holding.equals("left")) {
                left.add(renderer);
            }
            if (limb.holding.equals("right")) {
                right.add(renderer);
            }
            limbs.put(entry.getKey(), renderer);
        }
        for (Map.Entry<String, Model.Limb> entry : limbs.entrySet()) {
            limb = data.limbs.get(entry.getKey());
            if (!limb.parent.isEmpty()) {
                ((ModelCustomRenderer)((Object)limbs.get(limb.parent))).func_78792_a((ModelRenderer)entry.getValue());
            } else {
                renderable.add(entry.getValue());
            }
            if (!(model instanceof IModelCustom)) continue;
            try {
                Field field = ((Object)((Object)model)).getClass().getField(entry.getKey());
                field.set((Object)model, entry.getValue());
            }
            catch (Exception e) {
                Metamorph.log("No fields '" + entry.getKey() + "' was found for " + ((Object)((Object)model)).getClass().getSimpleName());
            }
        }
        model.left = left.toArray(new ModelCustomRenderer[left.size()]);
        model.right = right.toArray(new ModelCustomRenderer[right.size()]);
        model.limbs = limbs.values().toArray(new ModelCustomRenderer[limbs.size()]);
        model.renderable = renderable.toArray(new ModelCustomRenderer[renderable.size()]);
    }
}

