/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.client.render;

import java.util.Map;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.models.Model;
import mchorse.metamorph.api.morphs.CustomMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.MorphingProvider;
import mchorse.metamorph.client.model.ModelCustom;
import mchorse.metamorph.client.model.ModelCustomRenderer;
import mchorse.metamorph.client.render.layers.LayerHeldItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class RenderCustomModel
extends RenderLivingBase<EntityLivingBase> {
    public RenderCustomModel(RenderManager renderManagerIn, ModelBase modelBaseIn, float shadowSizeIn) {
        super(renderManagerIn, null, shadowSizeIn);
        this.func_177094_a(new LayerHeldItem(this));
    }

    protected ResourceLocation getEntityTexture(EntityLivingBase entity) {
        return this.field_77045_g == null ? null : ((ModelCustom)this.field_77045_g).model.defaultTexture;
    }

    protected boolean func_177070_b(EntityLivingBase entity) {
        return super.func_177070_b(entity) && entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.setupModel(entity);
        if (this.field_77045_g != null) {
            this.setHands(entity);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    private void setHands(EntityLivingBase entity) {
        ItemStack rightItem = entity.func_184614_ca();
        ItemStack leftItem = entity.func_184592_cb();
        ModelBiped.ArmPose right = ModelBiped.ArmPose.EMPTY;
        ModelBiped.ArmPose left = ModelBiped.ArmPose.EMPTY;
        ModelCustom model = (ModelCustom)this.field_77045_g;
        if (rightItem != null) {
            right = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0) {
                EnumAction enumaction = rightItem.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    right = ModelBiped.ArmPose.BLOCK;
                } else if (enumaction == EnumAction.BOW) {
                    right = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        if (leftItem != null) {
            EnumAction enumaction1;
            left = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0 && (enumaction1 = leftItem.func_77975_n()) == EnumAction.BLOCK) {
                left = ModelBiped.ArmPose.BLOCK;
            }
        }
        model.field_187076_m = right;
        model.field_187075_l = left;
    }

    public void setupModel(EntityLivingBase entity) {
        Map<String, ModelCustom> models = ModelCustom.MODELS;
        ModelCustom model = null;
        Model.Pose pose = null;
        if (entity instanceof IMorphProvider) {
            CustomMorph morph = (CustomMorph)((IMorphProvider)entity).getMorph();
            model = models.get(morph.name);
            pose = morph.pose;
        } else {
            IMorphing cap = (IMorphing)entity.getCapability(MorphingProvider.MORPHING_CAP, null);
            if (cap != null && cap.isMorphed()) {
                CustomMorph morph = (CustomMorph)cap.getCurrentMorph();
                model = models.get(morph.name);
                pose = morph.pose;
            }
        }
        if (model != null) {
            if (pose == null) {
                pose = model.model.getPose("standing");
            }
            model.pose = pose;
            this.field_77045_g = model;
        }
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTickTime) {
        Model model = ((ModelCustom)this.field_77045_g).model;
        GlStateManager.func_179152_a((float)model.scale[0], (float)model.scale[1], (float)model.scale[2]);
    }

    protected void func_77043_a(EntityLivingBase entity, float pitch, float yaw, float partialTicks) {
        if (entity.func_70089_S() && entity.func_70608_bn()) {
            GlStateManager.func_179114_b((float)((EntityPlayer)entity).func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a(entity), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (entity.func_184613_cA()) {
            super.func_77043_a(entity, pitch, yaw, partialTicks);
            float f = (float)entity.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            Vec3d vec3d = entity.func_70676_i(partialTicks);
            double d0 = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entity.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entity.field_70159_w * vec3d.field_72450_a + entity.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entity.field_70159_w * vec3d.field_72449_c - entity.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            super.func_77043_a(entity, pitch, yaw, partialTicks);
        }
    }

    public void renderRightArm(EntityPlayer player) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getEntityTexture((EntityLivingBase)player));
        this.field_77045_g.field_78095_p = 0.0f;
        this.field_77045_g.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (ModelCustomRenderer arm : ((ModelCustom)this.field_77045_g).right) {
            arm.field_78795_f = 0.0f;
            arm.field_78800_c = -6.0f;
            arm.field_78797_d = 13.8f - (float)(arm.limb.size[1] > 8 ? arm.limb.size[1] : arm.limb.size[1] + 2);
            arm.field_78798_e = 0.0f;
            arm.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }

    public void renderLeftArm(EntityPlayer player) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getEntityTexture((EntityLivingBase)player));
        this.field_77045_g.field_78095_p = 0.0f;
        this.field_77045_g.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (ModelCustomRenderer arm : ((ModelCustom)this.field_77045_g).left) {
            arm.field_78795_f = 0.0f;
            arm.field_78800_c = 6.0f;
            arm.field_78797_d = 13.8f - (arm.limb.size[1] > 8 ? (float)arm.limb.size[1] : (float)arm.limb.size[1] + 2.0f);
            arm.field_78798_e = 0.0f;
            arm.func_78785_a(0.0625f);
        }
        GlStateManager.func_179084_k();
    }
}

