/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityMorph
extends EntityLiving
implements IEntityAdditionalSpawnData,
IMorphProvider {
    private UUID owner;
    private EntityPlayer player;
    public int timer = 30;
    public AbstractMorph morph;

    public EntityMorph(World worldIn) {
        super(worldIn);
        this.func_184224_h(true);
        this.func_96094_a("Morph");
    }

    public EntityMorph(World worldIn, UUID owner, AbstractMorph morph) {
        this(worldIn);
        this.owner = owner;
        this.morph = morph;
        this.setSize(morph);
    }

    @Override
    public AbstractMorph getMorph() {
        return this.morph;
    }

    public ITextComponent func_145748_c_() {
        if (this.morph != null) {
            return new TextComponentTranslation("entity." + this.morph.name + ".name", new Object[0]);
        }
        return super.func_145748_c_();
    }

    private void setSize(AbstractMorph morph) {
        if (morph != null) {
            this.func_70105_a(MathHelper.func_76131_a((float)morph.getWidth((EntityLivingBase)this), (float)0.0f, (float)1.5f), MathHelper.func_76131_a((float)morph.getHeight((EntityLivingBase)this), (float)0.0f, (float)2.0f));
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        if ((this.player == null || this.player.field_70128_L) && !this.field_70170_p.field_72995_K && this.owner != null) {
            this.player = this.field_70170_p.func_152378_a(this.owner);
        }
        if (this.player != null && !this.player.field_70128_L && this.func_174813_aQ().func_72326_a(this.player.func_174813_aQ())) {
            this.func_70106_y();
            this.grantMorph();
        }
    }

    private void grantMorph() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (MorphAPI.acquire(this.player, this.morph)) {
            this.field_70170_p.func_184148_a(this.player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.owner != null) {
            compound.func_74778_a("Owner", this.owner.toString());
        }
        if (this.morph != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.morph.toNBT(tag);
            compound.func_74782_a("Morph", (NBTBase)tag);
        }
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        String owner = compound.func_74779_i("Owner");
        UUID uUID = this.owner = owner.isEmpty() ? null : UUID.fromString(owner);
        if (compound.func_150297_b("Morph", 10)) {
            this.morph = MorphManager.INSTANCE.morphFromNBT(compound.func_74775_l("Morph"));
        }
        this.setSize(this.morph);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.owner != null ? this.owner.toString() : ""));
        if (this.morph != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.morph.toNBT(tag);
            boolean hasData = tag != null && !tag.func_82582_d();
            buffer.writeBoolean(hasData);
            if (hasData) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
            }
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        String owner = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        UUID uUID = this.owner = owner.isEmpty() ? null : UUID.fromString(owner);
        if (buffer.readBoolean()) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buffer);
            this.morph = MorphManager.INSTANCE.morphFromNBT(tag);
        }
        this.setSize(this.morph);
    }
}

