/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.network;

import mchorse.metamorph.network.client.ClientHandlerAcquireMorph;
import mchorse.metamorph.network.client.ClientHandlerAcquiredMorphs;
import mchorse.metamorph.network.client.ClientHandlerBlacklist;
import mchorse.metamorph.network.client.ClientHandlerFavoriteMorph;
import mchorse.metamorph.network.client.ClientHandlerMorph;
import mchorse.metamorph.network.client.ClientHandlerMorphPlayer;
import mchorse.metamorph.network.client.ClientHandlerRemoveMorph;
import mchorse.metamorph.network.client.ClientHandlerSettings;
import mchorse.metamorph.network.common.PacketAcquireMorph;
import mchorse.metamorph.network.common.PacketAcquiredMorphs;
import mchorse.metamorph.network.common.PacketAction;
import mchorse.metamorph.network.common.PacketBlacklist;
import mchorse.metamorph.network.common.PacketFavoriteMorph;
import mchorse.metamorph.network.common.PacketMorph;
import mchorse.metamorph.network.common.PacketMorphPlayer;
import mchorse.metamorph.network.common.PacketRemoveMorph;
import mchorse.metamorph.network.common.PacketSelectMorph;
import mchorse.metamorph.network.common.PacketSettings;
import mchorse.metamorph.network.server.ServerHandlerAcquireMorph;
import mchorse.metamorph.network.server.ServerHandlerAction;
import mchorse.metamorph.network.server.ServerHandlerFavoriteMorph;
import mchorse.metamorph.network.server.ServerHandlerMorph;
import mchorse.metamorph.network.server.ServerHandlerRemoveMorph;
import mchorse.metamorph.network.server.ServerHandlerSelectMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Dispatcher {
    private static final SimpleNetworkWrapper DISPATCHER = NetworkRegistry.INSTANCE.newSimpleChannel("metamorph");
    private static byte PACKET_ID;

    public static SimpleNetworkWrapper get() {
        return DISPATCHER;
    }

    public static void updateTrackers(Entity entity, IMessage message) {
        EntityTracker et = ((WorldServer)entity.field_70170_p).func_73039_n();
        for (EntityPlayer player : et.getTrackingPlayers(entity)) {
            DISPATCHER.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        DISPATCHER.sendTo(message, player);
    }

    public static void sendToServer(IMessage message) {
        DISPATCHER.sendToServer(message);
    }

    public static void register() {
        Dispatcher.register(PacketAction.class, ServerHandlerAction.class, Side.SERVER);
        Dispatcher.register(PacketMorph.class, ClientHandlerMorph.class, Side.CLIENT);
        Dispatcher.register(PacketMorph.class, ServerHandlerMorph.class, Side.SERVER);
        Dispatcher.register(PacketMorphPlayer.class, ClientHandlerMorphPlayer.class, Side.CLIENT);
        Dispatcher.register(PacketAcquireMorph.class, ClientHandlerAcquireMorph.class, Side.CLIENT);
        Dispatcher.register(PacketAcquireMorph.class, ServerHandlerAcquireMorph.class, Side.SERVER);
        Dispatcher.register(PacketAcquiredMorphs.class, ClientHandlerAcquiredMorphs.class, Side.CLIENT);
        Dispatcher.register(PacketSelectMorph.class, ServerHandlerSelectMorph.class, Side.SERVER);
        Dispatcher.register(PacketFavoriteMorph.class, ClientHandlerFavoriteMorph.class, Side.CLIENT);
        Dispatcher.register(PacketFavoriteMorph.class, ServerHandlerFavoriteMorph.class, Side.SERVER);
        Dispatcher.register(PacketRemoveMorph.class, ClientHandlerRemoveMorph.class, Side.CLIENT);
        Dispatcher.register(PacketRemoveMorph.class, ServerHandlerRemoveMorph.class, Side.SERVER);
        Dispatcher.register(PacketBlacklist.class, ClientHandlerBlacklist.class, Side.CLIENT);
        Dispatcher.register(PacketSettings.class, ClientHandlerSettings.class, Side.CLIENT);
    }

    private static <REQ extends IMessage, REPLY extends IMessage> void register(Class<REQ> message, Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side) {
        byte by = PACKET_ID;
        PACKET_ID = (byte)(by + 1);
        DISPATCHER.registerMessage(handler, message, (int)by, side);
    }
}

