/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack;

import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.IMorphFactory;
import mchorse.metamorph.api.MorphList;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.vanilla_pack.morphs.IronGolemMorph;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MobMorphFactory
implements IMorphFactory {
    @Override
    public void register(MorphManager manager) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient(MorphManager manager) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String displayNameForMorph(AbstractMorph morphName) {
        return null;
    }

    @Override
    public void getMorphs(MorphList morphs, World world) {
        int i;
        for (String name : EntityList.func_180124_b()) {
            if (!this.hasMorph(name) || morphs.hasMorph(name)) continue;
            this.addMorph(morphs, world, name, null);
        }
        this.addMorph(morphs, world, "Pig", "{Age:-1}");
        this.addMorph(morphs, world, "Chicken", "{Age:-1}");
        this.addMorph(morphs, world, "Cow", "{Age:-1}");
        this.addMorph(morphs, world, "MushroomCow", "{Age:-1}");
        this.addMorph(morphs, world, "Sheep", "{Sheared:1b}");
        this.addMorph(morphs, world, "Sheep", "{Age:-1}");
        this.addMorph(morphs, world, "Sheep", "{Age:-1,Sheared:1b}");
        for (i = 1; i < 16; ++i) {
            this.addMorph(morphs, world, "Sheep", "{Color:" + i + "}");
        }
        this.addMorph(morphs, world, "Sheep", "Jeb", "{CustomName:\"jeb_\"}");
        this.addMorph(morphs, world, "Sheep", "Baby Jeb", "{Age:-1,CustomName:\"jeb_\"}");
        this.addMorph(morphs, world, "Slime", "{Size:1}");
        this.addMorph(morphs, world, "Slime", "{Size:2}");
        this.addMorph(morphs, world, "LavaSlime", "{Size:1}");
        this.addMorph(morphs, world, "LavaSlime", "{Size:2}");
        this.addMorph(morphs, world, "Ozelot", "{Age:-1}");
        for (i = 1; i < 4; ++i) {
            this.addMorph(morphs, world, "Ozelot", "{CatType:" + i + "}");
            this.addMorph(morphs, world, "Ozelot", "{CatType:" + i + ",Age:-1}");
        }
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:1}");
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:2}");
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:3}");
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:4}");
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:5}");
        this.addMorph(morphs, world, "EntityHorse", "{Type:0,Variant:6}");
        this.addMorph(morphs, world, "EntityHorse", "Donkey", "{Type:1,Variant:0}");
        this.addMorph(morphs, world, "EntityHorse", "Mule", "{Type:2,Variant:0}");
        this.addMorph(morphs, world, "EntityHorse", "Zombie", "{Type:3,Variant:0}");
        this.addMorph(morphs, world, "EntityHorse", "Skeleton", "{Type:4,Variant:0}");
        this.addMorph(morphs, world, "Villager", "{ProfessionName:\"minecraft:librarian\"}");
        this.addMorph(morphs, world, "Villager", "{ProfessionName:\"minecraft:priest\"}");
        this.addMorph(morphs, world, "Villager", "{ProfessionName:\"minecraft:smith\"}");
        this.addMorph(morphs, world, "Villager", "{ProfessionName:\"minecraft:butcher\"}");
        this.addMorph(morphs, world, "Bat", "{BatFlags:2}");
        this.addMorph(morphs, world, "Skeleton", "Wither", "{SkeletonType:1}");
        this.addMorph(morphs, world, "Skeleton", "Stray", "{SkeletonType:2}");
        this.addMorph(morphs, world, "Zombie", "Baby", "{IsBaby:1b}");
        for (i = 1; i < 7; ++i) {
            this.addMorph(morphs, world, "Zombie", "{ZombieType:" + i + "}");
        }
        this.addMorph(morphs, world, "Guardian", "Elder", "{Elder:1b}");
        for (i = 1; i < 6; ++i) {
            this.addMorph(morphs, world, "Rabbit", "{RabbitType:" + i + "}");
        }
        this.addMorph(morphs, world, "Rabbit", "Toast", "{CustomName:\"Toast\"}");
    }

    private void addMorph(MorphList morphs, World world, String name, String json) {
        this.addMorph(morphs, world, name, "", json);
    }

    private void addMorph(MorphList morphs, World world, String name, String variant, String json) {
        try {
            EntityMorph morph = name.equals("VillagerGolem") ? new IronGolemMorph() : new EntityMorph();
            EntityLivingBase entity = (EntityLivingBase)EntityList.func_75620_a((String)name, (World)world);
            if (entity == null) {
                System.out.println("Couldn't add morph " + name + ", because it's null!");
                return;
            }
            NBTTagCompound data = entity.serializeNBT();
            morph.name = name;
            if (json != null) {
                try {
                    data.func_179237_a(JsonToNBT.func_180713_a((String)json));
                }
                catch (NBTException e) {
                    System.out.println("Failed to merge provided JSON data for '" + name + "' morph!");
                    e.printStackTrace();
                }
            }
            int index = name.indexOf(".");
            String category = "";
            if (index >= 0) {
                category = name.substring(0, index);
            } else if (entity instanceof EntityAnimal) {
                category = "animal";
            } else if (entity instanceof EntityMob) {
                category = "hostile";
            }
            EntityUtils.stripEntityNBT(data);
            morph.setEntityData(data);
            morphs.addMorphVariant(name, category, variant, morph);
        }
        catch (Exception e) {
            System.out.println("An error occured during insertion of " + name + " morph!");
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasMorph(String name) {
        Class clazz = (Class)EntityList.field_75625_b.get(name);
        if (clazz != null) {
            return EntityLivingBase.class.isAssignableFrom(clazz);
        }
        return false;
    }

    @Override
    public AbstractMorph getMorphFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        if (this.hasMorph(name)) {
            EntityMorph morph = name.equals("VillagerGolem") ? new IronGolemMorph() : new EntityMorph();
            morph.fromNBT(tag);
            return morph;
        }
        return null;
    }
}

