/*
 * Decompiled with CFR 0.152.
 */
package moveplus.forge;

import CoroUtil.forge.CULog;
import java.util.HashMap;
import java.util.Map;
import moveplus.config.MovePlusCfg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.input.Keyboard;

public class ClientTicker {
    public static boolean needsInit = true;
    public static double prevMotionX;
    public static double prevMotionY;
    public static double prevMotionZ;
    public static HashMap<KeyBinding, Long> keyTimesLastPressed;
    public static HashMap<KeyBinding, Boolean> keyLastState;
    public static HashMap<KeyBinding, Vec2f> lookupKeyToDirection;

    public static void tickInit() {
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, new Vec2f(1.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, new Vec2f(-1.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, new Vec2f(0.0f, -1.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, new Vec2f(0.0f, 1.0f));
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, false);
    }

    public static void tickClientGame() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (player == null || camera == null) {
            return;
        }
        if (needsInit) {
            needsInit = false;
            ClientTicker.tickInit();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            if (MovePlusCfg.useLedgeClimb) {
                ClientTicker.tickLedgeClimb();
            }
            if (MovePlusCfg.knockbackResistAmount > 0.0) {
                ClientTicker.tickKnockbackResistence();
            }
            if (MovePlusCfg.useGroundDodge) {
                ClientTicker.tickDodging();
            }
        }
    }

    public static void tickDodging() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        lookupKeyToDirection.forEach((k, v) -> ClientTicker.processDodgeKey(k, v));
    }

    public static void processDodgeKey(KeyBinding key, Vec2f vec) {
        long curTime = System.currentTimeMillis();
        long lastTime = ClientTicker.getLastKeyTime(key);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (key.func_151463_i() > 0) {
            if (Keyboard.isKeyDown((int)key.func_151463_i()) && !keyLastState.get(key).booleanValue()) {
                if (lastTime == -1L) {
                    ClientTicker.setLastKeyTime(key, curTime);
                } else if (player.field_70122_E && lastTime + MovePlusCfg.dodgeDelay > curTime) {
                    CULog.dbg((String)("dodge! " + key.getDisplayName()));
                    ClientTicker.setRelVel((Entity)player, vec.field_189983_j, 0.4f, vec.field_189982_i, 1.0f);
                    ClientTicker.setLastKeyTime(key, -1L);
                } else {
                    ClientTicker.setLastKeyTime(key, curTime);
                }
            }
            if (Keyboard.isKeyDown((int)key.func_151463_i())) {
                for (Map.Entry<KeyBinding, Long> entry : keyTimesLastPressed.entrySet()) {
                    if (entry.getKey() == key) continue;
                    entry.setValue(-1L);
                }
            }
            keyLastState.put(key, Keyboard.isKeyDown((int)key.func_151463_i()));
        }
    }

    public static void tickLedgeClimb() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        boolean renderDebug = false;
        if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
            float climbSpeed;
            float grabDist = 0.75f;
            Vec3d lookVec = player.func_70040_Z().func_186678_a((double)grabDist);
            Vec3d lookVecBehind = player.func_70040_Z().func_186678_a(-0.25);
            double yScanRangeAir = (double)player.field_70131_O + 0.2;
            double yScanRangeSolid = 0.4;
            double yScanRes = 0.2;
            double yAirSize = 0.25;
            double xzSize = 0.3;
            double xzSizeBehind = 0.1;
            AxisAlignedBB playerAABB = player.func_174813_aQ();
            AxisAlignedBB spotForHandsAir = new AxisAlignedBB(player.field_70165_t + lookVec.field_72450_a, playerAABB.field_72338_b, player.field_70161_v + lookVec.field_72449_c, player.field_70165_t + lookVec.field_72450_a, playerAABB.field_72338_b, player.field_70161_v + lookVec.field_72449_c).func_72314_b(xzSize, yAirSize, xzSize);
            AxisAlignedBB behindUnderFeet = new AxisAlignedBB(player.field_70165_t + lookVecBehind.field_72450_a, playerAABB.field_72338_b, player.field_70161_v + lookVecBehind.field_72449_c, player.field_70165_t + lookVecBehind.field_72450_a, playerAABB.field_72338_b, player.field_70161_v + lookVecBehind.field_72449_c).func_72314_b(xzSizeBehind, xzSizeBehind, xzSizeBehind);
            if (renderDebug) {
                ClientTicker.renderOffsetAABB(behindUnderFeet.func_72317_d(-player.field_70165_t, -playerAABB.field_72338_b, -player.field_70161_v), 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f);
            }
            boolean foundGrabbableSpot = false;
            if (!player.field_70122_E && player.field_70170_p.func_184144_a((Entity)player, behindUnderFeet).size() == 0) {
                block0: for (double y = yScanRangeAir; y > 0.25 && !foundGrabbableSpot; y -= yScanRes) {
                    if (player.field_70170_p.func_184144_a((Entity)player, spotForHandsAir.func_72317_d(0.0, y, 0.0)).size() != 0) continue;
                    AxisAlignedBB aabbRenderAir = spotForHandsAir.func_72317_d(-player.field_70165_t, -playerAABB.field_72338_b + y, -player.field_70161_v);
                    if (renderDebug) {
                        ClientTicker.renderOffsetAABB(aabbRenderAir.func_72314_b(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f);
                    }
                    for (double y2 = 0.0; y2 < yScanRangeSolid; y2 += yScanRes) {
                        AxisAlignedBB aabbTry2 = spotForHandsAir.func_72317_d(0.0, y - yAirSize * 1.0 - y2, 0.0);
                        AxisAlignedBB aabbRenderSolid = aabbTry2.func_72317_d(-player.field_70165_t, -playerAABB.field_72338_b, -player.field_70161_v);
                        AxisAlignedBB aabb2 = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72314_b(1.0, 1.0, 1.0);
                        if (player.field_70170_p.func_184144_a((Entity)player, aabbTry2).size() <= 0 || !(aabbTry2.field_72338_b + 0.15 > playerAABB.field_72338_b)) continue;
                        foundGrabbableSpot = true;
                        if (!renderDebug) continue block0;
                        ClientTicker.renderOffsetAABB(aabbRenderSolid.func_72314_b(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f);
                        continue block0;
                    }
                }
            }
            if (foundGrabbableSpot && player.field_70181_x < (double)(climbSpeed = 0.08f)) {
                player.field_70181_x = climbSpeed;
            }
        }
    }

    public static void tickKnockbackResistence() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float speed = (float)Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y);
        if (player.field_70737_aN > 0) {
            player.field_70737_aN = 0;
            if (MovePlusCfg.knockbackResistAmount == 1.0) {
                player.field_70159_w = prevMotionX;
                player.field_70181_x = prevMotionY;
                player.field_70179_y = prevMotionZ;
            } else {
                player.field_70159_w = prevMotionX + player.field_70159_w * (1.0 - Math.min(MovePlusCfg.knockbackResistAmount, 1.0));
                player.field_70181_x = prevMotionY + (prevMotionY > 0.1 ? 0.0 : player.field_70181_x * (1.0 - Math.min(MovePlusCfg.knockbackResistAmount, 1.0)));
                player.field_70179_y = prevMotionZ + player.field_70179_y * (1.0 - Math.min(MovePlusCfg.knockbackResistAmount, 1.0));
            }
        } else {
            prevMotionX = player.field_70159_w;
            prevMotionY = player.field_70181_x;
            prevMotionZ = player.field_70179_y;
        }
    }

    public static long getLastKeyTime(KeyBinding keybind) {
        if (!keyTimesLastPressed.containsKey(keybind)) {
            keyTimesLastPressed.put(keybind, -1L);
        }
        return keyTimesLastPressed.get(keybind);
    }

    public static void setLastKeyTime(KeyBinding keybind, long time) {
        keyTimesLastPressed.put(keybind, time);
    }

    public static void setRelVel(Entity entity, float rightSpeed, float y, float forwardSpeed, float horizontalMultiplier) {
        float var5 = 10.0f;
        float var6 = 0.0f;
        float var7 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var5;
        int var8 = (int)Math.floor((double)(var7 / 360.0f) + 0.5);
        var7 = var7 - (float)var8 * 360.0f + 270.0f;
        if (forwardSpeed <= 0.0f && forwardSpeed < 0.0f) {
            var7 += 180.0f;
        }
        if (rightSpeed > 0.0f) {
            var7 += 90.0f - forwardSpeed * 10.0f;
        } else if (rightSpeed < 0.0f) {
            var7 += 270.0f + forwardSpeed * 10.0f;
        }
        float var9 = MathHelper.func_76134_b((float)(-var7 * 0.01745329f - 3.141593f));
        float var10 = MathHelper.func_76126_a((float)(-var7 * 0.01745329f - 3.141593f));
        float var11 = -MathHelper.func_76134_b((float)(-var6 * 0.01745329f - 0.7853982f));
        float var13 = var9 * var11;
        float var15 = var10 * var11;
        if (rightSpeed == 0.0f && forwardSpeed == 0.0f) {
            ClientTicker.setVel(entity, (float)entity.field_70159_w / 2.0f, y, (float)entity.field_70179_y / 2.0f);
        } else {
            ClientTicker.setVel(entity, var13 * horizontalMultiplier * -1.0f, y, var15 * horizontalMultiplier);
        }
    }

    public static void setVel(Entity entity, float x, float y, float z) {
        entity.field_70159_w += (double)x;
        entity.field_70181_x = y;
        entity.field_70179_y += (double)z;
    }

    public static void tickClientRenderScreen() {
    }

    public static void tickClientRenderWorldLast() {
    }

    public static boolean nearWall(EntityPlayer player) {
        return player.field_70170_p.func_184144_a((Entity)player, player.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2)).size() > 0;
    }

    public static void renderOffsetAABB(AxisAlignedBB boundingBox, double x, double y, double z, float r, float g, float b) {
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        bufferbuilder.func_178969_c(x, y, z);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181708_h);
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
    }

    static {
        keyTimesLastPressed = new HashMap();
        keyLastState = new HashMap();
        lookupKeyToDirection = new HashMap();
    }
}

