/*
 * Decompiled with CFR 0.152.
 */
package net.row.item;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.row.stock.core.RoWRollingStock;

public class ItemPrybar
extends Item {
    private boolean isCouplingInProcess;
    private boolean wasFirstCouplerFront;
    private RoWRollingStock firstCart;
    String chatMsg = "";

    public ItemPrybar() {
        this.field_77777_bU = 1;
        this.func_77655_b("row.prybar");
        this.func_77664_n();
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("row:prybar");
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.isCouplingInProcess = false;
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("Cleared", new Object[0]));
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        return par1ItemStack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        player.field_70170_p.func_72956_a((Entity)player, "random.break", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!player.field_70170_p.field_72995_K && entity instanceof RoWRollingStock) {
            if (!this.isCouplingInProcess) {
                float dist_rear;
                this.firstCart = (RoWRollingStock)entity;
                float dist_front = this.dist_p2l(this.firstCart.couplerFront.getX(), this.firstCart.couplerFront.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                this.wasFirstCouplerFront = dist_front < (dist_rear = this.dist_p2l(this.firstCart.couplerRear.getX(), this.firstCart.couplerRear.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f));
                this.isCouplingInProcess = true;
                if (this.firstCart.coupler == RoWRollingStock.CouplerType.NONE) {
                    this.isCouplingInProcess = false;
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("This cart has no couplers", new Object[0]));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("Started coupling, " + (this.wasFirstCouplerFront ? "front" : "rear") + " coupler selected", new Object[0]));
                }
            } else {
                this.isCouplingInProcess = false;
                RoWRollingStock cart = (RoWRollingStock)entity;
                if (cart.coupler != this.firstCart.coupler) {
                    this.chatMsg = "Could only couple same type of couplers";
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(this.chatMsg, new Object[0]));
                    return true;
                }
                if (cart == this.firstCart) {
                    this.chatMsg = "Releasing " + (this.wasFirstCouplerFront ? "front" : "rear") + " coupler";
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(this.chatMsg, new Object[0]));
                    if (this.wasFirstCouplerFront) {
                        cart.frontCoupledCart = new RoWRollingStock(null);
                        cart.frontCoupledCart = null;
                    } else {
                        cart.rearCoupledCart = new RoWRollingStock(null);
                        cart.rearCoupledCart = null;
                    }
                    return true;
                }
                float dist_front = this.dist_p2l(cart.couplerFront.getX(), cart.couplerFront.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                float dist_rear = this.dist_p2l(cart.couplerRear.getX(), cart.couplerRear.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                float dx = this.wasFirstCouplerFront ? this.firstCart.couplerFront.getX() : this.firstCart.couplerRear.getX();
                float dz = this.wasFirstCouplerFront ? this.firstCart.couplerFront.getZ() : this.firstCart.couplerRear.getZ();
                float d = (float)Math.hypot(dx -= dist_front < dist_rear ? cart.couplerFront.getX() : cart.couplerRear.getX(), dz -= dist_front < dist_rear ? cart.couplerFront.getZ() : cart.couplerRear.getZ());
                if (d > 2.0f) {
                    this.chatMsg = (dist_front < dist_rear ? "Front" : "Rear") + " coupler selected on second cart. The distance is too big, try again";
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(this.chatMsg, new Object[0]));
                } else {
                    boolean canCouple = true;
                    if (this.wasFirstCouplerFront) {
                        if (dist_front < dist_rear) {
                            if (this.firstCart.frontCoupledCart != null && cart.frontCoupledCart != null) {
                                canCouple = false;
                            }
                        } else if (this.firstCart.frontCoupledCart != null || cart.rearCoupledCart != null) {
                            canCouple = false;
                        }
                    } else if (dist_front < dist_rear) {
                        if (this.firstCart.rearCoupledCart != null || cart.frontCoupledCart != null) {
                            canCouple = false;
                        }
                    } else if (this.firstCart.rearCoupledCart != null || cart.rearCoupledCart != null) {
                        canCouple = false;
                    }
                    if (!canCouple) {
                        this.chatMsg = "One of the couplers already occupied";
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(this.chatMsg, new Object[0]));
                        return true;
                    }
                    if (this.wasFirstCouplerFront) {
                        this.firstCart.frontCoupledCart = cart;
                    } else {
                        this.firstCart.rearCoupledCart = cart;
                    }
                    if (dist_front < dist_rear) {
                        cart.frontCoupledCart = this.firstCart;
                    } else {
                        cart.rearCoupledCart = this.firstCart;
                    }
                    this.chatMsg = "Coupling, " + (dist_front < dist_rear ? "front" : "rear") + " coupler selected on second cart";
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(this.chatMsg, new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    public float dist_p2l(float mx, float mz, float qx, float qz, float angle) {
        float k = (float)Math.tan(Math.toRadians(angle));
        float k1 = (float)Math.tan(Math.toRadians(angle + 90.0f));
        float b = qz - k * qx;
        float b1 = mz - k1 * mx;
        float hx = (b - b1) / (k1 - k);
        float hz = k * hx + b;
        return (float)Math.sqrt((hx - mx) * (hx - mx) + (hz - mz) * (hz - mz));
    }
}

