/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.row.helpers.RotationHelper;
import net.row.models.block.pointer.PointerArrow;
import net.row.models.block.pointer.PointerFrame;
import net.row.models.block.pointer.PointerFrameInverted;
import net.row.models.block.pointer.PointerLeverA;
import net.row.models.block.pointer.PointerLeverB;
import net.row.models.block.pointer.PointerLightBox;
import net.row.registry.RoWBlocks;
import net.row.tileentity.TileEntityPointer;
import net.row.tileentity.TileEntityRailNormal;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererPointer
extends TileEntitySpecialRenderer {
    protected ModelBase frame = new PointerFrame();
    protected ModelBase frame_inv = new PointerFrameInverted();
    protected ModelBase levera = new PointerLeverA();
    protected ModelBase leverb = new PointerLeverB();
    protected ModelBase arrow = new PointerArrow();
    protected ModelBase light = new PointerLightBox();

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        TileEntityPointer tile = (TileEntityPointer)tileentity;
        this.renderBlock(tile, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, RoWBlocks.pointer);
        GL11.glPopMatrix();
    }

    public void renderBlock(TileEntityPointer tile, World world, int i, int j, int k, Block block) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = block.func_149677_c((IBlockAccess)world, i, j, k);
        int l = world.func_72802_i(i, j, k, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        tessellator.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        boolean flag = true;
        int dir = tile.dir;
        int mtd = world.func_72805_g(i, j, k);
        int[] s = RotationHelper.rotateXZByDir(tile.inverted ? 2 : -2, 0, dir);
        float[] sh = RotationHelper.rotateXZByDir(tile.inverted ? -0.25f : 0.25f, 0.0f, dir);
        float signAngle = 0.0f;
        if (world.func_147439_a(i + s[0], j, k + s[1]) == RoWBlocks.railNormal) {
            TileEntityRailNormal tiler = (TileEntityRailNormal)world.func_147438_o(i + s[0], j, k + s[1]);
            if (tiler != null) {
                boolean bl = flag = tiler.mId == 5 || tiler.mId == 9;
            }
            signAngle = tiler.mId == 11 ? -90.0f + 180.0f * ((float)tile.progress + 10.0f) / 20.0f : -90.0f * ((float)tile.progress + 10.0f) / 20.0f * (float)(flag ? -1 : 1);
        }
        if (tile != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glTranslatef((float)sh[0], (float)0.0f, (float)sh[1]);
            GL11.glRotatef((float)((float)dir * -90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.func_147499_a(new ResourceLocation("row:textures/blocks_maps/pointer_new.png"));
            if (tile.inverted) {
                this.frame.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.frame_inv.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-signAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (mtd == 0) {
                this.arrow.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.light.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.03125f);
            GL11.glRotatef((float)(22.0f * (float)tile.progress / 10.0f * (float)(flag ? 1 : -1)), (float)1.0f, (float)0.0f, (float)0.0f);
            this.levera.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glTranslatef((float)-0.03125f, (float)0.0f, (float)-0.03125f);
            GL11.glRotatef((float)(90.0f * (float)tile.progress / 10.0f * (float)(flag ? 1 : -1) - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.leverb.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }
}

