/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.row.helpers.LinkResolver;
import net.row.helpers.RotationHelper;
import net.row.helpers.RotativePoint;
import net.row.registry.RoWBlocks;
import net.row.stock.core.RoWBogie;
import net.row.tileentity.TileEntityGag;
import net.row.tileentity.TileEntityRailNormal;

public class RoWRollingStock
extends Entity {
    public boolean isOnRail;
    public boolean isOnSlope;
    public boolean wasLastSwitchActive;
    public boolean hasFrontCoupler;
    public boolean hasRearCoupler;
    public boolean needsCouplingsCheck;
    public boolean renderCouplingPositions;
    public boolean isStatic;
    public int railPosX;
    public int railPosY;
    public int railPosZ;
    public float[] tangent;
    public float mass;
    public float maxSpeed;
    public float projectedSpeed;
    public float rotationCos;
    public float rotationSin;
    public float walkableMinX;
    public float walkableMinZ;
    public float walkableMaxX;
    public float walkableMaxZ;
    public float bogieShift;
    public float bogieAngle;
    public RotativePoint riderPos;
    public RotativePoint couplerFront;
    public RotativePoint couplerRear;
    public float[] wheelRadius;
    public float[] wheelAngle;
    public RoWRollingStock frontCoupledCart;
    public RoWRollingStock rearCoupledCart;
    public RoWBogie bogie;
    public UUID frontCartUUID;
    public UUID rearCartUUID;
    public String label;
    public String placer;
    public CouplerType coupler;

    public RoWRollingStock(World par1World) {
        super(par1World);
        this.func_70105_a(4.0f, 1.0f);
        this.renderCouplingPositions = false;
        this.isStatic = false;
        this.needsCouplingsCheck = true;
        this.field_70129_M = -0.625f;
        this.field_70138_W = 0.25f;
        this.mass = 1.0f;
        this.field_70144_Y = 1.0f;
        this.maxSpeed = 0.5f;
        this.projectedSpeed = 0.0f;
        this.rotationCos = 1.0f;
        this.rotationSin = 0.0f;
        this.bogieShift = 12.0f;
        this.riderPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
        this.couplerFront = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
        this.couplerRear = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
        this.walkableMinX = 0.0f;
        this.walkableMinZ = 0.0f;
        this.walkableMaxX = 0.0f;
        this.walkableMaxZ = 0.0f;
        this.frontCoupledCart = null;
        this.rearCoupledCart = null;
        this.field_70153_n = null;
        this.tangent = new float[]{0.0f, 0.0f, 0.0f};
        this.wheelRadius = new float[0];
        this.wheelAngle = new float[0];
        this.field_70180_af.func_75682_a(3, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(4, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(5, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(6, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(7, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(8, (Object)new Float(0.0f));
        this.coupler = CouplerType.NONE;
        this.label = "";
        this.placer = "unknown";
        this.func_70088_a();
    }

    public void func_70088_a() {
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            EntityPlayer entityplayer = null;
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            }
            if (entityplayer != null && entityplayer.field_71075_bZ.field_75098_d && entityplayer.func_70093_af()) {
                this.func_70106_y();
                this.field_70170_p.func_72900_e((Entity)this);
                return true;
            }
        }
        return true;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        if (this.frontCoupledCart != null && this.frontCoupledCart.frontCoupledCart != this && this.frontCoupledCart.rearCoupledCart != this) {
            this.frontCoupledCart = new RoWRollingStock(null);
            this.frontCoupledCart = null;
        }
        if (this.rearCoupledCart != null && this.rearCoupledCart.frontCoupledCart != this && this.rearCoupledCart.rearCoupledCart != this) {
            this.rearCoupledCart = new RoWRollingStock(null);
            this.rearCoupledCart = null;
        }
        if (this.field_70154_o != null && this.field_70154_o.field_70128_L) {
            this.field_70154_o = null;
        }
        this.rotationCos = (float)(-Math.sin(Math.toRadians(this.field_70177_z)));
        this.rotationSin = (float)Math.cos(Math.toRadians(this.field_70177_z));
        if (this.needsCouplingsCheck) {
            float ex = 30.0f;
            List list = this.field_70170_p.func_72872_a(RoWRollingStock.class, this.field_70121_D.func_72314_b((double)ex, (double)ex, (double)ex));
            for (RoWRollingStock cart : list) {
                if (cart == null || !cart.getPersistentID().equals(this.frontCartUUID) || cart.field_70128_L) continue;
                this.frontCoupledCart = cart;
                break;
            }
            for (RoWRollingStock cart : list) {
                if (cart == null || !cart.getPersistentID().equals(this.rearCartUUID) || cart.field_70128_L) continue;
                this.rearCoupledCart = cart;
                break;
            }
            this.needsCouplingsCheck = false;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.renderCouplingPositions) {
                this.updateCouplingPos();
                this.field_70170_p.func_72869_a("smoke", (double)this.couplerFront.getX(), (double)this.couplerFront.getY(), (double)this.couplerFront.getZ(), 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", (double)this.couplerRear.getX(), (double)this.couplerRear.getY(), (double)this.couplerRear.getZ(), 0.0, 0.0, 0.0);
            }
            this.field_70177_z = this.field_70180_af.func_111145_d(3);
            this.field_70125_A = this.field_70180_af.func_111145_d(6);
            this.projectedSpeed = this.field_70180_af.func_111145_d(4);
            this.bogieAngle = this.field_70180_af.func_111145_d(5);
            this.field_70159_w = this.projectedSpeed * this.rotationCos;
            this.field_70179_y = this.projectedSpeed * this.rotationSin;
            for (int w = 0; w < this.wheelAngle.length; w = (int)((byte)(w + 1))) {
                this.wheelAngle[w] = (float)MathHelper.func_76138_g((double)((double)this.wheelAngle[w] - Math.toDegrees(this.projectedSpeed / this.wheelRadius[w])));
            }
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                float rmm = 0.13f;
                float riderMoveForward = ((EntityLivingBase)this.field_70153_n).field_70701_bs * rmm;
                float riderMoveStrafing = ((EntityLivingBase)this.field_70153_n).field_70702_br * rmm;
                float riderMoveCos = (float)Math.cos(Math.toRadians(this.field_70153_n.field_70177_z - this.field_70177_z));
                float riderMoveSin = (float)Math.sin(Math.toRadians(this.field_70153_n.field_70177_z - this.field_70177_z));
                this.riderPos.setRelX(this.riderPos.getRelX() + -riderMoveSin * riderMoveForward + riderMoveCos * riderMoveStrafing);
                this.riderPos.setRelZ(this.riderPos.getRelZ() + riderMoveCos * riderMoveForward + riderMoveSin * riderMoveStrafing);
            }
            if (this.riderPos.getRelX() < this.walkableMinX) {
                this.riderPos.setRelX(this.walkableMinX);
            }
            if (this.riderPos.getRelX() > this.walkableMaxX) {
                this.riderPos.setRelX(this.walkableMaxX);
            }
            if (this.riderPos.getRelZ() < this.walkableMinZ) {
                this.riderPos.setRelZ(this.walkableMinZ);
            }
            if (this.riderPos.getRelZ() > this.walkableMaxZ) {
                this.riderPos.setRelZ(this.walkableMaxZ);
            }
            this.field_70180_af.func_75692_b(7, (Object)Float.valueOf(this.riderPos.getRelX()));
            this.field_70180_af.func_75692_b(7, (Object)Float.valueOf(this.riderPos.getRelZ()));
        } else {
            if (this.field_70163_u < -64.0) {
                this.func_70076_C();
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.field_70159_w *= 0.95;
            this.field_70181_x *= 0.95;
            this.field_70179_y *= 0.95;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            this.func_70024_g(0.0, -0.04, 0.0);
            this.func_145775_I();
            List collidingEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
            if (collidingEntities != null && !collidingEntities.isEmpty()) {
                for (int p = 0; p < collidingEntities.size(); ++p) {
                    Entity entity = (Entity)collidingEntities.get(p);
                    if (entity == this.frontCoupledCart || entity == this.rearCoupledCart || entity == this.field_70153_n) continue;
                    this.func_70108_f(entity);
                }
            }
            this.updateCouplingPos();
            this.updateCouplings();
            this.updateOnRail();
            this.projectedSpeed = (float)(this.field_70159_w * (double)this.rotationCos + this.field_70179_y * (double)this.rotationSin + this.field_70181_x * (double)this.tangent[2]);
            for (int w = 0; w < this.wheelAngle.length; w = (int)((byte)(w + 1))) {
                this.wheelAngle[w] = (float)MathHelper.func_76138_g((double)((double)this.wheelAngle[w] - Math.toDegrees(this.projectedSpeed / this.wheelRadius[w])));
            }
            this.riderPos.setRelX(this.field_70180_af.func_111145_d(7));
            this.riderPos.setRelZ(this.field_70180_af.func_111145_d(8));
            this.field_70180_af.func_75692_b(3, (Object)Float.valueOf(this.field_70177_z));
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(this.field_70125_A));
            this.field_70180_af.func_75692_b(4, (Object)Float.valueOf(this.projectedSpeed));
        }
        if (this.isStatic) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void updateCouplings() {
        if (this.frontCoupledCart != null && !this.frontCoupledCart.field_70128_L) {
            this.frontCoupledCart.updateCouplingPos();
            if (this.frontCoupledCart.rearCoupledCart == this) {
                LinkResolver.solveLink(this, this.frontCoupledCart, this.couplerFront.getX(), (float)this.field_70163_u, this.couplerFront.getZ(), this.frontCoupledCart.couplerRear.getX(), (float)this.frontCoupledCart.field_70163_u, this.frontCoupledCart.couplerRear.getZ(), 0.0f);
            }
            if (this.frontCoupledCart.frontCoupledCart == this) {
                LinkResolver.solveLink(this, this.frontCoupledCart, this.couplerFront.getX(), (float)this.field_70163_u, this.couplerFront.getZ(), this.frontCoupledCart.couplerFront.getX(), (float)this.frontCoupledCart.field_70163_u, this.frontCoupledCart.couplerFront.getZ(), 0.0f);
            }
        }
        if (this.rearCoupledCart != null && !this.rearCoupledCart.field_70128_L) {
            this.rearCoupledCart.updateCouplingPos();
            if (this.rearCoupledCart.rearCoupledCart == this) {
                LinkResolver.solveLink(this, this.rearCoupledCart, this.couplerRear.getX(), (float)this.field_70163_u, this.couplerRear.getZ(), this.rearCoupledCart.couplerRear.getX(), (float)this.rearCoupledCart.field_70163_u, this.rearCoupledCart.couplerRear.getZ(), 0.0f);
            }
            if (this.rearCoupledCart.frontCoupledCart == this) {
                LinkResolver.solveLink(this, this.rearCoupledCart, this.couplerRear.getX(), (float)this.field_70163_u, this.couplerRear.getZ(), this.rearCoupledCart.couplerFront.getX(), (float)this.rearCoupledCart.field_70163_u, this.rearCoupledCart.couplerFront.getZ(), 0.0f);
            }
        }
    }

    private float limitForce(double force) {
        return (float)Math.copySign(Math.min(Math.abs(force), 3.0), force);
    }

    public void updateCouplingPos() {
        this.couplerFront.onUpdate();
        this.couplerRear.onUpdate();
    }

    public float[] getTangent() {
        TileEntityRailNormal railTile;
        if (this.field_70170_p.func_147439_a(this.railPosX, this.railPosY, this.railPosZ) == RoWBlocks.railNormal && (railTile = (TileEntityRailNormal)this.field_70170_p.func_147438_o(this.railPosX, this.railPosY, this.railPosZ)) != null) {
            if (railTile.mId == 0 || (railTile.mId == 5 || railTile.mId == 6) && !this.wasLastSwitchActive || (railTile.mId == 9 || railTile.mId == 10) && !this.wasLastSwitchActive) {
                byte dir = (byte)this.field_70170_p.func_72805_g(this.railPosX, this.railPosY, this.railPosZ);
                int[] tg = RotationHelper.rotateXZByDir(0, 1, (int)dir);
                return new float[]{tg[0], tg[1], 0.0f};
            }
            if (railTile.mId == 3 || railTile.mId == 4 || (railTile.mId == 5 || railTile.mId == 6) && this.wasLastSwitchActive) {
                int dir = this.field_70170_p.func_72805_g(this.railPosX, this.railPosY, this.railPosZ) & 3;
                float xs = railTile.mId == 3 || railTile.mId == 5 ? -1.0f : 1.0f;
                float[] c = RotationHelper.rotateXZByDir(xs * 15.5f, -0.5f, dir);
                c[0] = c[0] + ((float)this.railPosX + 0.5f);
                c[1] = c[1] + ((float)this.railPosZ + 0.5f);
                float radX = (float)((double)c[0] - this.field_70165_t);
                float radZ = (float)((double)c[1] - this.field_70161_v);
                float radA = (float)Math.atan2(radZ, radX);
                float perA = (float)((double)radA + 1.5707963267948966);
                float perX = (float)Math.cos(perA);
                float perZ = (float)Math.sin(perA);
                float radG = (float)Math.sqrt(radX * radX + radZ * radZ);
                this.func_70107_b((double)c[0] + (double)(radX /= radG) * -15.5, (float)this.railPosY + 0.375f, (double)c[1] + (double)(radZ /= radG) * -15.5);
                return new float[]{perX, perZ, 0.0f};
            }
            if (railTile.mId == 7 || railTile.mId == 8 || (railTile.mId == 9 || railTile.mId == 10) && this.wasLastSwitchActive || railTile.mId == 11) {
                float dist = (float)(Math.pow(this.field_70165_t - (double)this.railPosX, 2.0) + Math.pow(this.field_70161_v - (double)this.railPosZ, 2.0));
                int b0 = dist < 62.0f ? 0 : 1;
                int dir = this.field_70170_p.func_72805_g(this.railPosX, this.railPosY, this.railPosZ) + b0 * 2 & 3;
                int dir1 = this.field_70170_p.func_72805_g(this.railPosX, this.railPosY, this.railPosZ) & 3;
                float xs = railTile.mId == 7 || railTile.mId == 9 || railTile.mId == 11 && this.wasLastSwitchActive ? -1.0f : 1.0f;
                float[] c = RotationHelper.rotateXZByDir(xs * 12.95f, -0.15f, dir);
                float[] c2 = RotationHelper.rotateXZByDir(xs * 5.0f * (float)b0, 15.0f * (float)b0, dir1);
                c[0] = c[0] + (c2[0] + (float)this.railPosX + 0.5f);
                c[1] = c[1] + (c2[1] + (float)this.railPosZ + 0.5f);
                float radX = (float)((double)c[0] - this.field_70165_t);
                float radZ = (float)((double)c[1] - this.field_70161_v);
                float radA = (float)Math.atan2(radZ, radX);
                float perA = (float)((double)radA + 1.5707963267948966);
                float perX = (float)Math.cos(perA);
                float perZ = (float)Math.sin(perA);
                float radG = (float)Math.sqrt(radX * radX + radZ * radZ);
                this.func_70107_b(c[0] + (radX /= radG) * -12.9f, (float)this.railPosY + 0.375f, c[1] + (radZ /= radG) * -12.9f);
                return new float[]{perX, perZ, 0.0f};
            }
            if (railTile.mId == 12 || railTile.mId == 13 || railTile.mId == 14) {
                byte dir = (byte)this.field_70170_p.func_72805_g(this.railPosX, this.railPosY, this.railPosZ);
                int[] tg = RotationHelper.rotateXZByDir(0, 1, (int)dir);
                float tg3 = 1.0f / (railTile.mId == 14 ? 12.0f : 25.0f * (float)(railTile.mId - 11));
                return new float[]{tg[0], tg[1], tg3};
            }
        }
        return new float[]{this.rotationCos, this.rotationSin, this.tangent[2]};
    }

    public void updateOnRail() {
        float s;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        this.isOnRail = true;
        this.isOnSlope = true;
        Block id = this.field_70170_p.func_147439_a(i, j, k);
        int metaData = 0;
        int mId = 0;
        if (id == RoWBlocks.railNormal) {
            this.railPosX = i;
            this.railPosY = j;
            this.railPosZ = k;
            TileEntityRailNormal railTile = (TileEntityRailNormal)this.field_70170_p.func_147438_o(i, j, k);
            metaData = this.field_70170_p.func_72805_g(i, j, k);
            if (railTile != null && railTile.mId == 0) {
                mId = railTile.mId;
                if (metaData == 0 || metaData == 2) {
                    this.func_70107_b((float)this.railPosX + 0.5f, (float)this.railPosY + 0.375f, this.field_70161_v);
                } else {
                    this.func_70107_b(this.field_70165_t, (float)this.railPosY + 0.375f, (float)this.railPosZ + 0.5f);
                }
            } else if (railTile != null && railTile.mId != 12 && railTile.mId != 13 && railTile.mId != 14) {
                this.func_70107_b(this.field_70165_t, (float)this.railPosY + 0.375f, this.field_70161_v);
            }
            this.wasLastSwitchActive = railTile.activated;
        } else if (id == RoWBlocks.railGag) {
            TileEntityGag gagTile = (TileEntityGag)this.field_70170_p.func_147438_o(i, j, k);
            if (gagTile != null && (gagTile.primary_x != 0 || gagTile.primary_y != 0 || gagTile.primary_z != 0) && this.field_70170_p.func_147439_a(gagTile.primary_x, gagTile.primary_y, gagTile.primary_z) == RoWBlocks.railNormal) {
                this.railPosX = gagTile.primary_x;
                this.railPosY = gagTile.primary_y;
                this.railPosZ = gagTile.primary_z;
                TileEntityRailNormal railTile = (TileEntityRailNormal)this.field_70170_p.func_147438_o(gagTile.primary_x, gagTile.primary_y, gagTile.primary_z);
                if (railTile != null) {
                    metaData = this.field_70170_p.func_72805_g(i, j, k);
                    mId = railTile.mId;
                    if (railTile != null && mId == 0) {
                        if (metaData == 0 || metaData == 2) {
                            this.func_70107_b((float)this.railPosX + 0.5f, (float)this.railPosY + 0.375f, this.field_70161_v);
                        } else {
                            this.func_70107_b(this.field_70165_t, (float)this.railPosY + 0.375f, (float)this.railPosZ + 0.5f);
                        }
                    } else if (railTile != null && railTile.mId != 12 && railTile.mId != 13 && railTile.mId != 14) {
                        this.func_70107_b(this.field_70165_t, (float)this.railPosY + 0.375f, this.field_70161_v);
                    }
                    float ds = (float)Math.sqrt(Math.pow(gagTile.primary_x - i, 2.0) + Math.pow(gagTile.primary_z - k, 2.0));
                    if ((railTile.mId == 5 || railTile.mId == 6 || railTile.mId == 9 || railTile.mId == 10) && ds > 7.0f) {
                        this.wasLastSwitchActive = gagTile.primary_x != i && gagTile.primary_z != k;
                    } else if (railTile.mId == 11 && ds > 5.0f) {
                        this.wasLastSwitchActive = metaData == 0 || metaData == 2 ? (metaData == 0 ? Math.signum(this.field_70165_t - (double)this.railPosX) < 0.0 : Math.signum(this.field_70165_t - (double)this.railPosX) > 0.0) : (metaData == 1 ? Math.signum(this.field_70161_v - (double)this.railPosZ) < 0.0 : Math.signum(this.field_70161_v - (double)this.railPosZ) > 0.0);
                    }
                }
            }
        } else {
            TileEntityGag gagTile;
            mId = 0;
            if ((id = this.field_70170_p.func_147439_a(i, --j, k)) == RoWBlocks.railNormal) {
                this.railPosX = i;
                this.railPosY = j;
                this.railPosZ = k;
                TileEntityRailNormal railTile = (TileEntityRailNormal)this.field_70170_p.func_147438_o(i, j, k);
                if (railTile != null) {
                    mId = railTile.mId;
                }
            } else if (id == RoWBlocks.railGag && (gagTile = (TileEntityGag)this.field_70170_p.func_147438_o(i, j, k)) != null && (gagTile.primary_x != 0 || gagTile.primary_y != 0 || gagTile.primary_z != 0)) {
                this.railPosX = gagTile.primary_x;
                this.railPosY = gagTile.primary_y;
                this.railPosZ = gagTile.primary_z;
                TileEntityRailNormal railTile = (TileEntityRailNormal)this.field_70170_p.func_147438_o(gagTile.primary_x, gagTile.primary_y, gagTile.primary_z);
                if (railTile != null) {
                    mId = railTile.mId;
                }
            }
            this.isOnRail = mId == 12 || mId == 13 || mId == 14;
        }
        this.isOnSlope = mId == 12 || mId == 13 || mId == 14;
        this.tangent = this.getTangent();
        if (this.isOnRail) {
            s = (float)(this.field_70159_w * (double)this.tangent[0] + this.field_70179_y * (double)this.tangent[1] + this.field_70181_x * (double)this.tangent[2]);
            s = Math.min(Math.abs(s), this.maxSpeed) * Math.signum(s);
            this.field_70159_w = this.tangent[0] * s;
            this.field_70179_y = this.tangent[1] * s;
            this.field_70181_x = this.tangent[2] * s;
        } else {
            s = (float)(this.field_70159_w * (double)this.tangent[0] + this.field_70179_y * (double)this.tangent[1]);
            if (s > this.maxSpeed) {
                s = this.maxSpeed;
            }
            if (s < -this.maxSpeed) {
                s = -this.maxSpeed;
            }
            this.field_70159_w = (double)(this.tangent[0] * s) * 0.85;
            this.field_70179_y = (double)(this.tangent[1] * s) * 0.85;
        }
        float trackAngle = (float)Math.toDegrees(-Math.atan2(this.tangent[0], this.tangent[1]));
        float y1 = (float)MathHelper.func_76138_g((double)(trackAngle - this.field_70177_z));
        float y2 = (float)Math.toDegrees(Math.atan(this.tangent[2]));
        if (y1 > 90.0f || y1 < -90.0f) {
            this.func_70101_b((float)MathHelper.func_76138_g((double)(180.0f + trackAngle)), -y2);
        } else {
            this.func_70101_b(trackAngle, y2);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void applyForwardMotion(float v) {
        this.func_70024_g(this.rotationCos * v, 0.0, this.rotationSin * v);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70100_b_(EntityPlayer player) {
        this.func_70108_f((Entity)player);
    }

    public void func_70108_f(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K) {
            double d1;
            double d0;
            double d2;
            RoWRollingStock cart;
            boolean flag = true;
            if (par1Entity instanceof RoWRollingStock && (this.frontCoupledCart == (cart = (RoWRollingStock)par1Entity) || this.rearCoupledCart == cart || cart.frontCoupledCart == this || cart.rearCoupledCart == this)) {
                flag = false;
            }
            if (flag && par1Entity.field_70153_n != this && par1Entity.field_70154_o != this && (d2 = MathHelper.func_76132_a((double)(d0 = par1Entity.field_70165_t - this.field_70165_t), (double)(d1 = par1Entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                par1Entity.func_70024_g(d0 *= 0.05, 0.0, d1 *= 0.05);
                this.func_70024_g(-(d0 *= (double)(1.0f - this.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - this.field_70144_Y)));
                float sqrtMotion = (float)Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70179_y, 2.0));
                if ((double)sqrtMotion > 0.05) {
                    par1Entity.func_70097_a(DamageSource.field_76377_j, sqrtMotion * 50.0f);
                }
            }
        }
    }

    protected boolean func_145771_j(double p_145771_1_, double p_145771_3_, double p_145771_5_) {
        int i = MathHelper.func_76128_c((double)p_145771_1_);
        int j = MathHelper.func_76128_c((double)p_145771_3_);
        int k = MathHelper.func_76128_c((double)p_145771_5_);
        double d3 = p_145771_1_ - (double)i;
        double d4 = p_145771_3_ - (double)j;
        double d5 = p_145771_5_ - (double)k;
        List list = this.field_70170_p.func_147461_a(this.field_70121_D);
        if (list.isEmpty() && !this.field_70170_p.func_147469_q(i, j, k)) {
            return false;
        }
        boolean flag = !this.field_70170_p.func_147469_q(i - 1, j, k);
        boolean flag1 = !this.field_70170_p.func_147469_q(i + 1, j, k);
        boolean flag2 = !this.field_70170_p.func_147469_q(i, j - 1, k);
        boolean flag3 = !this.field_70170_p.func_147469_q(i, j + 1, k);
        boolean flag4 = !this.field_70170_p.func_147469_q(i, j, k - 1);
        boolean flag5 = !this.field_70170_p.func_147469_q(i, j, k + 1);
        int b0 = 3;
        double d6 = 9999.0;
        if (flag && d3 < d6) {
            d6 = d3;
            b0 = 0;
        }
        if (flag1 && 1.0 - d3 < d6) {
            d6 = 1.0 - d3;
            b0 = 1;
        }
        if (flag3 && 1.0 - d4 < d6) {
            d6 = 1.0 - d4;
            b0 = 3;
        }
        if (flag4 && d5 < d6) {
            d6 = d5;
            b0 = 4;
        }
        if (flag5 && 1.0 - d5 < d6) {
            d6 = 1.0 - d5;
            b0 = 5;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        if (b0 == 0) {
            this.field_70159_w = -f;
        }
        if (b0 == 1) {
            this.field_70159_w = f;
        }
        if (b0 == 2) {
            this.field_70181_x = -f;
        }
        if (b0 == 3) {
            this.field_70181_x = f;
        }
        if (b0 == 4) {
            this.field_70179_y = -f;
        }
        if (b0 == 5) {
            this.field_70179_y = f;
        }
        return true;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.riderPos.onUpdate();
            this.field_70153_n.func_70107_b((double)this.riderPos.getX(), (double)this.riderPos.getY(), (double)this.riderPos.getZ());
        }
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    public AxisAlignedBB func_70114_g(Entity e1) {
        RoWRollingStock cart;
        if (e1 instanceof RoWRollingStock && (this.frontCoupledCart == (cart = (RoWRollingStock)e1) || this.rearCoupledCart == cart || cart.frontCoupledCart == this || cart.rearCoupledCart == this)) {
            return null;
        }
        if (e1.field_70154_o != this && e1.field_70153_n != this && this.field_70154_o != e1 && this.field_70153_n != e1) {
            return this.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public double func_70042_X() {
        return 1.0;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public Entity[] func_70021_al() {
        return null;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("frontCoupledUUIDMost") && nbttagcompound.func_74764_b("frontCoupledUUIDLeast")) {
            this.frontCartUUID = new UUID(nbttagcompound.func_74763_f("frontCoupledUUIDMost"), nbttagcompound.func_74763_f("frontCoupledUUIDLeast"));
        }
        if (nbttagcompound.func_74764_b("rearCoupledUUIDMost") && nbttagcompound.func_74764_b("rearCoupledUUIDLeast")) {
            this.rearCartUUID = new UUID(nbttagcompound.func_74763_f("rearCoupledUUIDMost"), nbttagcompound.func_74763_f("rearCoupledUUIDLeast"));
        }
        this.placer = nbttagcompound.func_74779_i("placer");
        this.label = nbttagcompound.func_74779_i("label");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        if (this.frontCoupledCart != null) {
            nbttagcompound.func_74772_a("frontCoupledUUIDMost", this.frontCoupledCart.getPersistentID().getMostSignificantBits());
            nbttagcompound.func_74772_a("frontCoupledUUIDLeast", this.frontCoupledCart.getPersistentID().getLeastSignificantBits());
        }
        if (this.rearCoupledCart != null) {
            nbttagcompound.func_74772_a("rearCoupledUUIDMost", this.rearCoupledCart.getPersistentID().getMostSignificantBits());
            nbttagcompound.func_74772_a("rearCoupledUUIDLeast", this.rearCoupledCart.getPersistentID().getLeastSignificantBits());
        }
        nbttagcompound.func_74778_a("placer", this.placer);
        nbttagcompound.func_74778_a("label", this.label);
    }

    public static enum CouplerType {
        NONE,
        CHER,
        RUSS_BnCH;

    }
}

