/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.railsofwar.row.ProxyServer;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.common.client.gui.TabRoWGeneral;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.command.CommandStockManager;
import net.railsofwar.row.stock.core.ChunkLoader;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.packets.PacketBrakeScrew;
import net.railsofwar.row.stock.packets.PacketDismount;
import net.railsofwar.row.stock.packets.PacketNBT;
import net.railsofwar.row.stock.packets.PacketPosition;
import net.railsofwar.row.stock.packets.PacketRegulator;
import net.railsofwar.row.stock.packets.PacketRequestServerNBTData;
import net.railsofwar.row.stock.packets.PacketReverse;
import net.railsofwar.row.stock.packets.PacketWarn;
import net.railsofwar.row.stock.packets.PacketWhistle;
import net.railsofwar.row.stock.packets.command.PacketCommandStockCount;
import net.railsofwar.row.stock.packets.command.PacketCommandStockReload;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.capability.CapabilityToolTrack;
import net.railsofwar.row.track.packets.PacketCapabilityTrackTool;
import net.railsofwar.row.track.packets.PacketRequestTrackData;
import net.railsofwar.row.track.packets.PacketSendTrackData;
import org.apache.logging.log4j.Logger;

@Mod(modid="row", name="Rails of War", version="1.12.2-2006-1o1", dependencies="required-after:forge@[14.23.5.2705,)", acceptedMinecraftVersions="[1.12.2]")
public class RoW {
    @Mod.Instance
    public static RoW instance;
    public static Logger logger;
    public static Configuration config;
    @SidedProxy(clientSide="net.railsofwar.row.ProxyClient", serverSide="net.railsofwar.row.ProxyServer")
    public static ProxyServer proxy;
    public static SimpleNetworkWrapper network;
    public static final ChunkLoader chunkLoader;
    public static final String modID = "row";
    public static final String name = "Rails of War";
    public static final String version = "1.12.2-2006-1o1";
    private int entityID = 0;
    public static final CreativeTabs TAB_ROW;
    private static Map<Integer, Map<Integer, RollingStock>> stockDimensionalMapServer;
    private static Map<Integer, Map<Integer, RollingStock>> stockDimensionalMapClient;

    @Mod.EventHandler
    public void on(FMLPreInitializationEvent e) {
        ModMetadata m = e.getModMetadata();
        m.autogenerated = false;
        m.description = "Big trains, steam locomotives and fun.";
        m.authorList.add("Naiten");
        logger = e.getModLog();
        proxy.preInit(e);
        config = new Configuration(new File(e.getModConfigurationDirectory(), "RailsOfWar.cfg"));
        Config.readConfig();
        CapabilityManager.INSTANCE.register(CapabilityToolTrack.IToolTrackCapability.class, (Capability.IStorage)new CapabilityToolTrack.Storage(), CapabilityToolTrack.DefaultToolTrack.class);
    }

    @Mod.EventHandler
    public void on(FMLInitializationEvent e) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(modID);
        MinecraftForge.EVENT_BUS.register((Object)chunkLoader);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)chunkLoader);
        proxy.init(e);
        RoWTracks.init();
        RoWStock.init();
        this.registerPackets();
        RoW.populateStockDimensionalMap(true);
        RoW.populateStockDimensionalMap(false);
    }

    @Mod.EventHandler
    public void on(FMLPostInitializationEvent on) {
        proxy.postInit(on);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandStockManager());
    }

    public static String getEntityName(Class<? extends Entity> entityClass) {
        return entityClass.getName().substring(entityClass.getName().lastIndexOf(46) + 1);
    }

    public void registerEntity(Class<? extends Entity> entityClass, int range, int frequency, boolean sendsVelocityUpdates) {
        String name = RoW.getEntityName(entityClass);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("row:" + name), entityClass, (String)name, (int)(++this.entityID), (Object)instance, (int)range, (int)frequency, (boolean)sendsVelocityUpdates);
    }

    private void registerPackets() {
        int packetId = 0;
        RoWStock.network.registerMessage(PacketDismount.Handler.class, PacketDismount.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketDismount.Handler.class, PacketDismount.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketReverse.Handler.class, PacketReverse.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketReverse.Handler.class, PacketReverse.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketRegulator.Handler.class, PacketRegulator.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketRegulator.Handler.class, PacketRegulator.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketBrakeScrew.Handler.class, PacketBrakeScrew.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketBrakeScrew.Handler.class, PacketBrakeScrew.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketWhistle.Handler.class, PacketWhistle.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketWhistle.Handler.class, PacketWhistle.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketPosition.Handler.class, PacketPosition.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketPosition.Handler.class, PacketPosition.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketNBT.Handler.class, PacketNBT.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketRequestServerNBTData.Handler.class, PacketRequestServerNBTData.class, ++packetId, Side.SERVER);
        RoWStock.network.registerMessage(PacketWarn.Handler.class, PacketWarn.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketCommandStockCount.Handler.class, PacketCommandStockCount.class, ++packetId, Side.CLIENT);
        RoWStock.network.registerMessage(PacketCommandStockReload.Handler.class, PacketCommandStockReload.class, ++packetId, Side.CLIENT);
        packetId = 0;
        RoWTracks.network.registerMessage(PacketSendTrackData.Handler.class, PacketSendTrackData.class, ++packetId, Side.CLIENT);
        RoWTracks.network.registerMessage(PacketRequestTrackData.Handler.class, PacketRequestTrackData.class, ++packetId, Side.SERVER);
        RoWTracks.network.registerMessage(PacketCapabilityTrackTool.Handler.class, PacketCapabilityTrackTool.class, ++packetId, Side.CLIENT);
        RoWTracks.network.registerMessage(PacketCapabilityTrackTool.Handler.class, PacketCapabilityTrackTool.class, ++packetId, Side.SERVER);
    }

    private static void populateStockDimensionalMap(boolean remote) {
        Map<Integer, Map<Integer, RollingStock>> map = RoW.getStockDimensionalMap(remote);
        map.put(-1, new HashMap());
        map.put(0, new HashMap());
        map.put(1, new HashMap());
    }

    public static Map<Integer, Map<Integer, RollingStock>> getStockDimensionalMap(boolean remote) {
        return remote ? stockDimensionalMapClient : stockDimensionalMapServer;
    }

    public static Map<Integer, RollingStock> getRespectiveStockMap(World world) {
        return RoW.getStockDimensionalMap(world.field_72995_K).computeIfAbsent(world.field_73011_w.getDimension(), k -> new HashMap());
    }

    public static void clearStockMap(World world) {
        RoW.getRespectiveStockMap(world).clear();
    }

    static {
        chunkLoader = new ChunkLoader();
        TAB_ROW = new TabRoWGeneral();
        stockDimensionalMapServer = new HashMap<Integer, Map<Integer, RollingStock>>();
        stockDimensionalMapClient = new HashMap<Integer, Map<Integer, RollingStock>>();
    }
}

