/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common;

import net.minecraftforge.common.config.Configuration;
import net.railsofwar.row.RoW;
import org.apache.logging.log4j.Level;

public class Config {
    private static final String CATEGORY_GENERAL = "general";
    public static boolean renderTrackBoxes = false;
    public static boolean generateSpikes = true;
    public static boolean skipWarningScreen = false;
    public static boolean spawnSmoke = true;
    public static boolean canPushStock = true;
    public static boolean skipStockUpdates = false;
    public static boolean allowCouplerOverstretch = false;
    private static int trackRemovalRange = 16;
    private static float gravityFactor = 0.1f;

    public static void readConfig() {
        Configuration cfg = RoW.config;
        try {
            cfg.load();
            Config.initGeneralConfig(cfg);
        }
        catch (Exception e) {
            RoW.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        trackRemovalRange = cfg.getInt("trackRemovalRange", CATEGORY_GENERAL, trackRemovalRange, 1, 256, "Track removal button action range");
        generateSpikes = cfg.getBoolean("generateSpikes", CATEGORY_GENERAL, generateSpikes, "Turn this off if your client lags when placing or updating tracks");
        skipWarningScreen = cfg.getBoolean("skipWarningScreen", CATEGORY_GENERAL, skipWarningScreen, "Set this to True to skip the warning screen when joining a world");
        spawnSmoke = cfg.getBoolean("spawnSmoke", CATEGORY_GENERAL, spawnSmoke, "Disable this if smoke causes too much lag");
        canPushStock = cfg.getBoolean("canPushStock", CATEGORY_GENERAL, canPushStock, "Set this to false if pushing trains is too arcade for you");
        skipStockUpdates = cfg.getBoolean("skipStockUpdates", CATEGORY_GENERAL, skipStockUpdates, "Enable this if you need to debug your world and updating stock crashes it");
        allowCouplerOverstretch = cfg.getBoolean("allowCouplerOverstretch", CATEGORY_GENERAL, allowCouplerOverstretch, "Allow couplers to stretch without breaking");
        gravityFactor = cfg.getFloat("gravityFactor", CATEGORY_GENERAL, gravityFactor, 0.0f, 10.0f, "For all ya Newtonian needs");
    }

    public static float getGravityFactor() {
        return gravityFactor;
    }

    public static int getTrackRemovalRange() {
        return trackRemovalRange;
    }
}

