/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common.client.util;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.roller.RollerAxle;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.track.client.util.UtilModelTRSR;
import org.lwjgl.opengl.GL11;

public class UtilModels {
    @Nullable
    public static IModel loadModel(String modelLocation, String textureLocation) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation)).process(ImmutableMap.of((Object)"flip-v", (Object)"true")).retexture(ImmutableMap.of((Object)"#None", (Object)textureLocation));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static IModel loadModel(ResourceLocation modelLocation, String textureLocation) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)modelLocation).process(ImmutableMap.of((Object)"flip-v", (Object)"true")).retexture(ImmutableMap.of((Object)"#None", (Object)textureLocation));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IModel textureModel(IModel model, String material, String textureLocation) {
        return model.retexture(ImmutableMap.of((Object)material, (Object)textureLocation));
    }

    public static IBakedModel bake(IModel model) {
        return model.bake(UtilModelTRSR.st(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
    }

    public static IBakedModel bakeModel(IModel model, IModelState state) {
        return model.bake(state, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
    }

    public static void renderModel(IBakedModel model) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)-1);
        }
        tessellator.func_78381_a();
    }

    public static void translateToRelIn(RotaVec p) {
        GL11.glTranslatef((float)p.getRelXIn(), (float)p.getRelYIn(), (float)p.getRelZIn());
    }

    public static void translateToRelIn(RotaVec p, float scale) {
        GL11.glTranslatef((float)(p.getRelXIn() * scale), (float)(p.getRelYIn() * scale), (float)(p.getRelZIn() * scale));
    }

    public static void translateToRelOut(RotaVec p) {
        GL11.glTranslatef((float)p.getRelXOut(), (float)p.getRelYOut(), (float)p.getRelZOut());
    }

    public static void translateToRelOut(RotaVec p, float scale) {
        GL11.glTranslatef((float)(p.getRelXOut() * scale), (float)(p.getRelYOut() * scale), (float)(p.getRelZOut() * scale));
    }

    public static void translateWOrig(float x, float y, float z, float ox, float oy, float oz) {
        GL11.glTranslatef((float)(x - ox), (float)(y - oy), (float)(z - oz));
    }

    public static void translateWOrig(float x, float y, float z, Entity orig) {
        GL11.glTranslatef((float)(x - (float)orig.field_70165_t), (float)(y - (float)orig.field_70163_u), (float)(z - (float)orig.field_70161_v));
    }

    public static void translateWOrig(RollerFrame f, Entity orig, float partial) {
        UtilModels.translateWOrig(UtilMath.inp(f.posX, f.posXPrev, partial), UtilMath.inp(f.posY, f.posYPrev, partial), UtilMath.inp(f.posZ, f.posZPrev, partial), orig);
    }

    public static void translateWOrig(RotaVec p, Entity orig, float partial) {
        UtilModels.translateWOrig(p.getXInp(partial), p.getYInp(partial), p.getZInp(partial), orig);
    }

    public static void translateWOrig(RotaVec p, Entity orig) {
        GL11.glTranslatef((float)(p.getX() - (float)orig.field_70165_t), (float)(p.getY() - (float)orig.field_70163_u), (float)(p.getZ() - (float)orig.field_70161_v));
    }

    public static void doAxes(RollerFrame f, Entity o, float k, int w) {
        UtilModels.doAxes(f.posX, f.posY, f.posZ, (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RollerFrame f, float partial, Entity o, float k, int w) {
        UtilModels.doAxes(f.getXInp(partial), f.getYInp(partial), f.getZInp(partial), (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RollerAxle a, Entity o, float k, int w) {
        UtilModels.doAxes(a.posX, a.posY, a.posZ, (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RollerAxle a, float partial, Entity o, float k, int w) {
        UtilModels.doAxes(a.getXInp(partial), a.getYInp(partial), a.getZInp(partial), (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RotaVec p, Entity o, float k, int w) {
        UtilModels.doAxes(p, (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RotaVec p, float partial, Entity o, float k, int w) {
        UtilModels.doAxes(p.getXInp(partial), p.getYInp(partial), p.getZInp(partial), o, k, w);
    }

    public static void doAxes(float x, float y, float z, Entity o, float k, int w) {
        UtilModels.doAxes(x, y, z, (float)o.field_70165_t, (float)o.field_70163_u, (float)o.field_70161_v, k, w);
    }

    public static void doAxes(RotaVec p, float ox, float oy, float oz, float k, int w) {
        UtilModels.doAxes(p.getX(), p.getY(), p.getZ(), ox, oy, oz, k, w);
    }

    public static void doAxes(RotaVec p, float partial, float ox, float oy, float oz, float k, int w) {
        UtilModels.doAxes(p.getXInp(partial), p.getYInp(partial), p.getZInp(partial), ox, oy, oz, k, w);
    }

    public static void doAxes(float x, float y, float z, float ox, float oy, float oz, float k, int w) {
        UtilModels.doVector(x - ox, y - oy, z - oz, 1.0f, 0.0f, 0.0f, k, 1.0f, 0.0f, 0.0f, w);
        UtilModels.doVector(x - ox, y - oy, z - oz, 0.0f, 1.0f, 0.0f, k, 0.0f, 1.0f, 0.0f, w);
        UtilModels.doVector(x - ox, y - oy, z - oz, 0.0f, 0.0f, 1.0f, k, 0.0f, 0.0f, 1.0f, w);
    }

    public static void doAxes(RotaVec p, float k, int w) {
        UtilModels.doVector(p, 1.0f, 0.0f, 0.0f, k, 1.0f, 0.0f, 0.0f, w);
        UtilModels.doVector(p, 0.0f, 1.0f, 0.0f, k, 0.0f, 1.0f, 0.0f, w);
        UtilModels.doVector(p, 0.0f, 0.0f, 1.0f, k, 0.0f, 0.0f, 1.0f, w);
    }

    public static void doAxes(Vector3f p, float k, int w) {
        UtilModels.doVector(p, 1.0f, 0.0f, 0.0f, k, 1.0f, 0.0f, 0.0f, w);
        UtilModels.doVector(p, 0.0f, 1.0f, 0.0f, k, 0.0f, 1.0f, 0.0f, w);
        UtilModels.doVector(p, 0.0f, 0.0f, 1.0f, k, 0.0f, 0.0f, 1.0f, w);
    }

    public static void doAxes(float px, float py, float pz, float k, int w) {
        UtilModels.doVector(px, py, pz, 1.0f, 0.0f, 0.0f, k, 1.0f, 0.0f, 0.0f, w);
        UtilModels.doVector(px, py, pz, 0.0f, 1.0f, 0.0f, k, 0.0f, 1.0f, 0.0f, w);
        UtilModels.doVector(px, py, pz, 0.0f, 0.0f, 1.0f, k, 0.0f, 0.0f, 1.0f, w);
    }

    public static void doVector(RotaVec p, Vector3f d, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX(), p.getY(), p.getZ(), d.getX(), d.getY(), d.getY(), k, r, g, b, w);
    }

    public static void doVector(RotaVec p, float ox, float oy, float oz, float x, float y, float z, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX() - ox, p.getY() - oy, p.getZ() - oz, x, y, z, k, r, g, b, w);
    }

    public static void doVector(RotaVec p, float x, float y, float z, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX(), p.getY(), p.getZ(), x, y, z, k, r, g, b, w);
    }

    public static void doVector(Entity o, Vector3f p, Vector3f d, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX() - (float)o.field_70165_t, p.getY() - (float)o.field_70163_u, p.getZ() - (float)o.field_70161_v, d.getX(), d.getY(), d.getZ(), k, r, g, b, w);
    }

    public static void doVector(Vector3f p, Vector3f d, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX(), p.getY(), p.getZ(), d.getX(), d.getY(), d.getZ(), k, r, g, b, w);
    }

    public static void doVector(Vector3f p, float x, float y, float z, float k, float r, float g, float b, int w) {
        UtilModels.doVector(p.getX(), p.getY(), p.getZ(), x, y, z, k, r, g, b, w);
    }

    public static void doVector(float px, float py, float pz, float x, float y, float z, float k, float r, float g, float b, int w) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GlStateManager.func_179118_c();
        GL11.glLineWidth((float)w);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)px, (double)py, (double)pz).func_181666_a(r, g, b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(px + k * x), (double)(py + k * y), (double)(pz + k * z)).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

