/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common.enumerate;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public enum EnumDirectionSWNE {
    SOUTH(0, 2, "south"),
    WEST(1, 3, "west"),
    NORTH(2, 0, "north"),
    EAST(3, 1, "east");

    private final int index;
    private final int opposite;
    private final String name;
    private static final EnumDirectionSWNE[] VALUES;
    private static final Map<String, EnumDirectionSWNE> NAME_LOOKUP;

    private EnumDirectionSWNE(int indexIn, int oppositeIn, String nameIn) {
        this.index = indexIn;
        this.opposite = oppositeIn;
        this.name = nameIn;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public float getAzimuth() {
        return (float)this.index * 90.0f;
    }

    public Vec3i ort(int l) {
        switch (this) {
            case WEST: {
                return new BlockPos(-l, 0, 0);
            }
            case NORTH: {
                return new BlockPos(0, 0, -l);
            }
            case EAST: {
                return new BlockPos(l, 0, 0);
            }
        }
        return new BlockPos(0, 0, l);
    }

    public Vector3f ort(float l) {
        switch (this) {
            case WEST: {
                return new Vector3f(-l, 0.0f, 0.0f);
            }
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, -l);
            }
            case EAST: {
                return new Vector3f(l, 0.0f, 0.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, l);
    }

    public static EnumDirectionSWNE getFront(int index) {
        int i = index % EnumDirectionSWNE.values().length;
        return VALUES[i < 0 ? i + EnumDirectionSWNE.values().length : i];
    }

    public EnumDirectionSWNE getCCW() {
        return EnumDirectionSWNE.getFront(this.index - 1);
    }

    public EnumDirectionSWNE getCW() {
        return EnumDirectionSWNE.getFront(this.index + 1);
    }

    public EnumDirectionSWNE getOpposite() {
        return EnumDirectionSWNE.getFront(this.opposite);
    }

    public static EnumDirectionSWNE fromAngle(double angle) {
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        return EnumDirectionSWNE.getFront(MathHelper.func_76128_c((double)(angle * 4.0 / 360.0 + 0.5)) & 3);
    }

    @Nullable
    public static EnumDirectionSWNE byName(@Nullable String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    public static EnumDirectionSWNE byNameSafely(@Nullable String name) {
        return name == null ? SOUTH : NAME_LOOKUP.get(name.toLowerCase());
    }

    static {
        VALUES = new EnumDirectionSWNE[4];
        NAME_LOOKUP = Maps.newHashMap();
        EnumDirectionSWNE[] enumDirectionSWNEArray = EnumDirectionSWNE.values();
        int n = enumDirectionSWNEArray.length;
        for (int i = 0; i < n; ++i) {
            EnumDirectionSWNE outlet;
            EnumDirectionSWNE.VALUES[outlet.index] = outlet = enumDirectionSWNEArray[i];
            NAME_LOOKUP.put(outlet.getName().toLowerCase(), outlet);
        }
    }
}

