/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common.math;

import javax.vecmath.Vector3f;
import net.minecraft.util.math.BlockPos;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;

public class RotationHelper {
    public static int[] rotateByDir(int x, int z, EnumDirectionSWNE dir) {
        switch (dir) {
            case SOUTH: {
                return new int[]{x, z};
            }
            case WEST: {
                return new int[]{-z, x};
            }
            case NORTH: {
                return new int[]{-x, -z};
            }
        }
        return new int[]{z, -x};
    }

    public static float[] rotateByDir(float x, float z, EnumDirectionSWNE dir) {
        switch (dir) {
            case SOUTH: {
                return new float[]{x, z};
            }
            case WEST: {
                return new float[]{-z, x};
            }
            case NORTH: {
                return new float[]{-x, -z};
            }
        }
        return new float[]{z, -x};
    }

    public static Vector3f rotateByDir(Vector3f vec, EnumDirectionSWNE dir) {
        switch (dir) {
            case SOUTH: {
                return vec;
            }
            case WEST: {
                return new Vector3f(-vec.z, vec.y, vec.x);
            }
            case NORTH: {
                return new Vector3f(-vec.x, vec.y, -vec.z);
            }
        }
        return new Vector3f(vec.z, vec.y, -vec.x);
    }

    public static BlockPos rotateByDir(BlockPos pos, BlockPos anchor, EnumDirectionSWNE dir) {
        return RotationHelper.rotateByDir(pos, dir).func_177982_a(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
    }

    public static BlockPos rotateByDir(BlockPos pos, EnumDirectionSWNE dir) {
        switch (dir) {
            case SOUTH: {
                return pos;
            }
            case WEST: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case NORTH: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
        }
        return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
    }
}

