/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common.math;

import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.railsofwar.row.common.math.rota.RotaVec;

public class UtilMath {
    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static <N extends Number> double hyp(N x, N y, N z) {
        return Math.sqrt(Math.pow(x.doubleValue(), 2.0) + Math.pow(y.doubleValue(), 2.0) + Math.pow(z.doubleValue(), 2.0));
    }

    public static <N extends Number> float sqrt(N subradical) {
        return (float)Math.sqrt(subradical.floatValue());
    }

    public static float sqr(float base) {
        return base * base;
    }

    public static float dist(Vector3f a, Vector3f b) {
        return UtilMath.sqrt(Float.valueOf(UtilMath.sqr(a.x - b.x) + UtilMath.sqr(a.y - b.y) + UtilMath.sqr(a.z - b.z)));
    }

    public static float dist(RotaVec a, RotaVec b) {
        return UtilMath.sqrt(Float.valueOf(UtilMath.sqr(a.getX() - b.getX()) + UtilMath.sqr(a.getY() - b.getY()) + UtilMath.sqr(a.getZ() - b.getZ())));
    }

    public static <N extends Number> float toRadians(N degree) {
        return degree.floatValue() * (float)Math.PI / 180.0f;
    }

    public static <N extends Number> float toDegrees(N radian) {
        return radian.floatValue() * 180.0f / (float)Math.PI;
    }

    public static <N extends Number> float toRevolutions(N radian) {
        return 0.5f * radian.floatValue() / (float)Math.PI;
    }

    public static <N extends Number> float sin(N radian) {
        return (float)Math.sin(radian.floatValue());
    }

    public static <N extends Number> float sind(N degree) {
        return (float)Math.sin(UtilMath.toRadians(Float.valueOf(degree.floatValue())));
    }

    public static <N extends Number> float cos(N radian) {
        return (float)Math.cos(radian.floatValue());
    }

    public static <N extends Number> float cosd(N degree) {
        return (float)Math.cos(UtilMath.toRadians(Float.valueOf(degree.floatValue())));
    }

    public static <N extends Number> float tan(N radian) {
        return (float)Math.tan(radian.floatValue());
    }

    public static <N extends Number> float tand(N degree) {
        return (float)Math.tan(UtilMath.toRadians(Float.valueOf(degree.floatValue())));
    }

    public static float inp(float f1, float f0, float partial) {
        return f0 + (f1 - f0) * partial;
    }

    public static float inpDeg(float f1, float f0, float partial) {
        return f0 + MathHelper.func_76142_g((float)(f1 - f0)) * partial;
    }

    public static float inpEX(Entity e, float partial) {
        return UtilMath.inp((float)e.field_70165_t, (float)e.field_70169_q, partial);
    }

    public static float inpEY(Entity e, float partial) {
        return UtilMath.inp((float)e.field_70163_u, (float)e.field_70167_r, partial);
    }

    public static float inpEZ(Entity e, float partial) {
        return UtilMath.inp((float)e.field_70161_v, (float)e.field_70166_s, partial);
    }
}

