/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.common.math.rota;

import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.IRotaAngles;
import net.railsofwar.row.common.math.rota.IRotaOrigin;
import net.railsofwar.row.common.math.rota.RotaBase;

public class RotaVec
extends RotaBase {
    private float relXIn;
    private float relYIn;
    private float relZIn;
    private float relXOut;
    private float relYOut;
    private float relZOut;
    private float absX;
    private float absY;
    private float absZ;
    private float relXInPrev;
    private float relYInPrev;
    private float relZInPrev;
    private float relXOutPrev;
    private float relYOutPrev;
    private float relZOutPrev;
    private float absXPrev;
    private float absYPrev;
    private float absZPrev;

    public RotaVec(float relX, float relY, float relZ) {
        this.relXIn = relX;
        this.relYIn = relY;
        this.relZIn = relZ;
    }

    public <T extends IRotaOrigin & IRotaAngles> RotaVec(T org, float relX, float relY, float relZ) {
        this(relX, relY, relZ);
        if (org != null) {
            this.origin = org;
            this.angles = org;
        }
    }

    public <T1 extends IRotaOrigin, T2 extends IRotaAngles> RotaVec(T1 org, T2 ang, float relX, float relY, float relZ) {
        this(relX, relY, relZ);
        if (org != null) {
            this.origin = org;
            this.angles = ang;
        }
    }

    public RotaVec(Entity ent, float relX, float relY, float relZ) {
        this(relX, relY, relZ);
        if (ent != null) {
            this.entity = ent;
        }
    }

    public RotaVec disableOrigin() {
        this.ignoreOrigin = true;
        return this;
    }

    @Override
    public void onUpdate() {
        this.bufferValues();
        float cosPhi = UtilMath.cos(Float.valueOf(UtilMath.toRadians(Float.valueOf(this.getOrgAzimuth()))));
        float sinPhi = UtilMath.sin(Float.valueOf(UtilMath.toRadians(Float.valueOf(this.getOrgAzimuth()))));
        float cosTheta = UtilMath.cos(Float.valueOf(UtilMath.toRadians(Float.valueOf(this.getOrgZenith()))));
        float sinTheta = UtilMath.sin(Float.valueOf(UtilMath.toRadians(Float.valueOf(this.getOrgZenith()))));
        this.relXOut = this.relXIn * cosPhi - this.relYIn * sinPhi * sinTheta - this.relZIn * sinPhi * cosTheta;
        this.relYOut = this.relYIn * cosTheta - this.relZIn * sinTheta;
        this.relZOut = this.relXIn * sinPhi + this.relYIn * cosPhi * sinTheta + this.relZIn * cosPhi * cosTheta;
        this.absX = this.relXOut + (this.ignoreOrigin ? 0.0f : this.getOrgX());
        this.absY = this.relYOut + (this.ignoreOrigin ? 0.0f : this.getOrgY());
        this.absZ = this.relZOut + (this.ignoreOrigin ? 0.0f : this.getOrgZ());
    }

    @Override
    void bufferValues() {
        this.relXInPrev = this.relXIn;
        this.relYInPrev = this.relYIn;
        this.relZInPrev = this.relZIn;
        this.relXOutPrev = this.relXOut;
        this.relYOutPrev = this.relYOut;
        this.relZOutPrev = this.relZOut;
        this.absXPrev = this.absX;
        this.absYPrev = this.absY;
        this.absZPrev = this.absZ;
    }

    public float getRelXIn() {
        return this.relXIn;
    }

    public float getRelYIn() {
        return this.relYIn;
    }

    public float getRelZIn() {
        return this.relZIn;
    }

    public float getRelXOut() {
        return this.relXOut;
    }

    public float getRelYOut() {
        return this.relYOut;
    }

    public float getRelZOut() {
        return this.relZOut;
    }

    public float getX() {
        return this.absX;
    }

    public float getY() {
        return this.absY;
    }

    public float getZ() {
        return this.absZ;
    }

    public float getRelXInPrev() {
        return this.relXInPrev;
    }

    public float getRelYInPrev() {
        return this.relYInPrev;
    }

    public float getRelZInPrev() {
        return this.relZInPrev;
    }

    public float getRelXOutPrev() {
        return this.relXOutPrev;
    }

    public float getRelYOutPrev() {
        return this.relYOutPrev;
    }

    public float getRelZOutPrev() {
        return this.relZOutPrev;
    }

    public float getXPrev() {
        return this.absXPrev;
    }

    public float getYPrev() {
        return this.absYPrev;
    }

    public float getZPrev() {
        return this.absZPrev;
    }

    public float getRelXInInp(float partial) {
        return UtilMath.inp(this.relXIn, this.relXInPrev, partial);
    }

    public float getRelYInInp(float partial) {
        return UtilMath.inp(this.relYIn, this.relYInPrev, partial);
    }

    public float getRelZInInp(float partial) {
        return UtilMath.inp(this.relZIn, this.relZInPrev, partial);
    }

    public float getRelXOutInp(float partial) {
        return UtilMath.inp(this.relXOut, this.relXOutPrev, partial);
    }

    public float getRelYOutInp(float partial) {
        return UtilMath.inp(this.relYOut, this.relYOutPrev, partial);
    }

    public float getRelZOutInp(float partial) {
        return UtilMath.inp(this.relZOut, this.relZOutPrev, partial);
    }

    public float getXInp(float partial) {
        return UtilMath.inp(this.absX, this.absXPrev, partial);
    }

    public float getYInp(float partial) {
        return UtilMath.inp(this.absY, this.absYPrev, partial);
    }

    public float getZInp(float partial) {
        return UtilMath.inp(this.absZ, this.absZPrev, partial);
    }

    public Vector3f getRelIn() {
        return new Vector3f(this.relXIn, this.relYIn, this.relZIn);
    }

    public Vector3f getRelOut() {
        return new Vector3f(this.relXOut, this.relYOut, this.relZOut);
    }

    public Vector3f getAbs() {
        return new Vector3f(this.absX, this.absY, this.absZ);
    }

    public Vector3f getRelInInp(float partial) {
        return new Vector3f(this.getRelXInInp(partial), this.getRelYInInp(partial), this.getRelZInInp(partial));
    }

    public Vector3f getRelOutInp(float partial) {
        return new Vector3f(this.getRelXOutInp(partial), this.getRelYOutInp(partial), this.getRelZOutInp(partial));
    }

    public Vector3f getAbsInp(float partial) {
        return new Vector3f(this.getXInp(partial), this.getYInp(partial), this.getZInp(partial));
    }
}

