/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IRegulatorD2;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.packets.PacketBrakeScrew;
import net.railsofwar.row.stock.packets.PacketDismount;
import net.railsofwar.row.stock.packets.PacketRegulator;
import net.railsofwar.row.stock.packets.PacketReverse;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class HandlerKeys {
    private static final String category = "key.categories.row";
    private static final KeyBinding reverseUp = new KeyBinding("1.1. Increase reverse", 21, "key.categories.row");
    private static final KeyBinding reverseDown = new KeyBinding("1.2. Decrease reverse", 35, "key.categories.row");
    private static final KeyBinding reverseZero = new KeyBinding("1.3. Zero the reverse", 49, "key.categories.row");
    private static final KeyBinding regulatorUp = new KeyBinding("2.1. Increase the regulator", 23, "key.categories.row");
    private static final KeyBinding regulatorDown = new KeyBinding("2.2. Decrease the regulator", 37, "key.categories.row");
    private static final KeyBinding regulatorZero = new KeyBinding("2.3. Zero the regulator", 51, "key.categories.row");
    private static final KeyBinding brakeScrewApply = new KeyBinding("3.1. Apply screw brake", 24, "key.categories.row");
    private static final KeyBinding brakeScrewRelease = new KeyBinding("3.2. Release screw brake", 25, "key.categories.row");
    private static final KeyBinding toggleRenderTrackBoxes = new KeyBinding("4.1. Toggle drawing track boxes", 64, "key.categories.row");
    private static Method unpressKeyMethod;

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyBinding)reverseUp);
        ClientRegistry.registerKeyBinding((KeyBinding)reverseDown);
        ClientRegistry.registerKeyBinding((KeyBinding)reverseZero);
        ClientRegistry.registerKeyBinding((KeyBinding)regulatorUp);
        ClientRegistry.registerKeyBinding((KeyBinding)regulatorDown);
        ClientRegistry.registerKeyBinding((KeyBinding)regulatorZero);
        ClientRegistry.registerKeyBinding((KeyBinding)brakeScrewApply);
        ClientRegistry.registerKeyBinding((KeyBinding)brakeScrewRelease);
        String name = Launch.blackboard.get("fml.deobfuscatedEnvironment").equals(true) ? "unpressKey" : "func_74505_d";
        unpressKeyMethod = ReflectionHelper.findMethod(KeyBinding.class, (String)name, null, (Class[])new Class[0]);
        unpressKeyMethod.setAccessible(true);
    }

    @SubscribeEvent
    public static void on(InputEvent.KeyInputEvent e) {
        EntityPlayerSP player;
        if (RoW.config != null) {
            if (toggleRenderTrackBoxes.func_151468_f()) {
                Config.renderTrackBoxes = !Config.renderTrackBoxes;
            }
            HandlerKeys.unpressKey(toggleRenderTrackBoxes);
        }
        if ((player = FMLClientHandler.instance().getClientPlayerEntity()) == null) {
            return;
        }
        if (player.func_184187_bx() instanceof RollingStock && player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            RollingStock stock = (RollingStock)player.func_184187_bx();
            if (stock == null || !stock.canControl((Entity)player)) {
                return;
            }
            if (FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151470_d()) {
                RoWStock.network.sendToServer((IMessage)new PacketDismount(player.func_145782_y()));
                HandlerKeys.unpressKey(FMLClientHandler.instance().getClient().field_71474_y.field_74311_E);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent e) {
        if (e.side.isServer()) {
            return;
        }
        if (e.player.func_184187_bx() instanceof RollingStock && e.player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            boolean release;
            boolean apply;
            RollingStock stock = (RollingStock)e.player.func_184187_bx();
            if (stock == null || !stock.canControl((Entity)e.player)) {
                return;
            }
            if (stock instanceof IReverseD3) {
                if (reverseUp.func_151468_f()) {
                    RoWStock.network.sendToServer((IMessage)new PacketReverse(stock.func_145782_y(), 1));
                    HandlerKeys.unpressKey(reverseUp);
                } else if (reverseDown.func_151468_f()) {
                    RoWStock.network.sendToServer((IMessage)new PacketReverse(stock.func_145782_y(), -1));
                    HandlerKeys.unpressKey(reverseDown);
                }
            }
            if (stock instanceof IRegulatorD5 || stock instanceof IRegulatorD2) {
                if (regulatorUp.func_151468_f()) {
                    RoWStock.network.sendToServer((IMessage)new PacketRegulator(stock.func_145782_y(), 1));
                    HandlerKeys.unpressKey(regulatorUp);
                } else if (regulatorDown.func_151468_f()) {
                    RoWStock.network.sendToServer((IMessage)new PacketRegulator(stock.func_145782_y(), -1));
                    HandlerKeys.unpressKey(regulatorDown);
                }
            }
            if (stock instanceof IReverseA) {
                if (reverseUp.func_151470_d()) {
                    RoWStock.network.sendToServer((IMessage)new PacketReverse(stock.func_145782_y(), 1));
                } else if (reverseDown.func_151470_d()) {
                    RoWStock.network.sendToServer((IMessage)new PacketReverse(stock.func_145782_y(), -1));
                } else if (reverseZero.func_151468_f()) {
                    RoWStock.network.sendToServer((IMessage)new PacketReverse(stock.func_145782_y(), 0));
                }
            }
            if (stock instanceof IRegulatorA) {
                if (regulatorUp.func_151470_d()) {
                    RoWStock.network.sendToServer((IMessage)new PacketRegulator(stock.func_145782_y(), 1));
                } else if (regulatorDown.func_151470_d()) {
                    RoWStock.network.sendToServer((IMessage)new PacketRegulator(stock.func_145782_y(), -1));
                } else if (regulatorZero.func_151468_f() && !((IRegulatorA)((Object)stock)).getIsRegulatorZeroed()) {
                    RoWStock.network.sendToServer((IMessage)new PacketRegulator(stock.func_145782_y(), 0));
                }
            }
            if (stock instanceof IBrakeScrew && (apply = brakeScrewApply.func_151470_d()) ^ (release = brakeScrewRelease.func_151470_d())) {
                RoWStock.network.sendToServer((IMessage)new PacketBrakeScrew(stock.func_145782_y(), apply, release));
            }
            HandlerKeys.unpressDiscreteKeys();
        }
    }

    public static void unpressDiscreteKeys() {
        HandlerKeys.unpressKey(reverseZero);
        HandlerKeys.unpressKey(regulatorZero);
    }

    public static void unpressKey(KeyBinding keyBinding) {
        try {
            unpressKeyMethod.invoke((Object)keyBinding, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

