/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.fml.server.FMLServerHandler;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.fleet.loco.LocoKof;

@Mod.EventBusSubscriber
public class HandlerStock {
    @SubscribeEvent
    public static void on(WorldEvent.Unload e) {
        RoW.clearStockMap(e.getWorld());
    }

    public static void on(PlayerInteractEvent.EntityInteractSpecific e) {
        if (e.getTarget() instanceof LocoKof && !e.getEntityPlayer().func_70093_af()) {
            LocoKof loco = (LocoKof)e.getTarget();
            float df = HandlerStock.dist(loco, e.getLocalPos(), loco.frontPlate);
            float dl = HandlerStock.dist(loco, e.getLocalPos(), loco.footLeft);
            float dr = HandlerStock.dist(loco, e.getLocalPos(), loco.footRight);
            float lim = 0.9f;
            loco.nextPass = dl < lim ? (byte)1 : (dr < lim ? (byte)2 : (df < lim ? (byte)3 : (byte)0));
            e.getEntityPlayer().func_184220_m((Entity)loco);
        }
    }

    private static float dist(Entity e, Vec3d local, RotaVec p) {
        Vector3f pos = new Vector3f((float)(e.field_70165_t + local.field_72450_a), (float)(e.field_70163_u + local.field_72448_b), (float)(e.field_70161_v + local.field_72449_c));
        pos.sub((Tuple3f)new Vector3f(p.getX(), p.getY(), p.getZ()));
        return pos.length();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world != null && world.field_72995_K && !FMLClientHandler.instance().getClient().func_147113_T()) {
            HandlerStock.updateTrainsPost((World)world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClient(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        if (FMLClientHandler.instance().getClient().func_71387_A() && !FMLClientHandler.instance().getClient().func_147113_T()) {
            for (WorldServer world : FMLClientHandler.instance().getServer().field_71305_c) {
                if (world == null || world.field_72995_K) continue;
                HandlerStock.updateTrainsPost((World)world);
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public static void on(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (WorldServer world : FMLServerHandler.instance().getServer().field_71305_c) {
            if (world == null || world.field_72995_K) continue;
            HandlerStock.updateTrainsPost((World)world);
        }
    }

    private static void updateTrainsPost(World world) {
        for (RollingStock stock : RoW.getRespectiveStockMap(world).values()) {
            if (stock == null || !world.func_175667_e(stock.func_180425_c()) || stock.field_70173_aa <= 20) continue;
            stock.onUpdatePost();
        }
    }
}

