/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.railsofwar.row.RoW;
import net.railsofwar.row.stock.client.renderfleet.RenderFlatbed;
import net.railsofwar.row.stock.client.renderfleet.RenderFowler;
import net.railsofwar.row.stock.client.renderfleet.RenderGuterwagen;
import net.railsofwar.row.stock.client.renderfleet.RenderIII2L8;
import net.railsofwar.row.stock.client.renderfleet.RenderKof;
import net.railsofwar.row.stock.client.renderfleet.RenderMinecart;
import net.railsofwar.row.stock.client.renderfleet.RenderMinelok;
import net.railsofwar.row.stock.client.renderfleet.RenderShay;
import net.railsofwar.row.stock.client.renderfleet.RenderSpinecar;
import net.railsofwar.row.stock.client.renderfleet.RenderUpnor;
import net.railsofwar.row.stock.core.EntityDismount;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.fleet.car.CarFlatbed;
import net.railsofwar.row.stock.fleet.car.CarGuterwagen;
import net.railsofwar.row.stock.fleet.car.CarGuterwagenBrems;
import net.railsofwar.row.stock.fleet.car.CarGuterwagenBremserhaus;
import net.railsofwar.row.stock.fleet.car.CarIII2L8;
import net.railsofwar.row.stock.fleet.car.CarMinecart;
import net.railsofwar.row.stock.fleet.car.CarSpinecar;
import net.railsofwar.row.stock.fleet.loco.LocoFowler;
import net.railsofwar.row.stock.fleet.loco.LocoKof;
import net.railsofwar.row.stock.fleet.loco.LocoMinelok;
import net.railsofwar.row.stock.fleet.loco.LocoShay;
import net.railsofwar.row.stock.fleet.loco.LocoUpnor;
import net.railsofwar.row.stock.item.ItemButtonSync;
import net.railsofwar.row.stock.item.ItemPrybar;
import net.railsofwar.row.stock.item.ItemStock;

public class RoWStock {
    public static SimpleNetworkWrapper network;
    public static List<Item> itemsStock;
    public static final ItemPrybar prybar;
    public static final ItemButtonSync buttonSyncStock;

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        RoWStock.register(LocoKof.class, RenderKof::new);
        RoWStock.register(LocoMinelok.class, RenderMinelok::new);
        RoWStock.register(LocoFowler.class, RenderFowler::new);
        RoWStock.register(LocoShay.class, RenderShay::new);
        RoWStock.register(LocoUpnor.class, RenderUpnor::new);
        RoWStock.register(CarFlatbed.class, RenderFlatbed::new);
        RoWStock.register(CarGuterwagen.class, RenderGuterwagen::new);
        RoWStock.register(CarGuterwagenBrems.class, RenderGuterwagen::new);
        RoWStock.register(CarGuterwagenBremserhaus.class, RenderGuterwagen::new);
        RoWStock.register(CarIII2L8.class, RenderIII2L8::new);
        RoWStock.register(CarSpinecar.class, RenderSpinecar::new);
        RoWStock.register(CarMinecart.class, RenderMinecart::new);
    }

    private static <T extends RollingStock> void register(Class<T> classStock, IRenderFactory<? super T> factory) {
        RenderingRegistry.registerEntityRenderingHandler(classStock, factory);
    }

    public static void init() {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("rowStock");
        for (StockPiece piece : StockPiece.values()) {
            RoW.instance.registerEntity(piece.classStock, 180, 1, true);
        }
        RoW.instance.registerEntity(EntityDismount.class, 16, 1, false);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (Item itemStock : itemsStock) {
            registry.register((IForgeRegistryEntry)itemStock);
        }
        registry.register((IForgeRegistryEntry)prybar);
        registry.register((IForgeRegistryEntry)buttonSyncStock);
    }

    static {
        prybar = new ItemPrybar();
        buttonSyncStock = new ItemButtonSync();
        itemsStock = new ArrayList<Item>();
        for (StockPiece piece : StockPiece.values()) {
            itemsStock.add(new ItemStock(RoW.getEntityName(piece.classStock), piece.tips, piece.classStock));
        }
    }

    private static enum StockPiece {
        LocoKof("Kof", Collections.singletonList("md DAYdiecast"), LocoKof.class),
        LocoShay("Shay", Arrays.asList("md Naiten", "tx DAYdiecast", "sp L\u00d6\u00d6PS"), LocoShay.class),
        LocoFowler("Fowler", Arrays.asList("md Naiten", "tx DAYdiecast"), LocoFowler.class),
        LocoMinelok("Minelok", Arrays.asList("md FrozeRain", "tx FrozeRain, DAYdiecast"), LocoMinelok.class),
        LocoUpnor("Upnor", Collections.singletonList("md Qweeqkk"), LocoUpnor.class),
        CarFlatbed("Flatbed", Collections.singletonList("md DAYdiecast"), CarFlatbed.class),
        CarGuterwagen("Guterwagen", Arrays.asList("md DAYdiecast", "sp L\u00d6\u00d6PS"), CarGuterwagen.class),
        CarGuterwagenBrems("GuterwagenBrems", Arrays.asList("md DAYdiecast", "sp L\u00d6\u00d6PS"), CarGuterwagenBrems.class),
        CarGuterwagenBremserhaus("GuterwagenBremserhaus", Arrays.asList("md DAYdiecast", "sp L\u00d6\u00d6PS"), CarGuterwagenBremserhaus.class),
        CarIII2L8("III2L8", Collections.singletonList("md DAYdiecast"), CarIII2L8.class),
        CarSpinecar("Spinecar", Arrays.asList("md Naiten", "tx DAYdiecast"), CarSpinecar.class),
        CarMinecart("Minecart", Collections.singletonList("md DAYdiecast"), CarMinecart.class);

        private final String name;
        private final List<String> tips;
        private final Class<? extends RollingStock> classStock;

        private <T extends RollingStock> StockPiece(String name, List<String> tips, Class<T> classStock) {
            this.name = name;
            this.tips = tips;
            this.classStock = classStock;
        }
    }
}

