/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.stock.client.ModelsStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.UtilPhysics;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.fleet.loco.LocoFowler;
import net.railsofwar.row.stock.fleet.loco.LocoKof;
import net.railsofwar.row.stock.fleet.loco.LocoMinelok;
import net.railsofwar.row.stock.fleet.loco.LocoShay;
import org.lwjgl.opengl.GL11;

public abstract class RenderStock
extends Render {
    protected RenderStock(RenderManager renderManager) {
        super(renderManager);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public abstract void render(RollingStock var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public void func_76986_a(Entity entity, double dx, double dy, double dz, float vanillaYaw, float partial) {
        entity.field_70170_p.field_72984_F.func_76320_a("rollingStockRender");
        RollingStock stock = (RollingStock)entity;
        float yaw = entity.field_70126_B + MathHelper.func_76142_g((float)(entity.field_70177_z - entity.field_70126_B)) * partial;
        float pitch = entity.field_70127_C + MathHelper.func_76142_g((float)(entity.field_70125_A - entity.field_70127_C)) * partial;
        this.render(stock, (float)dx, (float)dy, (float)dz, yaw, pitch, partial);
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74330_P) {
            float val;
            if (stock instanceof IReverseA) {
                val = ((IReverseA)((Object)stock)).getReverseMult();
                this.renderOverhead(stock, String.format("Reverse: %.2f", Float.valueOf(val)), -130, (float)dx, (float)dy, (float)dz);
            }
            if (stock instanceof IRegulatorA) {
                val = ((IRegulatorA)((Object)stock)).getRegulatorMult();
                this.renderOverhead(stock, String.format("Regulator: %.2f", Float.valueOf(val)), -120, (float)dx, (float)dy, (float)dz);
            }
            if (stock instanceof AuxTractor.I) {
                float effort = ((AuxTractor.I)((Object)stock)).get().getEffortBySpeed();
                this.renderOverhead(stock, String.format("Effort: %.3f", Float.valueOf(effort)), -110, (float)dx, (float)dy, (float)dz);
            }
            this.renderOverhead(stock, String.format("Speed: %.4f m/ti", Float.valueOf(Math.abs(stock.speed))), -100, (float)dx, (float)dy, (float)dz);
            this.renderOverhead(stock, String.format("Speed: %.2f km/h", Float.valueOf(UtilPhysics.mpt2kmph(Math.abs(stock.speed)))), -90, (float)dx, (float)dy, (float)dz);
            this.renderOverhead(stock, String.format("Speed: %.2f mi/h", Float.valueOf(UtilPhysics.mpt2miph(Math.abs(stock.speed)))), -80, (float)dx, (float)dy, (float)dz);
            this.renderOverhead(stock, String.format("Self: %.2f t", Float.valueOf(stock.getMassSelf())), -40, (float)dx, (float)dy, (float)dz);
            if (stock instanceof IBrakeScrew) {
                float brake = ((IBrakeScrew)((Object)stock)).getBrakeScrewPercentile();
                this.renderOverhead(stock, String.format("Screw: %.2f", Float.valueOf(brake)), -30, (float)dx, (float)dy, (float)dz);
            }
            if (stock instanceof LocoShay || stock instanceof LocoFowler) {
                this.renderOverhead(stock, String.format("Crank: %.2f rpm", Float.valueOf(stock.crankRPM)), -20, (float)dx, (float)dy, (float)dz);
            }
            if (stock instanceof LocoKof || stock instanceof LocoMinelok) {
                float reverse = stock instanceof IReverseA ? ((IReverseA)((Object)stock)).getReverseMult() : (stock instanceof IReverseD3 ? ((IReverseD3)((Object)stock)).getReverseMult() : 0.0f);
                float massDrawn = -stock.getMassSelf() + (reverse > 0.0f ? stock.getMassDrawnRear() : (reverse < 0.0f ? stock.getMassDrawnFront() : stock.getMassSelf()));
                float massBuffered = -stock.getMassSelf() + (reverse > 0.0f ? stock.getMassBufferedFront() : (reverse < 0.0f ? stock.getMassBufferedRear() : stock.getMassSelf()));
                float massTotal = massDrawn + massBuffered + stock.getMassSelf();
                this.renderOverhead(stock, String.format("Total: %.2f t", Float.valueOf(massTotal)), -20, (float)dx, (float)dy, (float)dz);
                this.renderOverhead(stock, String.format("Buff: %.2f t", Float.valueOf(massBuffered)), -50, (float)dx, (float)dy, (float)dz);
                this.renderOverhead(stock, String.format("Draw: %.2f t", Float.valueOf(massDrawn)), -60, (float)dx, (float)dy, (float)dz);
            }
        }
        if (this.field_76990_c.func_178634_b()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)dx, (double)dy, (double)dz);
            GL11.glTranslated((double)(-stock.field_70165_t), (double)(-stock.field_70163_u), (double)(-stock.field_70161_v));
            UtilModels.doVector(stock.couplerPosFront.getX(), stock.couplerPosFront.getY() - 0.5f, stock.couplerPosFront.getZ(), 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 2);
            UtilModels.doVector(stock.couplerPosRear.getX(), stock.couplerPosRear.getY() - 0.5f, stock.couplerPosRear.getZ(), 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 2);
            GL11.glPopMatrix();
        }
        entity.field_70170_p.field_72984_F.func_76319_b();
    }

    public void renderCouplers(RollingStock stock, boolean plain, boolean flip, float offset) {
        this.renderCouplerFront(stock, plain, flip, offset);
        this.renderCouplerRear(stock, plain, flip, offset);
    }

    public void renderCouplerFront(RollingStock stock, boolean plain, boolean flip, float offset) {
        GL11.glPushMatrix();
        if (flip) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslated((double)0.0, (double)offset, (double)(-stock.frontCouplerShift + 0.625f));
        if (stock.isCoupledFront() && !stock.frontCartUUID.equals("") && (stock.couplerCartFront.frontCartUUID.equals(stock.UUID) || stock.couplerCartFront.rearCartUUID.equals(stock.UUID))) {
            float dx = stock.couplerCartFront.couplerAxisPosFront.getX() - stock.couplerAxisPosFront.getX();
            float dz = stock.couplerCartFront.couplerAxisPosFront.getZ() - stock.couplerAxisPosFront.getZ();
            float beam = MathHelper.func_76142_g((float)((stock.couplerCartFront.field_70177_z + stock.field_70177_z + 180.0f) / 2.0f - stock.field_70177_z));
            if (stock.couplerCartFront.rearCartUUID.equals(stock.UUID)) {
                beam = MathHelper.func_76142_g((float)((stock.couplerCartFront.field_70177_z + stock.field_70177_z) / 2.0f - stock.field_70177_z));
                dx = stock.couplerCartFront.couplerAxisPosRear.getX() - stock.couplerAxisPosFront.getX();
                dz = stock.couplerCartFront.couplerAxisPosRear.getZ() - stock.couplerAxisPosFront.getZ();
            }
            if (beam > 90.0f) {
                beam -= 180.0f;
            }
            if (beam < -90.0f) {
                beam += 180.0f;
            }
            float a = (float)Math.toDegrees(Math.atan2(dx, dz)) + stock.field_70177_z + beam;
            float d = (float)Math.sqrt(dx * dx + dz * dz);
            float l = (d - 0.375f) / 2.0f;
            float h = (float)Math.sqrt(0.0625f - l * l);
            float b = (float)Math.toDegrees(Math.acos(l / 0.25f));
            if (0.0625f - l * l < 0.0f) {
                h = 0.0f;
                b = 0.0f;
            }
            GL11.glPushMatrix();
            UtilModels.renderModel(ModelsStock.couplerBuffer);
            GL11.glPopMatrix();
            UtilModels.renderModel(ModelsStock.couplerBase);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.28125);
            GL11.glRotatef((float)(-beam), (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerBeam);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.375, (double)0.6875, (double)0.0);
            GL11.glRotatef((float)a, (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerHook);
            GL11.glTranslated((double)0.0, (double)0.0625, (double)-0.177f);
            GL11.glRotatef((float)(-b), (float)1.0f, (float)0.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerLinkSide);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.375, (double)0.6875, (double)0.0);
            GL11.glRotatef((float)a, (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerEye);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0625, (double)-0.177f);
            GL11.glRotatef((float)(-b), (float)1.0f, (float)0.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerLinkSide);
            GL11.glPopMatrix();
            GL11.glTranslated((double)0.0, (double)(0.078125f - h), (double)(-d / 2.0f));
            UtilModels.renderModel(ModelsStock.couplerLink);
            GL11.glPopMatrix();
        } else {
            UtilModels.renderModel(stock.couplingModeOn ? (plain ? ModelsStock.couplerActivePlain : ModelsStock.couplerActive) : (plain ? ModelsStock.couplerFreePlain : ModelsStock.couplerFree));
        }
        GL11.glPopMatrix();
    }

    public void renderCouplerRear(RollingStock stock, boolean plain, boolean flip, float offset) {
        GL11.glPushMatrix();
        if (!flip) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslated((double)0.0, (double)offset, (double)(-stock.rearCouplerShift + 0.625f));
        if (stock.isCoupledRear() && !stock.rearCartUUID.equals("") && (stock.couplerCartRear.frontCartUUID.equals(stock.UUID) || stock.couplerCartRear.rearCartUUID.equals(stock.UUID))) {
            float dx = stock.couplerCartRear.couplerAxisPosRear.getX() - stock.couplerAxisPosRear.getX();
            float dz = stock.couplerCartRear.couplerAxisPosRear.getZ() - stock.couplerAxisPosRear.getZ();
            float beam = MathHelper.func_76142_g((float)((stock.couplerCartRear.field_70177_z + stock.field_70177_z + 180.0f) / 2.0f - stock.field_70177_z));
            if (stock.couplerCartRear.frontCartUUID.equals(stock.UUID)) {
                beam = MathHelper.func_76142_g((float)((stock.couplerCartRear.field_70177_z + stock.field_70177_z) / 2.0f - stock.field_70177_z));
                dx = stock.couplerCartRear.couplerAxisPosFront.getX() - stock.couplerAxisPosRear.getX();
                dz = stock.couplerCartRear.couplerAxisPosFront.getZ() - stock.couplerAxisPosRear.getZ();
            }
            if (beam > 90.0f) {
                beam -= 180.0f;
            }
            if (beam < -90.0f) {
                beam += 180.0f;
            }
            float a = 180.0f + (float)Math.toDegrees(Math.atan2(dx, dz)) + stock.field_70177_z + beam;
            float d = (float)Math.sqrt(dx * dx + dz * dz);
            float l = (d - 0.375f) / 2.0f;
            float h = (float)Math.sqrt(0.0625f - l * l);
            float b = (float)Math.toDegrees(Math.acos(l / 0.25f));
            if (0.0625f - l * l < 0.0f) {
                h = 0.0f;
                b = 0.0f;
            }
            GL11.glPushMatrix();
            UtilModels.renderModel(ModelsStock.couplerBuffer);
            GL11.glPopMatrix();
            UtilModels.renderModel(ModelsStock.couplerBase);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.28125);
            GL11.glRotatef((float)(-beam), (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerBeam);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.375, (double)0.6875, (double)0.0);
            GL11.glRotatef((float)a, (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerHook);
            GL11.glTranslated((double)0.0, (double)0.0625, (double)-0.177f);
            GL11.glRotatef((float)(-b), (float)1.0f, (float)0.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerLinkSide);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.375, (double)0.6875, (double)0.0);
            GL11.glRotatef((float)a, (float)0.0f, (float)1.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerEye);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0625, (double)-0.177f);
            GL11.glRotatef((float)(-b), (float)1.0f, (float)0.0f, (float)0.0f);
            UtilModels.renderModel(ModelsStock.couplerLinkSide);
            GL11.glPopMatrix();
            GL11.glTranslated((double)0.0, (double)(0.078125f - h), (double)(-d / 2.0f));
            UtilModels.renderModel(ModelsStock.couplerLink);
            GL11.glPopMatrix();
        } else {
            UtilModels.renderModel(stock.couplingModeOn ? (plain ? ModelsStock.couplerActivePlain : ModelsStock.couplerActive) : (plain ? ModelsStock.couplerFreePlain : ModelsStock.couplerFree));
        }
        GL11.glPopMatrix();
    }

    private void renderOverheadDebugInfo(RollingStock stock, float dx, float dy, float dz) {
        this.renderOverhead(stock, String.format("%.2f m/ti", Float.valueOf(stock.speed)), 10, dx, dy, dz);
        this.renderOverhead(stock, String.format("%.2f km/h", Float.valueOf(UtilPhysics.mpt2kmph(stock.speed))), 20, dx, dy, dz);
    }

    public void renderOverhead(RollingStock stock, String s, int h, float dx, float dy, float dz) {
        RenderManager rm = FMLClientHandler.instance().getClient().func_175598_ae();
        double d0 = stock.func_70068_e(rm.field_78734_h);
        if (d0 <= 4096.0) {
            EntityRenderer.func_189692_a((FontRenderer)rm.func_78716_a(), (String)s, (float)dx, (float)(dy + stock.field_70131_O), (float)dz, (int)h, (float)rm.field_78735_i, (float)rm.field_78732_j, (rm.field_78733_k.field_74320_O == 2 ? 1 : 0) != 0, (boolean)stock.func_70093_af());
        }
    }
}

