/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.client;

import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;
import net.railsofwar.row.stock.core.roller.RollerFrame2T2A;
import net.railsofwar.row.stock.core.valvegear.Valvegear;
import org.lwjgl.opengl.GL11;

public class UtilRenderStock {
    public static void doStatic(float ox, float oy, float oz, IBakedModel model) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)ox, (double)oy, (double)oz);
        UtilModels.renderModel(model);
        GL11.glPopMatrix();
    }

    public static void doSlide(float ox, float oy, float oz, float ax, float ay, float az, float amp, IBakedModel model) {
        UtilRenderStock.doStatic(ox + amp * ax, oy + amp * ay, oz + amp * az, model);
    }

    public static void doRotary(Vector3f origin, Vector3f direction, float degree, IBakedModel model) {
        UtilRenderStock.doRotary(origin.x, origin.y, origin.z, direction.x, direction.y, direction.z, degree, model);
    }

    public static void doRotarySide(float ox, float oy, float oz, float degree, IBakedModel model) {
        UtilRenderStock.doRotary(ox, oy, oz, 1.0f, 0.0f, 0.0f, degree, model);
    }

    public static void doRotaryVertical(float ox, float oy, float oz, float degree, IBakedModel model) {
        UtilRenderStock.doRotary(ox, oy, oz, 0.0f, 1.0f, 0.0f, degree, model);
    }

    public static void doRotaryFront(float ox, float oy, float oz, float degree, IBakedModel model) {
        UtilRenderStock.doRotary(ox, oy, oz, 0.0f, 0.0f, 1.0f, degree, model);
    }

    public static void doRotary(float ox, float oy, float oz, float ax, float ay, float az, float degree, IBakedModel model) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)ox, (double)oy, (double)oz);
        GL11.glRotatef((float)degree, (float)ax, (float)ay, (float)az);
        UtilModels.renderModel(model);
        GL11.glPopMatrix();
    }

    public static void doBrakeScrewHandle(IBrakeScrew brake, float ox, float oy, float oz, IBakedModel mHandle, float partial) {
        UtilRenderStock.doRotaryVertical(ox, oy, oz, -360.0f * brake.getBrakeScrewPercentilePartial(partial) * brake.getBrakeScrewRevolutions(), mHandle);
    }

    public static void doBrakeScrewHook(IBrakeScrew brake, float ox, float oy, float oz, float xJoint, float yJoint, IBakedModel mHook, float rStrap, IBakedModel mStrap, float partial) {
        float rHook = (float)Math.hypot(xJoint, yJoint);
        float aHook = (float)Math.atan2(yJoint, xJoint);
        float dHook = (float)Math.toDegrees(aHook);
        float y = yJoint + rStrap + brake.getBrakeScrewPercentilePartial(partial) * brake.getBrakeScrewStroke();
        float r = (float)Math.hypot(xJoint, y);
        float a = (float)Math.atan2(y, xJoint);
        float g1 = (float)((double)a - (double)Math.signum(xJoint) * Math.acos((r * r + rHook * rHook - rStrap * rStrap) / (2.0f * r * rHook)));
        float d1 = (float)Math.toDegrees(g1);
        float g2 = 1.5707964f - a;
        float g3 = Math.signum(xJoint) * (float)Math.acos((r * r + rStrap * rStrap - rHook * rHook) / (2.0f * r * rStrap)) - g2;
        float d3 = (float)Math.toDegrees(g3);
        GL11.glPushMatrix();
        GL11.glTranslated((double)ox, (double)(oy + y), (double)(oz - xJoint));
        GL11.glRotatef((float)d3, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mStrap);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)ox, (double)oy, (double)oz);
        GL11.glRotatef((float)((d1 - dHook) % 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mHook);
        GL11.glPopMatrix();
    }

    public static void doWheelset(RotaVec position, float angle, IBakedModel model) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)position.getRelZIn());
        GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(model);
        GL11.glPopMatrix();
    }

    public static void doTruck(RollingStock stock, boolean isFront, float wheelsetAngle, float partial, IBakedModel modelTruck, IBakedModel modelWheelset) {
        RollerFrame2T2A frame = (RollerFrame2T2A)stock.getFrame();
        RollerFrame2A truck = isFront ? frame.truckFront : frame.truckRear;
        GL11.glPushMatrix();
        UtilModels.translateWOrig(truck, (Entity)stock, partial);
        GL11.glRotatef((float)(-UtilMath.inpDeg(truck.azimuth, truck.azimuthPrev, partial)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)UtilMath.inpDeg(truck.zenith, truck.zenithPrev, partial), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(modelTruck);
        UtilRenderStock.doWheelset(truck.axleFrontPos, wheelsetAngle, modelWheelset);
        UtilRenderStock.doWheelset(truck.axleRearPos, wheelsetAngle, modelWheelset);
        GL11.glPopMatrix();
    }

    public static void doDrive(Valvegear gear, float w, float[] sWl, IBakedModel mDrive, IBakedModel mWl, IBakedModel mSiderod, float wSiderod, IBakedModel mConrod, float wConrod, IBakedModel mPiston) {
        float wRad = (float)Math.toRadians(w);
        float c1 = (float)Math.toDegrees(Math.asin((double)(gear.rCrank / gear.lConrod) * Math.sin(wRad + gear.iCylinderRad)));
        float c2 = (float)Math.toDegrees(Math.asin((double)(gear.rCrank / gear.lConrod) * Math.sin((double)(wRad + gear.iCylinderRad) + 1.5707963267948966)));
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)sWl[0]);
        GL11.glRotatef((float)w, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mDrive);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-wSiderod), (double)0.0, (double)(-gear.rCrank));
        GL11.glRotatef((float)(-w), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mSiderod);
        GL11.glTranslated((double)(-wConrod), (double)0.0, (double)0.0);
        GL11.glRotatef((float)(-gear.iCylinder + c1), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mConrod);
        GL11.glTranslated((double)0.0, (double)0.0, (double)gear.lConrod);
        GL11.glRotatef((float)(-c1), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mPiston);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)wSiderod, (double)gear.rCrank, (double)0.0);
        GL11.glRotatef((float)(-w), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mSiderod);
        GL11.glTranslated((double)wConrod, (double)0.0, (double)0.0);
        GL11.glRotatef((float)(-gear.iCylinder + c2), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mConrod);
        GL11.glTranslated((double)0.0, (double)0.0, (double)gear.lConrod);
        GL11.glRotatef((float)(-c2), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mPiston);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        for (int i = 1; i < sWl.length; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)sWl[i]);
            GL11.glRotatef((float)w, (float)1.0f, (float)0.0f, (float)0.0f);
            UtilModels.renderModel(mWl);
            GL11.glPopMatrix();
        }
    }

    private Vector2f rot(Vector2f origin, float radius, float radian) {
        return new Vector2f((float)((double)origin.x + (double)radius * Math.cos(radian)), (float)((double)origin.y + (double)radius * Math.sin(radian)));
    }

    private void doLink(IBakedModel model, Vector2f origin, float depth, float degree) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)depth, (double)origin.y, (double)origin.x);
        GL11.glRotatef((float)degree, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(model);
        GL11.glPopMatrix();
    }
}

