/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.client.renderfleet;

import javax.vecmath.Vector2f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.stock.client.ModelsStock;
import net.railsofwar.row.stock.client.RenderStock;
import net.railsofwar.row.stock.client.UtilRenderStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.valvegear.StephensonRadial;
import net.railsofwar.row.stock.fleet.loco.LocoFowler;
import org.lwjgl.opengl.GL11;

public class RenderFowler
extends RenderStock {
    public RenderFowler(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void render(RollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float partial) {
        LocoFowler loco = (LocoFowler)stock;
        this.func_110776_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-stock.frame2stockOffset), (float)0.0f);
        UtilModels.renderModel(ModelsStock.fowlerBody);
        float reverse = -13.0f * loco.getReverseMult();
        float regulator = -10.0f + 60.0f * loco.getRegulatorMult();
        float regulatorShift = 0.09375f * (float)Math.tan(Math.toRadians(regulator));
        float wheelset = loco.wheelAngle[0];
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.3125f, (float)1.71875f, (float)-0.96875f);
        GL11.glRotatef((float)(-regulator), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.fowlerRegHandle);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.3125f, (float)1.8125f, (float)(-0.96875f - regulatorShift));
        UtilModels.renderModel(ModelsStock.fowlerRegLink);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.9375f, (float)0.1875f);
        UtilModels.renderModel(ModelsStock.fowlerWhistle);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.46875f, (float)0.78125f, (float)-1.34375f);
        GL11.glRotatef((float)(-reverse), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.fowlerRevHandle);
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        GL11.glRotatef((float)reverse, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.fowlerRevLink);
        GL11.glPopMatrix();
        UtilRenderStock.doDrive(loco.valvegear, wheelset, loco.wheelShift, ModelsStock.fowlerWheelsetDriving, ModelsStock.fowlerWheelset, ModelsStock.fowlerSiderod, 0.53125f, ModelsStock.fowlerConrod, 0.0625f, ModelsStock.fowlerPiston);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)loco.wheelShift[0]);
        this.doValvegear(loco.valvegear, wheelset, reverse, ModelsStock.fowlerLinkEcc, -0.71875f, ModelsStock.fowlerLinkEcc, -0.78125f, ModelsStock.fowlerLinkLiftRight, -0.71875f, ModelsStock.fowlerLinkExpansion, -0.03125f, ModelsStock.fowlerValveRight);
        this.doValvegear(loco.valvegear, wheelset + 90.0f, reverse, ModelsStock.fowlerLinkEcc, 0.71875f, ModelsStock.fowlerLinkEcc, 0.78125f, ModelsStock.fowlerLinkLiftLeft, 0.71875f, ModelsStock.fowlerLinkExpansion, 0.03125f, ModelsStock.fowlerValveLeft);
        GL11.glTranslatef((float)0.0f, (float)loco.valvegear.pReverse.y, (float)loco.valvegear.pReverse.x);
        GL11.glRotatef((float)(-reverse), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.fowlerRevLever);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        this.renderCouplers(loco, false, false, 0.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void doValvegear(StephensonRadial gear, float shaft, float reverse, IBakedModel mEcc1, float wEcc1, IBakedModel mEcc2, float wEcc2, IBakedModel mLift, float wLift, IBakedModel mExpo, float wExpo, IBakedModel mValve) {
        float alpha = (float)Math.toRadians(shaft);
        float rho = (float)Math.toRadians(reverse);
        float rer = gear.lEccentric;
        float rsr = gear.lLift;
        float rx = 2.0f * gear.rExpansion;
        float ro = 0.34375f;
        float ra = gear.lExpansion;
        Vector2f B = new Vector2f(-gear.rEccentric * (float)Math.sin(alpha), -gear.rEccentric * (float)Math.cos(alpha));
        Vector2f F = new Vector2f(gear.rEccentric * (float)Math.sin(alpha), gear.rEccentric * (float)Math.cos(alpha));
        Vector2f D = new Vector2f(gear.pReverse.x + gear.rRev * (float)Math.cos(rho), gear.pReverse.y + gear.rRev * (float)Math.sin(rho));
        float lx = D.x - B.x;
        float ly = D.y - B.y;
        float l = (float)Math.sqrt(lx * lx + ly * ly);
        float gamma1 = (float)Math.atan2(ly, lx);
        float gamma2 = (float)Math.acos((l * l + rer * rer - rsr * rsr) / (2.0f * rer * l));
        Vector2f E = new Vector2f(B.x + rer * (float)Math.cos(gamma1 - gamma2), B.y + rer * (float)Math.sin(gamma1 - gamma2));
        float gamma4 = (float)Math.atan2(E.y - D.y, E.x - D.x);
        float gamma5 = (float)Math.atan2(E.y - B.y, E.x - B.x);
        float mx = E.x - F.x;
        float my = E.y - F.y;
        float m = (float)Math.sqrt(mx * mx + my * my);
        float gamma6 = (float)Math.atan2(my, mx);
        float gamma7 = (float)Math.acos((m * m + rer * rer - rx * rx) / (2.0f * rer * m));
        Vector2f G = new Vector2f(F.x + rer * (float)Math.cos(gamma6 + gamma7), F.y + rer * (float)Math.sin(gamma6 + gamma7));
        float gamma8 = (float)Math.atan2(G.y - E.y, G.x - E.x);
        float gamma9 = (float)Math.atan2(G.y - F.y, G.x - F.x);
        float rodShaftA = (float)Math.toDegrees(gamma4);
        float rodEccA = (float)Math.toDegrees(gamma5);
        float rodExpoA = (float)Math.toDegrees(gamma8);
        float rodEccA2 = (float)Math.toDegrees(gamma9);
        Vector2f N = new Vector2f((E.x + G.x) / 2.0f, (E.y + G.y) / 2.0f);
        Vector2f O = new Vector2f(N.x + ro * (float)Math.cos((double)gamma8 + 1.5707963267948966), N.y + ro * (float)Math.sin((double)gamma8 + 1.5707963267948966));
        float n = (float)Math.sqrt(O.x * O.x + O.y * O.y);
        float gamma10 = (float)Math.atan2(O.y, O.x) - (gear.iValveRad + gear.iCylinderRad);
        float cosg = (float)Math.cos(gamma10);
        float rp = (float)((double)(n * cosg) + Math.sqrt(ra * ra - n * n * (1.0f - cosg * cosg)));
        Vector2f P = new Vector2f(rp * (float)Math.cos(gear.iValveRad + gear.iCylinderRad), rp * (float)Math.sin(gear.iValveRad + gear.iCylinderRad));
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)gear.pReverse.y, (float)gear.pReverse.x);
        GL11.glRotatef((float)(-reverse), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)wLift, (float)0.0f, (float)gear.rRev);
        GL11.glRotatef((float)(reverse - rodShaftA), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mLift);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)wEcc1, (float)P.y, (float)P.x);
        GL11.glRotatef((float)(-gear.iValve - gear.iCylinder), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mValve);
        GL11.glPopMatrix();
        GL11.glRotatef((float)shaft, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)wEcc2, (float)gear.rEccentric, (float)0.0f);
        GL11.glRotatef((float)(-shaft - rodEccA2), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mEcc2);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)wEcc1, (float)(-gear.rEccentric), (float)0.0f);
        GL11.glRotatef((float)(-shaft - rodEccA), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mEcc1);
        GL11.glTranslatef((float)wExpo, (float)0.0f, (float)rer);
        GL11.glRotatef((float)(rodEccA - rodExpoA), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(mExpo);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

