/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.client.renderfleet;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.ModelsStock;
import net.railsofwar.row.stock.client.RenderStock;
import net.railsofwar.row.stock.client.UtilRenderStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;
import net.railsofwar.row.stock.fleet.loco.LocoShay;
import org.lwjgl.opengl.GL11;

public class RenderShay
extends RenderStock {
    public RenderShay(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void render(RollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float partial) {
        LocoShay loco = (LocoShay)stock;
        this.func_110776_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        float crank = loco.crankAngle;
        GL11.glPushMatrix();
        UtilModels.translateToRelIn(loco.frame.jointPos, -1.0f);
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.shayBody);
        float shaft_front = RenderShay.doShaftNew(loco, true, ModelsStock.shaySleeveFront, ModelsStock.shaySquareFront, loco.shaftEnginePivotFront, loco.shaftEngineDirFrontAx, loco.shaftEngineDirFrontRef1, loco.shaftEngineDirFrontRef2, crank, loco.shaftTruckPivotFront, loco.shaftTruckDirFrontAx, loco.shaftTruckDirFrontRef1, loco.shaftTruckDirFrontRef2, yaw, pitch, partial);
        float shaft_rear = RenderShay.doShaftNew(loco, false, ModelsStock.shaySleeveRear, ModelsStock.shaySquareRear, loco.shaftEnginePivotRear, loco.shaftEngineDirRearAx, loco.shaftEngineDirRearRef1, loco.shaftEngineDirRearRef2, crank, loco.shaftTruckPivotRear, loco.shaftTruckDirRearAx, loco.shaftTruckDirRearRef1, loco.shaftTruckDirRearRef2, yaw, pitch, partial);
        this.doTruckShay(loco, yaw, pitch, true, RenderShay.getWheelset(crank, shaft_front, loco.gearRatio), shaft_front, partial, ModelsStock.shayShaftFront);
        this.doTruckShay(loco, yaw, pitch, false, RenderShay.getWheelset(crank, shaft_rear, loco.gearRatio), shaft_rear, partial, ModelsStock.shayShaftRear);
        this.doEngine(crank, -RenderShay.doControls(loco));
        this.renderCouplers(loco, false, true, -0.8125f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static float doControls(LocoShay loco) {
        UtilRenderStock.doStatic(0.0f, -0.8125f, 0.0f, ModelsStock.shayArrows);
        UtilRenderStock.doRotaryVertical(-0.53125f, 1.375f, -0.90625f, 0.0f, ModelsStock.shayBrakeLoco);
        UtilRenderStock.doRotaryVertical(-0.46875f, 1.375f, -1.21875f, 0.0f, ModelsStock.shayBrakeTrain);
        RenderShay.doRegulator(loco);
        return RenderShay.doReverse(loco);
    }

    private static void doRegulator(LocoShay loco) {
        float amp = -0.078125f;
        float dz = 0.25f - amp * (loco.getRegulatorMult() - 0.5f);
        float dx = 0.15625f;
        float l1 = (float)Math.sqrt(dx * dx + dz * dz);
        float l2 = 0.25f;
        float l3 = 0.15625f;
        float a1 = (float)Math.atan(dx / dz);
        float a2 = (float)Math.acos((l1 * l1 + l2 * l2 - l3 * l3) / (2.0f * l1 * l2));
        float a3 = (float)Math.acos((l1 * l1 + l3 * l3 - l2 * l2) / (2.0f * l1 * l3));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.125f, (float)1.5f, (float)(-1.0625f + amp * (loco.getRegulatorMult() - 0.5f)));
        UtilModels.renderModel(ModelsStock.shayRegC);
        GL11.glRotatef((float)((float)Math.toDegrees(a1 + a3) - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.15625f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.shayRegB);
        GL11.glRotatef((float)((float)Math.toDegrees(-a1 - a3) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(a1 - a2)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.25f);
        UtilModels.renderModel(ModelsStock.shayRegA);
        GL11.glPopMatrix();
    }

    private static float doReverse(LocoShay loco) {
        float lim = 12.0f;
        float a1 = -UtilMath.toRadians(Float.valueOf(lim)) * loco.getReverseMult();
        float R0 = 0.21875f;
        float R = 0.5f;
        float r = 0.21875f;
        Vector3f p0 = new Vector3f(-0.78125f, 0.5625f, -1.0625f);
        Vector3f p3 = new Vector3f(-1.0f, 0.0625f, -0.8125f);
        float d = R0 * (1.0f - UtilMath.cos(Float.valueOf(a1)));
        float R1 = UtilMath.sqrt(Float.valueOf(R * R - d * d));
        Vector3f p1 = new Vector3f(p0.getX(), p0.getY() + R0 * UtilMath.sin(Float.valueOf(a1)), p0.getZ() + R0 * UtilMath.cos(Float.valueOf(a1)));
        Vector3f p11 = new Vector3f(p1.getX(), p1.getY(), p3.getZ());
        Vector3f p11p3 = new Vector3f(p3);
        p11p3.sub((Tuple3f)p11);
        float h = 0.5f + (R1 * R1 - r * r) / (2.0f * p11p3.lengthSquared());
        float e = -UtilMath.sqrt(Float.valueOf(R1 * R1 - h * h * p11p3.lengthSquared()));
        Vector3f dir = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f t = new Vector3f();
        t.cross(p11p3, dir);
        t.normalize();
        Vector3f pi = new Vector3f(p11p3);
        pi.scale(h);
        pi.add((Tuple3f)p11);
        Vector3f p2 = new Vector3f(t);
        p2.scale(e);
        p2.add((Tuple3f)pi);
        float shaft = (float)Math.atan2(p2.getY() - p3.getY(), p2.getX() - p3.getX());
        float shaftD = UtilMath.toDegrees(Float.valueOf(shaft));
        float ax = (float)(-Math.atan2(p2.getZ() - p1.getZ(), -p2.getY() + p1.getY()));
        float axD = UtilMath.toDegrees(Float.valueOf(ax));
        float az = (float)Math.atan2(p2.getX() - p1.getX(), -p2.getY() + p1.getY());
        float azD = UtilMath.toDegrees(Float.valueOf(az));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)p0.getX(), (float)p0.getY(), (float)p0.getZ());
        UtilModels.renderModel(ModelsStock.shayRevStand);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(lim * loco.getReverseMult()), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.shayRevLever);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)R0);
        GL11.glRotatef((float)(-lim * loco.getReverseMult() + axD), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)azD, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayRevLink);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        return shaftD;
    }

    private static float getWheelset(float crank, float shaft, float ratio) {
        if (shaft < 0.0f) {
            shaft += 360.0f;
        }
        float ar = shaft / ratio;
        float br = (float)Math.floor(crank / 360.0f);
        if (crank == -360.0f) {
            br = -2.0f;
        }
        if (crank == -720.0f) {
            br = -3.0f;
        }
        return -ar - br * 120.0f;
    }

    private static float doShaftNew(LocoShay loco, boolean isFront, IBakedModel mSleeve, IBakedModel mSquare, RotaVec inPos, RotaVec inDirAx, RotaVec inDirRef1, RotaVec inDirRef2, float inDeg, RotaVec outPos, RotaVec outDirAx, RotaVec outDirRef1, RotaVec outDirRef2, float frameYaw, float framePitch, float partial) {
        float a_in = (float)Math.toRadians(inDeg);
        Vector3f i_pos = inPos.getAbs();
        Vector3f i_ax = inDirAx.getAbs();
        Vector3f i_ref1 = inDirRef1.getAbs();
        Vector3f i_ref2 = inDirRef2.getAbs();
        Vector3f o_pos = outPos.getAbs();
        Vector3f o_ax = outDirAx.getAbs();
        Vector3f o_ref1 = outDirRef1.getAbs();
        Vector3f o_ref2 = outDirRef2.getAbs();
        i_ax.normalize();
        i_ref1.normalize();
        i_ref2.normalize();
        o_ax.normalize();
        o_ref1.normalize();
        o_ref2.normalize();
        float sin_a_in = (float)Math.sin(a_in);
        float cos_a_in = (float)Math.cos(a_in);
        Vector3f rot1 = new Vector3f(sin_a_in * i_ref1.getX() + cos_a_in * i_ref2.getX(), sin_a_in * i_ref1.getY() + cos_a_in * i_ref2.getY(), sin_a_in * i_ref1.getZ() + cos_a_in * i_ref2.getZ());
        Vector3f i_ort = new Vector3f(cos_a_in * i_ref1.getX() - sin_a_in * i_ref2.getX(), cos_a_in * i_ref1.getY() - sin_a_in * i_ref2.getY(), cos_a_in * i_ref1.getZ() - sin_a_in * i_ref2.getZ());
        Vector3f s = new Vector3f(o_pos);
        s.sub((Tuple3f)i_pos);
        float l = s.length();
        s.normalize();
        Vector3f rot2 = new Vector3f();
        rot2.cross(s, rot1);
        rot2.normalize();
        Vector3f rot3 = new Vector3f();
        rot3.cross(o_ax, rot2);
        rot3.scale(-1.0f);
        rot3.normalize();
        Vector3f o_ort = new Vector3f();
        o_ort.cross(o_ax, rot3);
        o_ort.normalize();
        Vector3f rej1 = new Vector3f(rot2);
        rej1.sub((Tuple3f)i_ort);
        rej1.normalize();
        Vector3f rej2 = new Vector3f(rot2);
        rej2.sub((Tuple3f)o_ort);
        rej2.normalize();
        float p_u = rot3.dot(o_ref1);
        float p_v = rot3.dot(o_ref2);
        float a_out = (float)Math.atan2(p_u, p_v);
        float out_d = (float)Math.toDegrees(a_out);
        float p2_u = s.dot(i_ref1);
        float p2_v = s.dot(i_ref2);
        float sleeve = (float)Math.atan2(p2_v, p2_u);
        float sleeve_d = (float)Math.toDegrees(sleeve);
        float bend = (float)Math.acos(s.dot(i_ax));
        float bend_d = (float)Math.toDegrees(bend);
        if (Math.abs(bend_d) > 90.0f) {
            bend_d -= 180.0f;
        }
        float mid = (float)(-Math.atan2(Math.sin(a_in), Math.cos(a_in) * Math.cos(bend))) + sleeve;
        float mid_d = (float)Math.toDegrees(mid);
        float joint = (float)Math.acos(rot2.dot(i_ort)) * Math.signum(rej1.dot(s));
        float jointDeg = (float)Math.toDegrees(joint);
        float joint2 = (float)Math.acos(rot2.dot(o_ort)) * Math.signum(rej2.dot(s));
        float joint2Deg = (float)Math.toDegrees(joint2);
        RollerFrame2A truck = isFront ? loco.frame.truckFront : loco.frame.truckRear;
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)inPos.getRelXIn(), (float)inPos.getRelYIn(), (float)inPos.getRelZIn());
        GL11.glRotatef((float)(-sleeve_d), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(bend_d * (float)(inDirAx.getRelZIn() > 0.0f ? -1 : 1)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)mid_d, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(mSleeve);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)inPos.getRelXIn(), (float)inPos.getRelYIn(), (float)inPos.getRelZIn());
        GL11.glRotatef((float)inDeg, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)jointDeg, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.shayJoint);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        UtilModels.translateToRelIn(isFront ? loco.frame.jointFrontPos : loco.frame.jointRearPos);
        GL11.glRotatef((float)(-framePitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)frameYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-UtilMath.inpDeg(truck.azimuth, truck.azimuthPrev, partial)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)UtilMath.inpDeg(truck.zenith, truck.zenithPrev, partial), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.translateToRelIn(truck.jointPos, -1.0f);
        UtilModels.translateToRelIn(outPos);
        GL11.glPushMatrix();
        GL11.glRotatef((float)out_d, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)joint2Deg, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.shayJoint);
        GL11.glPopMatrix();
        GL11.glRotatef((float)(-UtilMath.inpDeg(truck.zenith, truck.zenithPrev, partial)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)UtilMath.inpDeg(truck.azimuth, truck.azimuthPrev, partial), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-frameYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)framePitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-sleeve_d), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(bend_d * (float)(inDirAx.getRelZIn() > 0.0f ? -1 : 1)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)mid_d, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(mSquare);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        return out_d;
    }

    private void doEngine(float shaftA, float revA) {
        float crank = 0.15625f;
        float conrod = 0.59375f;
        float conrod1A = (float)Math.toDegrees(Math.asin((double)crank * Math.cos(Math.toRadians(shaftA)) / (double)conrod));
        float conrod2A = (float)Math.toDegrees(Math.asin((double)crank * Math.cos(Math.toRadians(shaftA + 90.0f)) / (double)conrod));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.75f, (float)-0.4375f, (float)0.0f);
        this.doValvegear(shaftA, revA, -0.625f, -0.4375f, -0.5f, -0.4375f, ModelsStock.shayRevRod1, ModelsStock.shayRevSlider1, ModelsStock.shayRevEccentric1, ModelsStock.shayRevEccentric2);
        this.doValvegear(shaftA + 90.0f, revA, 0.625f, 0.4375f, 0.4375f, 0.5f, ModelsStock.shayRevRod2, ModelsStock.shayRevSlider2, ModelsStock.shayRevEccentric1, ModelsStock.shayRevEccentric3);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.25f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(-revA), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayRevShaft);
        GL11.glPopMatrix();
        GL11.glRotatef((float)shaftA, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayCrankshaft);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-crank), (float)0.0f, (float)-0.1875f);
        GL11.glRotatef((float)(-shaftA - conrod1A), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayConrod);
        GL11.glTranslatef((float)0.0f, (float)conrod, (float)0.0f);
        GL11.glRotatef((float)conrod1A, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayPiston);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-crank), (float)0.1875f);
        GL11.glRotatef((float)(-shaftA - conrod2A), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayConrod);
        GL11.glTranslatef((float)0.0f, (float)conrod, (float)0.0f);
        GL11.glRotatef((float)conrod2A, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayPiston);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void doValvegear(float shaftA, float revA, float yRod, float ySlider, float yEcc1, float yEcc2, IBakedModel rod, IBakedModel slider, IBakedModel eccentric1, IBakedModel eccentric2) {
        float alpha = (float)Math.toRadians(shaftA);
        float rho = (float)Math.toRadians(revA);
        float re = 0.0625f;
        float rs = 0.375f;
        float rer = 0.875f;
        float rsr = 0.40311876f;
        float rx = 0.30605f;
        float ro = 0.8727375f;
        float ra = 0.9375f;
        Vector2f B = new Vector2f(-re * (float)Math.sin(-alpha), -re * (float)Math.cos(-alpha));
        Vector2f D = new Vector2f(-0.25f + rs * (float)Math.sin(rho), 0.5f + rs * (float)Math.cos(rho));
        float lx = D.x - B.x;
        float ly = D.y - B.y;
        float l = (float)Math.sqrt(lx * lx + ly * ly);
        float gamma1 = (float)Math.atan2(ly, -lx);
        float gamma2 = (float)Math.acos((l * l + rer * rer - rsr * rsr) / (2.0f * rer * l));
        Vector2f E = new Vector2f(B.x - rer * (float)Math.cos(gamma1 + gamma2), B.y + rer * (float)Math.sin(gamma1 + gamma2));
        float gamma4 = (float)Math.atan2(D.y - E.y, -D.x + E.x);
        float gamma5 = (float)Math.atan2(E.x - B.x, E.y - B.y);
        Vector2f F = new Vector2f(re * (float)Math.sin(-alpha), re * (float)Math.cos(-alpha));
        float mx = E.x - F.x;
        float my = E.y - F.y;
        float m = (float)Math.sqrt(mx * mx + my * my);
        float gamma6 = (float)Math.atan2(my, mx);
        float gamma7 = (float)Math.acos((m * m + rer * rer - rx * rx) / (2.0f * rer * m));
        Vector2f G = new Vector2f(F.x + rer * (float)Math.cos(gamma6 + gamma7), F.y + rer * (float)Math.sin(gamma6 + gamma7));
        float gamma8 = (float)Math.atan2(G.y - E.y, -G.x + E.x);
        float gamma9 = (float)Math.atan2(G.x - F.x, G.y - F.y);
        float rodShaftA = (float)Math.toDegrees(gamma4);
        float rodEccA = (float)Math.toDegrees(gamma5);
        float rodExpoA = (float)Math.toDegrees(gamma8);
        float rodEccA2 = (float)Math.toDegrees(gamma9);
        Vector2f N = new Vector2f((E.x + G.x) / 2.0f, (E.y + G.y) / 2.0f);
        Vector2f O = new Vector2f(N.x - ro * (float)Math.cos((double)gamma8 - 1.5707963267948966), N.y + ro * (float)Math.sin((double)gamma8 - 1.5707963267948966));
        float s = O.y + ra * (float)Math.sin(Math.acos(O.x / ra));
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.25f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(-revA), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)rs, (float)yRod);
        GL11.glRotatef((float)(revA - rodShaftA), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(rod);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)s, (float)ySlider);
        UtilModels.renderModel(slider);
        GL11.glPopMatrix();
        GL11.glRotatef((float)shaftA, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-re), (float)yEcc2);
        GL11.glRotatef((float)(-shaftA - rodEccA), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(eccentric2);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)re, (float)yEcc1);
        GL11.glRotatef((float)(-shaftA - rodEccA2), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(eccentric1);
        GL11.glTranslatef((float)0.0f, (float)rer, (float)0.03125f);
        GL11.glRotatef((float)(rodEccA2 - rodExpoA), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsStock.shayRevExpo);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void doTruckShay(LocoShay loco, float frameYaw, float framePitch, boolean isFront, float wheelsetAngle, float shaft, float partial, IBakedModel modelShaft) {
        RollerFrame2A truck = isFront ? loco.frame.truckFront : loco.frame.truckRear;
        GL11.glPushMatrix();
        UtilModels.translateToRelIn(isFront ? loco.frame.jointFrontPos : loco.frame.jointRearPos);
        GL11.glRotatef((float)(-framePitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)frameYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-UtilMath.inpDeg(truck.azimuth, truck.azimuthPrev, partial)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)UtilMath.inpDeg(truck.zenith, truck.zenithPrev, partial), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.translateToRelIn(truck.jointPos, -1.0f);
        UtilModels.renderModel(ModelsStock.shayTruck);
        UtilRenderStock.doWheelset(truck.axleFrontPos, wheelsetAngle, ModelsStock.shayWheelset);
        UtilRenderStock.doWheelset(truck.axleRearPos, wheelsetAngle, ModelsStock.shayWheelset);
        UtilModels.translateToRelIn(isFront ? loco.shaftTruckPivotFront : loco.shaftTruckPivotRear);
        GL11.glRotatef((float)shaft, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(modelShaft);
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return new ResourceLocation("row:stock/shay/body");
    }
}

