/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.client.renderfleet;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.stock.client.ModelsStock;
import net.railsofwar.row.stock.client.RenderStock;
import net.railsofwar.row.stock.client.UtilRenderStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;
import net.railsofwar.row.stock.fleet.car.CarSpinecar;
import org.lwjgl.opengl.GL11;

public class RenderSpinecar
extends RenderStock {
    public RenderSpinecar(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void render(RollingStock stockIn, float dx, float dy, float dz, float yaw, float pitch, float partial) {
        CarSpinecar stock = (CarSpinecar)stockIn;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        this.func_110776_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        UtilModels.translateToRelIn(stock.frame.jointPos, -1.0f);
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsStock.spinecarBody);
        UtilModels.renderModel(ModelsStock.spinecarLogs);
        this.doTruckSpinecar(stock, yaw, pitch, true, stock.wheelAngle[0], partial);
        this.doTruckSpinecar(stock, yaw, pitch, false, stock.wheelAngle[1], partial);
        UtilRenderStock.doBrakeScrewHandle(stock, 0.25f, -0.125f, -3.1875f, ModelsStock.spinecarBrakeHandle, partial);
        this.renderCouplers(stock, false, true, -0.65625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void doTruckSpinecar(CarSpinecar car, float frameYaw, float framePitch, boolean isFront, float wheelsetAngle, float partial) {
        RollerFrame2A truck = isFront ? car.frame.truckFront : car.frame.truckRear;
        GL11.glPushMatrix();
        UtilModels.translateToRelIn(isFront ? car.frame.jointFrontPos : car.frame.jointRearPos);
        GL11.glRotatef((float)(-framePitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)frameYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-UtilMath.inpDeg(truck.azimuth, truck.azimuthPrev, partial)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)UtilMath.inpDeg(truck.zenith, truck.zenithPrev, partial), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.translateToRelIn(truck.jointPos, -1.0f);
        UtilModels.renderModel(ModelsStock.spinecarTruck);
        UtilRenderStock.doWheelset(truck.axleFrontPos, wheelsetAngle, ModelsStock.wheelset10);
        UtilRenderStock.doWheelset(truck.axleRearPos, wheelsetAngle, ModelsStock.wheelset10);
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return new ResourceLocation("row:stock/spinecar/body");
    }
}

