/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.command;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.util.UtilText;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.packets.command.PacketCommandStockCount;
import net.railsofwar.row.stock.packets.command.PacketCommandStockReload;

public class CommandStockManager
implements ICommand {
    public String func_71517_b() {
        return "stock";
    }

    public String func_71518_a(ICommandSender sender) {
        return "stock [[[count|reload][server|client]]|sync|stop]";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1 || args.length > 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        World world = sender.func_130014_f_();
        if (world.field_72995_K) return;
        if (args[0].equalsIgnoreCase("count") && args.length == 2) {
            if (args[1].equalsIgnoreCase("server")) {
                CommandStockManager.doCount(world, sender);
                return;
            } else {
                if (!args[1].equalsIgnoreCase("client")) throw new WrongUsageException("stock count [server|client]", new Object[0]);
                if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException("What are you expecting?", new Object[0]);
                RoWStock.network.sendTo((IMessage)new PacketCommandStockCount(), (EntityPlayerMP)sender);
            }
            return;
        } else if (args[0].equalsIgnoreCase("reload") && args.length == 2) {
            if (args[1].equalsIgnoreCase("server")) {
                CommandStockManager.doReload(world, sender);
                return;
            } else {
                if (!args[1].equalsIgnoreCase("client")) throw new WrongUsageException("stock reload [server|client]", new Object[0]);
                if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException("What are you expecting?", new Object[0]);
                RoWStock.network.sendTo((IMessage)new PacketCommandStockReload(), (EntityPlayerMP)sender);
            }
            return;
        } else if (args[0].equalsIgnoreCase("stop") && args.length == 1) {
            RoW.getRespectiveStockMap(world).values().iterator().forEachRemaining(s -> {
                s.zeroControls();
                s.sendUpdateToClient();
            });
            sender.func_145747_a((ITextComponent)UtilText.format(TextFormatting.RESET, "Stopped stock via the manager", new Object[0]));
            return;
        } else {
            if (!args[0].equalsIgnoreCase("sync") || args.length != 1) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            RoW.getRespectiveStockMap(world).values().iterator().forEachRemaining(RollingStock::sendUpdateToClient);
            sender.func_145747_a((ITextComponent)UtilText.format(TextFormatting.RESET, "Synced stock via the manager", new Object[0]));
        }
    }

    public static void doReload(World world, ICommandSender sender) {
        Map<Integer, RollingStock> map = RoW.getRespectiveStockMap(world);
        long countPre = map.size();
        map.clear();
        world.field_72996_f.stream().filter(e -> e instanceof RollingStock).map(e -> (RollingStock)e).iterator().forEachRemaining(RollingStock::addToMap);
        String str = String.format("Reloaded stock manager at %s (pre/post): %d/%d", world.field_72995_K ? "client" : "server", countPre, map.size());
        sender.func_145747_a((ITextComponent)UtilText.format(TextFormatting.RESET, str, new Object[0]));
    }

    public static void doCount(World world, ICommandSender sender) {
        long countWorld = world.field_72996_f.stream().filter(e -> e instanceof RollingStock).count();
        long countManager = RoW.getRespectiveStockMap(world).size();
        String str = String.format("%s stock count (world/manager): %d/%d", world.field_72995_K ? "Client" : "Server", countWorld, countManager);
        sender.func_145747_a((ITextComponent)UtilText.format(TextFormatting.RESET, str, new Object[0]));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(this.getRequiredPermissionLevel(), this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"count", "reload", "sync", "stop"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("count") || args[0].equalsIgnoreCase("reload")) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"server", "client"});
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    private int getRequiredPermissionLevel() {
        return 1;
    }
}

