/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.railsofwar.row.RoW;
import net.railsofwar.row.stock.core.RollingStock;

public class ChunkLoader
implements ForgeChunkManager.LoadingCallback {
    private Map<Entity, ForgeChunkManager.Ticket> stockTickets = Maps.newHashMap();
    private static Map<Block, ForgeChunkManager.Ticket> blockTickets = Maps.newHashMap();
    private static List<RollingStock> stockList = new ArrayList<RollingStock>();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket modTicket : tickets) {
            if (!modTicket.getModId().equals("row")) continue;
            modTicket.setChunkListDepth(1);
            if (!modTicket.getType().equals((Object)ForgeChunkManager.Type.ENTITY)) continue;
            this.stockTickets.put(modTicket.getEntity(), modTicket);
        }
    }

    private void setStockTicket(Entity stock, World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)RoW.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        ticket.setChunkListDepth(1);
        ticket.bindEntity(stock);
        this.stockTickets.put(stock, ticket);
    }

    @SubscribeEvent
    public void on(WorldEvent.Unload event) {
        this.stockTickets.clear();
    }

    @SubscribeEvent
    public void on(TickEvent.WorldTickEvent event) {
        stockList.clear();
        for (int i = 0; i < event.world.field_72996_f.size(); ++i) {
            Entity stock = (Entity)event.world.field_72996_f.get(i);
            if (!(stock instanceof RollingStock)) continue;
            stockList.add((RollingStock)stock);
            if (event.world.field_72995_K) continue;
            if (!this.stockTickets.containsKey(stock)) {
                this.setStockTicket(stock, event.world);
                continue;
            }
            if (stock.field_70128_L) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.stockTickets.get(stock));
                this.stockTickets.remove(stock);
                continue;
            }
            ForgeChunkManager.Ticket stockTicket = this.stockTickets.get(stock);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)stockTicket, (ChunkPos)new ChunkPos(stockTicket.getEntity().field_70176_ah, stockTicket.getEntity().field_70164_aj));
            this.stockTickets.put(stock, stockTicket);
        }
    }
}

