/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.RotaCord;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.client.sound.HandlerStockSounds;
import net.railsofwar.row.stock.client.sound.SoundStockRoll;
import net.railsofwar.row.stock.client.sound.SoundStockSkirr;
import net.railsofwar.row.stock.core.UtilPhysics;
import net.railsofwar.row.stock.core.auxiliary.AuxSmoker;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IRegulatorD2;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.core.plugin.IWhistle;
import net.railsofwar.row.stock.core.roller.IRoller;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.packets.PacketNBT;
import net.railsofwar.row.stock.packets.PacketPosition;
import net.railsofwar.row.stock.packets.PacketRequestServerNBTData;

public abstract class RollingStock
extends Entity
implements IRoller {
    public float crankAngle;
    public float crankRPM;
    protected byte crankQuadPrev;
    @SideOnly(value=Side.CLIENT)
    private SoundStockRoll soundRoll;
    @SideOnly(value=Side.CLIENT)
    private SoundStockSkirr soundSkirr;
    public float frame2stockOffset;
    public float bogieRearAngle;
    public float bogieFrontAngle;
    public float bogieRearAnglePrev;
    public float bogieFrontAnglePrev;
    protected float bogieRearSpeed;
    protected float bogieFrontSpeed;
    public float[] wheelAngle;
    public float[] wheelRadii;
    public float[] wheelShift;
    public float speed;
    public float speedCap;
    protected float unitX;
    protected float unitY;
    protected float unitZ;
    protected float massBare;
    public boolean drawPoints;
    public boolean couplingModeOn;
    public float rearCouplerShift;
    public float frontCouplerShift;
    public double couplerStretchRear;
    public double couplerStretchFront;
    public RotaCord axes;
    public RotaVec couplerPosFront;
    public RotaVec couplerPosRear;
    public RotaVec couplerAxisPosFront;
    public RotaVec couplerAxisPosRear;
    public String UUID;
    public String frontCartUUID = "";
    public String rearCartUUID = "";
    public RollingStock couplerCartFront;
    public RollingStock couplerCartRear;
    private boolean couplerFindFlag;
    private int couplerFindCount;
    private int couplerFindTimer;
    private boolean needsUpdate1 = true;
    private boolean needsUpdate2 = true;
    private int mapId;
    private int updateTick;
    public Map<Integer, Entity> passengers;

    public abstract EnumCoupler getCouplerFront();

    public abstract EnumCoupler getCouplerRear();

    public final EnumCoupler getCouplerRespective(boolean front) {
        return front ? this.getCouplerFront() : this.getCouplerRear();
    }

    public final RotaVec getCouplerPosRespective(boolean front) {
        return front ? this.couplerPosFront : this.couplerPosRear;
    }

    public RollingStock(World world) {
        super(world);
        if (world.field_72995_K) {
            RollingStock.func_184227_b((double)3.0);
        }
        this.passengers = new HashMap<Integer, Entity>();
        this.func_70105_a(2.0f, 2.5f);
        this.speedCap = 0.5f;
        this.drawPoints = true;
        this.frame2stockOffset = 0.5f;
        this.rearCouplerShift = 4.4375f;
        this.frontCouplerShift = 4.4375f;
        this.massBare = 4.0f;
        this.wheelAngle = new float[]{0.0f, 0.0f};
        this.wheelRadii = new float[]{0.375f, 0.375f};
        this.UUID = String.valueOf(this.func_110124_au());
        this.func_184211_a("stock");
        this.initiateCouplerFind();
        this.addToMap();
    }

    public void addToMap() {
        this.mapId = RoW.getRespectiveStockMap(this.field_70170_p).size();
        RoW.getRespectiveStockMap(this.field_70170_p).put(this.mapId, this);
    }

    public void init() {
        this.axes = new RotaCord(this);
        this.couplerPosRear = new RotaVec(this, 0.0f, 0.0f, -this.rearCouplerShift);
        this.couplerPosFront = new RotaVec(this, 0.0f, 0.0f, this.frontCouplerShift);
        this.couplerAxisPosRear = new RotaVec(this, 0.0f, 0.0f, -this.rearCouplerShift + 0.34375f);
        this.couplerAxisPosFront = new RotaVec(this, 0.0f, 0.0f, this.frontCouplerShift - 0.34375f);
        if (this.field_70170_p.field_72995_K) {
            this.addLoopingSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        if (this.field_70170_p.field_72995_K) {
            if (this.soundRoll == null) {
                this.soundRoll = new SoundStockRoll(this);
                RoW.proxy.playSound(this.soundRoll);
            }
            if (this.soundSkirr == null) {
                this.soundSkirr = new SoundStockSkirr(this);
                RoW.proxy.playSound(this.soundSkirr);
            }
        }
    }

    protected void func_70088_a() {
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() || !this.func_184228_n((Entity)player)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getPositionForPassenger((Entity)player) != null) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (damageSource.func_76364_f() instanceof EntityPlayer && damageSource.func_76364_f().func_70093_af() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.field_70170_p.func_72900_e((Entity)this);
            return true;
        }
        this.sendUpdateToClient();
        return false;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        if (Config.skipStockUpdates) {
            return;
        }
        if (this.field_70173_aa <= 2) {
            return;
        }
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.drawPoints = false;
        if (this.needsUpdate1 && this.field_70173_aa >= 3) {
            this.needsUpdate1 = false;
            if (this.field_70170_p.field_72995_K) {
                RoWStock.network.sendToServer((IMessage)new PacketRequestServerNBTData(this.func_145782_y()));
            } else {
                RoWStock.network.sendToAll((IMessage)new PacketPosition(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, true));
            }
        }
        if (this.needsUpdate2 && this.field_70173_aa >= 200) {
            this.needsUpdate2 = false;
            if (!this.field_70170_p.field_72995_K) {
                this.sendUpdateToClient();
            }
        }
        if (this.couplerFindFlag) {
            if (this.couplerFindCount < 5) {
                if (this.couplerFindTimer == 0) {
                    this.findCoupled();
                } else if (++this.couplerFindTimer > 40) {
                    this.couplerFindTimer = 0;
                    ++this.couplerFindCount;
                }
            } else {
                this.couplerFindFlag = false;
                if (this.frontCartUUID.equals("")) {
                    this.couplerCartFront = null;
                }
                if (this.rearCartUUID.equals("")) {
                    this.couplerCartRear = null;
                }
            }
        }
        UtilPhysics.bufferParameters(this);
        this.updateUnits();
        this.updatePlugins();
        this.updateFrame();
        this.onUpdateTraction();
        this.onUpdateBraking();
        this.onUpdateCoupling();
        if (this.getFrame().isOnTrack() && this.getFrame().isOnSlope() || !this.getFrame().isOnTrack()) {
            UtilPhysics.applyGravitation(this);
        }
        if (this.getFrame().isOnTrack()) {
            this.speed = (float)Math.max(Math.min(this.field_70159_w * (double)this.unitX + this.field_70181_x * (double)this.unitY + this.field_70179_y * (double)this.unitZ, (double)this.speedCap), (double)(-this.speedCap));
            this.setMotionSelf(this.speed);
        }
        if (this.getFrame().isOnTrack()) {
            UtilPhysics.decelerateSimply(this, 0.97f);
        } else {
            UtilPhysics.decelerateSimply(this, 0.75f);
        }
        if (Math.abs(this.speed) < 0.01f) {
            UtilPhysics.decelerateSimply(this, 0.85f);
        }
        if (Math.abs(this.speed) < 0.005f) {
            UtilPhysics.decelerateSimply(this, 0.5f);
        }
        this.bogieRearSpeed = (float)(this.field_70159_w * -Math.sin(Math.toRadians(this.bogieRearAngle)) + this.field_70179_y * Math.cos(Math.toRadians(this.bogieRearAngle)));
        this.bogieFrontSpeed = (float)(this.field_70159_w * -Math.sin(Math.toRadians(this.bogieFrontAngle)) + this.field_70179_y * Math.cos(Math.toRadians(this.bogieFrontAngle)));
        this.func_70072_I();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, false);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70106_y();
        }
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void zeroControls() {
        if (this instanceof IReverseA) {
            ((IReverseA)((Object)this)).setIsReverseZeroed(true);
        }
        if (this instanceof IReverseD3) {
            ((IReverseD3)((Object)this)).setReverse(IReverseD3.EnumReserveP3.NEUTRAL);
        }
        if (this instanceof IRegulatorA) {
            ((IRegulatorA)((Object)this)).setIsRegulatorZeroed(true);
        }
        if (this instanceof IRegulatorD2) {
            ((IRegulatorD2)((Object)this)).setRegulator(IRegulatorD2.EnumRegulatorP2.STOP);
        }
        if (this instanceof IRegulatorD5) {
            ((IRegulatorD5)((Object)this)).setRegulator(IRegulatorD5.EnumRegulatorP5.STOP);
        }
    }

    public void updatePlugins() {
        if (this instanceof IRegulatorA && ((IRegulatorA)((Object)this)).getIsRegulatorZeroed()) {
            IRegulatorA regulator = (IRegulatorA)((Object)this);
            if (regulator.getRegulator() > regulator.getRegulatorMax() / 6) {
                regulator.regulatorGoDown(regulator.getRegulatorMax() / 6);
            } else {
                regulator.setRegulator(0);
                regulator.setIsRegulatorZeroed(false);
            }
        }
        if (this instanceof IReverseA && ((IReverseA)((Object)this)).getIsReverseZeroed()) {
            IReverseA reverse = (IReverseA)((Object)this);
            if (reverse.getReverse() > reverse.getReverseMax() / 10) {
                reverse.reverseGoDown(reverse.getReverseMax() / 10);
            } else if (reverse.getReverse() < -reverse.getReverseMax() / 10) {
                reverse.reverseGoUp(reverse.getReverseMax() / 10);
            } else {
                reverse.setReverse(0);
                reverse.setIsReverseZeroed(false);
            }
        }
        if (this instanceof IWhistle) {
            ((IWhistle)((Object)this)).onUpdateWhistle();
        }
        if (this.field_70170_p.field_72995_K && this instanceof AuxSmoker.I && Config.spawnSmoke) {
            for (AuxSmoker s : ((AuxSmoker.I)((Object)this)).getSmokerList()) {
                s.doSmoke();
            }
        }
    }

    public void onUpdateTraction() {
        if (this instanceof AuxTractor.I) {
            boolean forward = ((AuxTractor.I)((Object)this)).get().getTractorForward();
            float motion = ((AuxTractor.I)((Object)this)).get().getEffortCombined() / this.getMassCompound(forward) * 0.05f;
            this.applyMotionCompound(forward, motion);
        }
    }

    public void onUpdateBraking() {
        if (this instanceof IBrakeScrew) {
            if (((IBrakeScrew)((Object)this)).getBrakeScrewPercentile() > 0.0f) {
                IBrakeScrew brake = (IBrakeScrew)((Object)this);
                if (Math.abs(this.speed) > 1.0E-4f) {
                    float K = brake.getBrakeK() * brake.getBrakeScrewPercentile();
                    float Bt = 1.05f * K * 9.81f;
                    float massCompound = this.getMassCompound(-this.speed > 0.0f);
                    float motion = Bt / massCompound * 0.05f;
                    motion = Math.min(motion, Math.abs(this.speed) - 1.0E-4f);
                    this.applyMotionCompound(-this.speed > 0.0f, motion);
                }
            }
            ((IBrakeScrew)((Object)this)).setBrakeScrewPercentilePrev(((IBrakeScrew)((Object)this)).getBrakeScrewPercentile());
        }
    }

    public void onUpdateCoupling() {
        this.updateBufferCollisions();
        this.updateCouplings();
    }

    public void onUpdatePost() {
        if (Config.skipStockUpdates) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            RoWStock.network.sendToAll((IMessage)new PacketPosition(this, false));
        }
        this.updateWheels();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.updateFrame();
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger.func_184187_bx() != this || !this.func_184196_w(passenger)) continue;
            this.applyPositionToPassenger(passenger, this.getPositionForPassenger(passenger));
        }
    }

    public void handlePortal() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            if (this.field_71087_bX) {
                MinecraftServer minecraftserver = this.field_70170_p.func_73046_m();
                if (minecraftserver.func_71255_r()) {
                    if (!this.func_184218_aH() && this.field_82153_h++ >= this.func_82145_z()) {
                        this.field_82153_h = this.func_82145_z();
                        this.field_71088_bW = this.func_82147_ab();
                        this.func_184204_a(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a() * -1 - 1);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            this.func_184173_H();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public int func_82145_z() {
        return 1;
    }

    public void updateWheels() {
        for (int i = 0; i < this.wheelAngle.length; ++i) {
            int n = i;
            this.wheelAngle[n] = this.wheelAngle[n] + (float)Math.toDegrees(this.speed / this.wheelRadii[i]);
        }
        this.crankRPM = UtilMath.toRevolutions(Float.valueOf(this.speed / this.wheelRadii[0])) * 60.0f / 0.05f;
    }

    public void updateFrame() {
        if (this.field_70173_aa <= 5) {
            if (!this.field_70170_p.field_72995_K) {
                RoWStock.network.sendToAll((IMessage)new PacketPosition(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, true));
            }
            this.updateUnits();
            this.getFrame().setExternally(this);
            this.getFrame().forceRotations(this);
            this.getFrame().onUpdate();
        }
        this.updateUnits();
        this.getFrame().setExternally(this);
        this.getFrame().setRotations(this);
        this.getFrame().onUpdate();
        this.func_70107_b(this.getFrame().jointPos.getX(), this.getFrame().jointPos.getY(), this.getFrame().jointPos.getZ());
        this.field_70177_z = this.getFrame().azimuth;
        this.field_70125_A = this.getFrame().zenith;
        this.bogieFrontAnglePrev = this.bogieFrontAngle;
        this.bogieRearAnglePrev = this.bogieRearAngle;
        this.bogieFrontAngle = this.getFrame().getFrontAzimuth();
        this.bogieRearAngle = this.getFrame().getRearAzimuth();
    }

    public void updateCouplings() {
        float stretch;
        float drawLimit;
        if (this.isCoupledFront() && this.couplerPosFront != null) {
            drawLimit = 3.0f * this.getCouplerFront().getDrawFree();
            stretch = 0.0f;
            if (this.couplerCartFront.isCoupledToRear(this) && this.couplerCartFront.couplerPosRear != null) {
                stretch = this.resolveCoupling(this.couplerPosFront, this.couplerCartFront, this.couplerCartFront.couplerPosRear, this.getCouplerFront(), true);
                this.couplerCartFront.couplerStretchRear = this.couplerStretchFront = (double)stretch;
            } else if (this.couplerCartFront.isCoupledToFront(this) && this.couplerCartFront.couplerPosFront != null) {
                stretch = this.resolveCoupling(this.couplerPosFront, this.couplerCartFront, this.couplerCartFront.couplerPosFront, this.getCouplerFront(), true);
                this.couplerCartFront.couplerStretchFront = this.couplerStretchFront = (double)stretch;
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 20 && stretch > drawLimit && !Config.allowCouplerOverstretch) {
                this.releaseFront();
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HandlerStockSounds.coupler_break, SoundCategory.MASTER, 0.5f, 1.0f);
            }
        }
        if (this.isCoupledRear() && this.couplerPosRear != null) {
            drawLimit = 3.0f * this.getCouplerRear().getDrawFree();
            stretch = 0.0f;
            if (this.couplerCartRear.isCoupledToRear(this) && this.couplerCartRear.couplerPosRear != null) {
                stretch = this.resolveCoupling(this.couplerPosRear, this.couplerCartRear, this.couplerCartRear.couplerPosRear, this.getCouplerRear(), true);
                this.couplerCartRear.couplerStretchRear = this.couplerStretchRear = (double)stretch;
            } else if (this.couplerCartRear.isCoupledToFront(this) && this.couplerCartRear.couplerPosFront != null) {
                stretch = this.resolveCoupling(this.couplerPosRear, this.couplerCartRear, this.couplerCartRear.couplerPosFront, this.getCouplerRear(), true);
                this.couplerCartRear.couplerStretchFront = this.couplerStretchRear = (double)stretch;
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 20 && stretch > drawLimit && !Config.allowCouplerOverstretch) {
                this.releaseRear();
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HandlerStockSounds.coupler_break, SoundCategory.MASTER, 0.5f, 1.0f);
            }
        }
    }

    private float resolveCoupling(RotaVec posA, RollingStock stock, RotaVec posB, EnumCoupler coupler, boolean doDraw) {
        float dYaw = Math.abs(MathHelper.func_76142_g((float)(this.field_70177_z - stock.field_70177_z)));
        float alpha = dYaw < 90.0f ? 180.0f - dYaw : dYaw;
        float current = (float)Math.hypot(this.field_70165_t - stock.field_70165_t, this.field_70161_v - stock.field_70161_v);
        float l1 = Math.abs(posA.getRelZIn());
        float l2 = Math.abs(posB.getRelZIn());
        float ideal = (float)Math.sqrt((double)(l1 * l1 + l2 * l2) - (double)(2.0f * l1 * l2) * Math.cos(Math.toRadians(alpha)));
        float stretch = current - ideal;
        float d = UtilMath.dist(posA, posB);
        stretch = Math.signum(stretch) * d;
        float damper = Math.signum(posA.getRelZIn()) * this.speed + Math.signum(posB.getRelZIn()) * stock.speed;
        float drawFree = coupler.getDrawFree();
        float bufferFree = coupler.getBufferFree();
        if (doDraw && stretch > drawFree) {
            float drawBase = coupler.getDrawRigidity() * (stretch - drawFree);
            float drawDamp = coupler.getDrawDamping() * damper;
            this.applyMotionSelfForward(Math.signum(posA.getRelZIn()) * drawBase - Math.signum(posA.getRelZIn()) * drawDamp);
            stock.applyMotionSelfForward(Math.signum(posB.getRelZIn()) * drawBase - Math.signum(posB.getRelZIn()) * drawDamp);
        } else if (stretch < 0.0f) {
            float bufferBase = stretch * (stretch < -bufferFree ? coupler.getBufferFrameRigidity() : coupler.getBufferRigidity());
            float bufferDamp = damper * (stretch < -bufferFree ? coupler.getBufferFrameDamping() : coupler.getBufferDamping());
            this.applyMotionSelfForward(Math.signum(posA.getRelZIn()) * bufferBase - Math.signum(posA.getRelZIn()) * bufferDamp);
            stock.applyMotionSelfForward(Math.signum(posB.getRelZIn()) * bufferBase - Math.signum(posB.getRelZIn()) * bufferDamp);
        }
        return stretch;
    }

    public void initiateCouplerFind() {
        this.couplerFindFlag = true;
    }

    public void findCoupled() {
        if (!this.frontCartUUID.equals("")) {
            for (RollingStock stock : RoW.getRespectiveStockMap(this.field_70170_p).values()) {
                if (!(stock instanceof RollingStock) || !stock.UUID.equals(this.frontCartUUID)) continue;
                this.couplerCartFront = stock;
                if (stock.frontCartUUID.equals(this.UUID)) {
                    stock.couplerCartFront = this;
                } else if (stock.rearCartUUID.equals(this.UUID)) {
                    stock.couplerCartRear = this;
                }
                break;
            }
        } else {
            this.couplerCartFront = null;
        }
        if (!this.rearCartUUID.equals("")) {
            for (RollingStock stock : RoW.getRespectiveStockMap(this.field_70170_p).values()) {
                if (!(stock instanceof RollingStock) || !stock.UUID.equals(this.rearCartUUID)) continue;
                this.couplerCartRear = stock;
                if (stock.frontCartUUID.equals(this.UUID)) {
                    stock.couplerCartFront = this;
                } else if (stock.rearCartUUID.equals(this.UUID)) {
                    stock.couplerCartRear = this;
                }
                break;
            }
        } else {
            this.couplerCartRear = null;
        }
    }

    public void updateBufferCollisions() {
        if (this.isCoupledRear() && this.isCoupledFront()) {
            return;
        }
        for (Map.Entry<Integer, RollingStock> entry : RoW.getRespectiveStockMap(this.field_70170_p).entrySet()) {
            RollingStock stock = entry.getValue();
            if (stock == null || stock == this || this.isCoupledToFront(stock) || this.isCoupledToRear(stock)) continue;
            this.updateUnits();
            stock.updateUnits();
            float dx = 0.0f;
            float dz = 0.0f;
            float df1 = (float)Math.hypot((double)stock.couplerPosFront.getX() - this.field_70165_t, (double)stock.couplerPosFront.getZ() - this.field_70161_v);
            float dr1 = (float)Math.hypot((double)stock.couplerPosRear.getX() - this.field_70165_t, (double)stock.couplerPosRear.getZ() - this.field_70161_v);
            float df2 = (float)Math.hypot((double)this.couplerPosFront.getX() - stock.field_70165_t, (double)this.couplerPosFront.getZ() - stock.field_70161_v);
            float dr2 = (float)Math.hypot((double)this.couplerPosRear.getX() - stock.field_70165_t, (double)this.couplerPosRear.getZ() - stock.field_70161_v);
            if (df2 < dr2) {
                if (df1 < this.frontCouplerShift) {
                    dx = -this.couplerPosFront.getX() + stock.couplerPosFront.getX();
                    dz = -this.couplerPosFront.getZ() + stock.couplerPosFront.getZ();
                } else if (dr1 < this.frontCouplerShift) {
                    dx = -this.couplerPosFront.getX() + stock.couplerPosRear.getX();
                    dz = -this.couplerPosFront.getZ() + stock.couplerPosRear.getZ();
                }
            } else if (df1 < this.rearCouplerShift) {
                dx = -this.couplerPosRear.getX() + stock.couplerPosFront.getX();
                dz = -this.couplerPosRear.getZ() + stock.couplerPosFront.getZ();
            } else if (dr1 < this.rearCouplerShift) {
                dx = -this.couplerPosRear.getX() + stock.couplerPosRear.getX();
                dz = -this.couplerPosRear.getZ() + stock.couplerPosRear.getZ();
            }
            if (dx == 0.0f && dz == 0.0f || !(Math.hypot(dx, dz) < 2.75)) continue;
            if (this.couplingModeOn && stock.couplingModeOn) {
                this.func_70108_f(stock);
                continue;
            }
            if (df2 < dr2) {
                this.couplerStretchFront = this.resolveCoupling(this.couplerPosFront, stock, df1 < dr1 ? stock.couplerPosFront : stock.couplerPosRear, this.getCouplerFront(), false);
                continue;
            }
            this.couplerStretchRear = this.resolveCoupling(this.couplerPosRear, stock, df1 < dr1 ? stock.couplerPosFront : stock.couplerPosRear, this.getCouplerRear(), false);
        }
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof RollingStock) {
            RollingStock stock = (RollingStock)entity;
            this.field_70144_Y = 0.0f;
            if (this.couplingModeOn) {
                if (stock.couplingModeOn) {
                    boolean canCouple;
                    float dr;
                    if (this.field_70170_p.field_72995_K) {
                        return;
                    }
                    float df = (float)Math.hypot((double)this.couplerPosFront.getX() - stock.field_70165_t, (double)this.couplerPosFront.getZ() - stock.field_70161_v);
                    boolean front1 = df < (dr = (float)Math.hypot((double)this.couplerPosRear.getX() - stock.field_70165_t, (double)this.couplerPosRear.getZ() - stock.field_70161_v));
                    df = (float)Math.hypot(this.field_70165_t - (double)stock.couplerPosFront.getX(), this.field_70161_v - (double)stock.couplerPosFront.getZ());
                    dr = (float)Math.hypot(this.field_70165_t - (double)stock.couplerPosRear.getX(), this.field_70161_v - (double)stock.couplerPosRear.getZ());
                    boolean front2 = df < dr;
                    boolean bl = canCouple = (front1 ? this.getCouplerFront() : this.getCouplerRear()) == (front2 ? stock.getCouplerFront() : stock.getCouplerRear());
                    if (canCouple) {
                        if (front1) {
                            this.couplerCartFront = stock;
                            this.frontCartUUID = stock.UUID;
                        } else {
                            this.couplerCartRear = stock;
                            this.rearCartUUID = stock.UUID;
                        }
                        if (front2) {
                            stock.couplerCartFront = this;
                            stock.frontCartUUID = this.UUID;
                        } else {
                            stock.couplerCartRear = this;
                            stock.rearCartUUID = this.UUID;
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("Coupled!", new Object[0]));
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("Coupler mismatch!", new Object[0]));
                    }
                    this.couplingModeOn = false;
                    stock.couplingModeOn = false;
                    this.sendUpdateToClient();
                    stock.sendUpdateToClient();
                }
            } else {
                super.func_70108_f(entity);
            }
            this.field_70144_Y = 1.0f;
        } else if (entity instanceof EntityPlayer && Config.canPushStock) {
            this.field_70144_Y = 0.95f;
            super.func_70108_f(entity);
            this.field_70144_Y = 1.0f;
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        this.func_70108_f((Entity)player);
    }

    public void setMotionSelf(float v) {
        this.field_70159_w = this.unitX * v;
        this.field_70181_x = this.unitY * v;
        this.field_70179_y = this.unitZ * v;
    }

    public void applyMotionCompound(boolean forward, float motion) {
        if (forward) {
            this.applyMotionDrawnForward(motion);
            this.applyMotionBufferedForward(motion);
            this.applyMotionSelfReverse(motion);
        } else {
            this.applyMotionDrawnReverse(motion);
            this.applyMotionBufferedReverse(motion);
            this.applyMotionSelfForward(motion);
        }
    }

    private void applyMotionSelfForward(float v) {
        this.func_70024_g(this.unitX * v, this.unitY * v, this.unitZ * v);
    }

    private void applyMotionSelfReverse(float v) {
        this.func_70024_g(-this.unitX * v, -this.unitY * v, -this.unitZ * v);
    }

    private void applyMotionBufferedForward(float motion) {
        this.applyMotionSelfForward(motion);
        if (this.isCoupledFront() && this.isBufferedFront()) {
            if (this.couplerCartFront.isCoupledToFront(this)) {
                this.couplerCartFront.applyMotionBufferedReverse(motion);
            } else if (this.couplerCartFront.isCoupledToRear(this)) {
                this.couplerCartFront.applyMotionBufferedForward(motion);
            }
        }
    }

    private void applyMotionBufferedReverse(float motion) {
        this.applyMotionSelfReverse(motion);
        if (this.isCoupledRear() && this.isBufferedRear()) {
            if (this.couplerCartRear.isCoupledToFront(this)) {
                this.couplerCartRear.applyMotionBufferedReverse(motion);
            } else if (this.couplerCartRear.isCoupledToRear(this)) {
                this.couplerCartRear.applyMotionBufferedForward(motion);
            }
        }
    }

    private void applyMotionDrawnForward(float motion) {
        this.applyMotionSelfForward(motion);
        if (this.isCoupledRear() && this.isDrawnRear()) {
            if (this.couplerCartRear.isCoupledToFront(this)) {
                this.couplerCartRear.applyMotionDrawnForward(motion);
            } else if (this.couplerCartRear.isCoupledToRear(this)) {
                this.couplerCartRear.applyMotionDrawnReverse(motion);
            }
        }
    }

    private void applyMotionDrawnReverse(float motion) {
        this.applyMotionSelfReverse(motion);
        if (this.isCoupledFront() && this.isDrawnFront()) {
            if (this.couplerCartFront.isCoupledToFront(this)) {
                this.couplerCartFront.applyMotionDrawnForward(motion);
            } else if (this.couplerCartFront.isCoupledToRear(this)) {
                this.couplerCartFront.applyMotionDrawnReverse(motion);
            }
        }
    }

    public float getMassSelf() {
        return this.massBare;
    }

    public float getMassCompound(boolean forward) {
        return (forward ? this.getMassDrawnRear() + this.getMassBufferedFront() : this.getMassDrawnFront() + this.getMassBufferedRear()) - this.getMassSelf();
    }

    public float getMassDrawnRear() {
        if (this.isCoupledRear() && this.isDrawnRear()) {
            if (this.couplerCartRear.isCoupledToFront(this)) {
                return this.getMassSelf() + this.couplerCartRear.getMassDrawnRear();
            }
            if (this.couplerCartRear.isCoupledToRear(this)) {
                return this.getMassSelf() + this.couplerCartRear.getMassDrawnFront();
            }
        }
        return this.getMassSelf();
    }

    public float getMassDrawnFront() {
        if (this.isCoupledFront() && this.isDrawnFront()) {
            if (this.couplerCartFront.isCoupledToFront(this)) {
                return this.getMassSelf() + this.couplerCartFront.getMassDrawnRear();
            }
            if (this.couplerCartFront.isCoupledToRear(this)) {
                return this.getMassSelf() + this.couplerCartFront.getMassDrawnFront();
            }
        }
        return this.getMassSelf();
    }

    public float getMassBufferedRear() {
        if (this.isBufferedRear()) {
            if (this.couplerCartRear.isCoupledToFront(this)) {
                return this.getMassSelf() + this.couplerCartRear.getMassBufferedRear();
            }
            if (this.couplerCartRear.isCoupledToRear(this)) {
                return this.getMassSelf() + this.couplerCartRear.getMassBufferedFront();
            }
        }
        return this.getMassSelf();
    }

    public float getMassBufferedFront() {
        if (this.isBufferedFront()) {
            if (this.couplerCartFront.isCoupledToFront(this)) {
                return this.getMassSelf() + this.couplerCartFront.getMassBufferedRear();
            }
            if (this.couplerCartFront.isCoupledToRear(this)) {
                return this.getMassSelf() + this.couplerCartFront.getMassBufferedFront();
            }
        }
        return this.getMassSelf();
    }

    private boolean isBufferedRear() {
        return this.isCoupledRear() && this.couplerStretchRear <= 0.0;
    }

    private boolean isBufferedFront() {
        return this.isCoupledFront() && this.couplerStretchFront <= 0.0;
    }

    private boolean isDrawnRear() {
        return this.isCoupledRear() && this.couplerStretchRear >= (double)(this.getCouplerRear().getDrawFree() * 0.89f);
    }

    private boolean isDrawnFront() {
        return this.isCoupledFront() && this.couplerStretchFront >= (double)(this.getCouplerFront().getDrawFree() * 0.89f);
    }

    private boolean isCoupledToRear(RollingStock stock) {
        return stock == this.couplerCartRear;
    }

    private boolean isCoupledToFront(RollingStock stock) {
        return stock == this.couplerCartFront;
    }

    public boolean isCoupledRear() {
        return this.couplerCartRear != null;
    }

    public boolean isCoupledFront() {
        return this.couplerCartFront != null;
    }

    public void updateUnits() {
        this.unitX = (float)(-Math.sin(Math.toRadians(this.field_70177_z)));
        this.unitY = 0.0f;
        this.unitZ = (float)Math.cos(Math.toRadians(this.field_70177_z));
        if (this.getFrame() != null && this.getFrame().isOnSlope()) {
            this.unitX = (float)((double)this.unitX * Math.cos(Math.toRadians(this.field_70125_A)));
            this.unitY = (float)(-Math.sin(Math.toRadians(this.field_70125_A)));
            this.unitZ = (float)((double)this.unitZ * Math.cos(Math.toRadians(this.field_70125_A)));
        }
        if (this.couplerPosRear != null) {
            this.couplerPosRear.onUpdate();
        }
        if (this.couplerPosFront != null) {
            this.couplerPosFront.onUpdate();
        }
        if (this.couplerAxisPosRear != null) {
            this.couplerAxisPosRear.onUpdate();
        }
        if (this.couplerAxisPosFront != null) {
            this.couplerAxisPosFront.onUpdate();
        }
    }

    @Override
    public abstract RollerFrame getFrame();

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void setPositionAndPrev(double x, double y, double z) {
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public float getYawOffset() {
        return 0.0f;
    }

    protected void applyYawToEntity(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float yawMin = this.getYawOffset() - 105.0f;
        float yawMax = this.getYawOffset() + 105.0f;
        float deltaYaw = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z));
        float clampedYaw = MathHelper.func_76131_a((float)deltaYaw, (float)yawMin, (float)yawMax);
        entity.field_70126_B += clampedYaw - deltaYaw;
        entity.field_70177_z += clampedYaw - deltaYaw;
        entity.func_70034_d(entity.func_70079_am() + this.getYawOffset());
        entity.func_181013_g(this.field_70177_z + this.getYawOffset());
        entity.func_70034_d(entity.func_70079_am() + this.getYawOffset());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity e) {
    }

    public void applyPositionToPassenger(Entity passenger, RotaVec point) {
        if (point != null && passenger.func_184187_bx() == this && this.func_184196_w(passenger)) {
            point.onUpdate();
            passenger.func_70080_a((double)point.getX(), (double)point.getY(), (double)point.getZ(), passenger.field_70177_z, passenger.field_70125_A);
            float deltaRotation = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B));
            passenger.field_70177_z += deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + deltaRotation);
            passenger.field_70159_w = this.field_70159_w;
            passenger.field_70181_x = this.field_70181_x;
            passenger.field_70179_y = this.field_70179_y;
        }
    }

    public abstract RotaVec getPositionForPassenger(Entity var1);

    public abstract RotaVec getDismountPosition(Entity var1);

    public void func_184232_k(Entity passenger) {
        if (passenger.func_184187_bx() == this && this.func_184196_w(passenger)) {
            this.applyPositionToPassenger(passenger, this.getPositionForPassenger(passenger));
        }
    }

    public void func_184225_p(Entity passenger) {
        if (passenger.func_184187_bx() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        for (Map.Entry<Integer, Entity> entry : this.passengers.entrySet()) {
            if (entry.getValue() != passenger) continue;
            this.passengers.remove(entry.getKey());
        }
    }

    public void func_184226_ay() {
        for (Map.Entry<Integer, Entity> entry : this.passengers.entrySet()) {
            entry.getValue().func_184210_p();
        }
    }

    protected void addPassenger(int index, Entity passenger) {
        if (passenger.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        this.passengers.put(index, passenger);
    }

    protected void func_184200_o(Entity passenger) {
        if (passenger.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        this.passengers.put(0, passenger);
    }

    public List<Entity> func_184188_bt() {
        return this.passengers.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.passengers.values());
    }

    public int getMaxPassengerIndex() {
        return 0;
    }

    public boolean canControl(Entity entity) {
        return this.passengers.get(0) == entity;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void sendUpdateToClient() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189511_e(nbttagcompound);
        RoWStock.network.sendToAll((IMessage)new PacketNBT(this.func_145782_y(), nbttagcompound));
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.UUID = tag.func_74779_i("UUID");
        this.rearCartUUID = tag.func_74779_i("rearCartUUID");
        this.frontCartUUID = tag.func_74779_i("frontCartUUID");
        this.couplingModeOn = tag.func_74767_n("couplingModeOn");
        this.initiateCouplerFind();
        if (this instanceof IReverseD3) {
            ((IReverseD3)((Object)this)).setReverse(IReverseD3.EnumReserveP3.values()[tag.func_74771_c("reverse")]);
        }
        if (this instanceof IRegulatorD5) {
            ((IRegulatorD5)((Object)this)).setRegulator(IRegulatorD5.EnumRegulatorP5.values()[tag.func_74771_c("regulator5")]);
        }
        if (this instanceof IRegulatorD2) {
            ((IRegulatorD2)((Object)this)).setRegulator(IRegulatorD2.EnumRegulatorP2.values()[tag.func_74771_c("regulator2")]);
        }
        if (this instanceof IRegulatorA) {
            ((IRegulatorA)((Object)this)).setRegulator(tag.func_74762_e("regulatorA"));
            ((IRegulatorA)((Object)this)).setIsRegulatorZeroed(tag.func_74767_n("regulatorA_isZeroed"));
        }
        if (this instanceof IReverseA) {
            ((IReverseA)((Object)this)).setReverse(tag.func_74762_e("reverseA"));
            ((IReverseA)((Object)this)).setIsReverseZeroed(tag.func_74767_n("reverseA_isZeroed"));
        }
        if (this instanceof IBrakeScrew) {
            ((IBrakeScrew)((Object)this)).setBrakeScrewPercentile(tag.func_74760_g("brakeScrew"));
            ((IBrakeScrew)((Object)this)).setBrakeScrewPercentilePrev(tag.func_74760_g("brakeScrew"));
        }
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound pass = tag.func_74775_l("passengers");
            int passCount = tag.func_74762_e("passCount");
            this.passengers = new HashMap<Integer, Entity>();
            if (passCount > 0) {
                for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                    for (int j = 0; j <= this.getMaxPassengerIndex(); ++j) {
                        if (!String.valueOf(entity.func_110124_au()).equals(pass.func_74779_i("_" + j))) continue;
                        entity.func_184210_p();
                        this.passengers.put(j, entity);
                    }
                }
            }
        }
        this.getFrame().forceRotations(this);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("UUID", this.UUID);
        tag.func_74778_a("rearCartUUID", this.rearCartUUID);
        tag.func_74778_a("frontCartUUID", this.frontCartUUID);
        tag.func_74757_a("couplingModeOn", this.couplingModeOn);
        if (this instanceof IReverseD3) {
            tag.func_74774_a("reverse", (byte)((IReverseD3)((Object)this)).getReverse().ordinal());
        }
        if (this instanceof IRegulatorD5) {
            tag.func_74774_a("regulator5", (byte)((IRegulatorD5)((Object)this)).getRegulator().ordinal());
        }
        if (this instanceof IRegulatorD2) {
            tag.func_74774_a("regulator2", (byte)((IRegulatorD2)((Object)this)).getRegulator().ordinal());
        }
        if (this instanceof IRegulatorA) {
            tag.func_74768_a("regulatorA", ((IRegulatorA)((Object)this)).getRegulator());
            tag.func_74757_a("regulatorA_isZeroed", ((IRegulatorA)((Object)this)).getIsRegulatorZeroed());
        }
        if (this instanceof IReverseA) {
            tag.func_74768_a("reverseA", ((IReverseA)((Object)this)).getReverse());
            tag.func_74757_a("reverseA_isZeroed", ((IReverseA)((Object)this)).getIsReverseZeroed());
        }
        if (this instanceof IBrakeScrew) {
            tag.func_74776_a("brakeScrew", ((IBrakeScrew)((Object)this)).getBrakeScrewPercentile());
        }
        NBTTagCompound pass = new NBTTagCompound();
        for (Map.Entry<Integer, Entity> entry : this.passengers.entrySet()) {
            pass.func_74778_a("_" + entry.getKey(), String.valueOf(entry.getValue().func_110124_au()));
        }
        tag.func_74782_a("passengers", (NBTBase)pass);
        tag.func_74768_a("passCount", pass.func_186856_d());
    }

    public void release() {
        this.releaseFront();
        this.releaseRear();
    }

    public void releaseFront() {
        if (this.isCoupledFront()) {
            if (this.couplerCartFront.isCoupledToFront(this)) {
                this.couplerCartFront.frontCartUUID = "";
                this.couplerCartFront.couplerCartFront = null;
            } else if (this.couplerCartFront.isCoupledToRear(this)) {
                this.couplerCartFront.rearCartUUID = "";
                this.couplerCartFront.couplerCartRear = null;
            }
            this.couplerCartFront.sendUpdateToClient();
        }
        this.frontCartUUID = "";
        this.couplerCartFront = null;
        this.sendUpdateToClient();
    }

    public void releaseRear() {
        if (this.isCoupledRear()) {
            if (this.couplerCartRear.couplerCartFront == this) {
                this.couplerCartRear.frontCartUUID = "";
                this.couplerCartRear.couplerCartFront = null;
            } else if (this.couplerCartRear.couplerCartRear == this) {
                this.couplerCartRear.rearCartUUID = "";
                this.couplerCartRear.couplerCartRear = null;
            }
            this.couplerCartRear.sendUpdateToClient();
        }
        this.rearCartUUID = "";
        this.couplerCartRear = null;
        this.sendUpdateToClient();
    }

    public void func_70106_y() {
        this.release();
        this.field_70128_L = true;
        RoW.getRespectiveStockMap(this.field_70170_p).put(this.mapId, null);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g((double)Math.max(this.frontCouplerShift, this.rearCouplerShift));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * RollingStock.func_184183_bd() * 5.0) * d0;
    }

    public void spawnParticle(EnumParticleTypes type, RotaVec point) {
        this.field_70170_p.func_175688_a(type, (double)point.getX(), (double)point.getY(), (double)point.getZ(), this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
    }
}

