/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.auxiliary;

import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.particle.ParticleSmoke;

@SideOnly(value=Side.CLIENT)
public class AuxSmoker {
    private Entity carrier;
    private RotaVec exhaustPos;
    private RotaVec exhaustDir;
    private int intensity;
    private float heightRange;
    private float chance;
    private float forceMedian;
    private float forceRange;
    private float forceJetChance;
    private float forceJetMedian;
    private float forceJetRange;
    private float drag;
    private float scale;
    private SmokerMaxAge maxAge;
    private SmokerAgingRate agingRate;

    public AuxSmoker(Entity carrier, RotaVec exhaustPos, RotaVec exhaustDir, int intensity, float heightRange, float chance, float forceMedian, float forceRange, float forceJetChance, float forceJetMedian, float forceJetRange, float drag, float scale, SmokerMaxAge maxAge, SmokerAgingRate agingRate) {
        this.carrier = carrier;
        this.exhaustPos = exhaustPos;
        this.exhaustDir = exhaustDir;
        this.intensity = intensity;
        this.heightRange = heightRange;
        this.chance = chance;
        this.forceMedian = forceMedian;
        this.forceRange = forceRange;
        this.forceJetChance = forceJetChance;
        this.forceJetMedian = forceJetMedian;
        this.forceJetRange = forceJetRange;
        this.drag = drag;
        this.scale = scale;
        this.maxAge = maxAge;
        this.agingRate = agingRate;
    }

    public void doSmoke() {
        this.exhaustPos.onUpdate();
        this.exhaustDir.onUpdate();
        for (int i = 0; i < this.intensity; ++i) {
            if (!(Math.random() < (double)this.chance)) continue;
            float force = this.forceMedian + (float)Math.random() * this.forceRange + (Math.random() < (double)this.forceJetChance ? this.forceJetMedian + (float)Math.random() * this.forceJetRange : 0.0f);
            ParticleSmoke fx = new ParticleSmoke(this.carrier.field_70170_p, this.exhaustPos.getX(), (double)this.exhaustPos.getY() + Math.random() * (double)this.heightRange, this.exhaustPos.getZ(), (double)(1.0f - this.drag) * this.carrier.field_70159_w + (double)(this.exhaustDir.getRelXOut() * force), (double)(1.0f - this.drag) * this.carrier.field_70181_x + (double)(this.exhaustDir.getRelYOut() * force), (double)(1.0f - this.drag) * this.carrier.field_70179_y + (double)(this.exhaustDir.getRelZOut() * force), this.scale, this.maxAge.get(force), this.agingRate.get(force));
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    public static interface I {
        public List<AuxSmoker> getSmokerList();
    }

    public static interface SmokerAgingRate {
        public float get(float var1);
    }

    public static interface SmokerMaxAge {
        public int get(float var1);
    }
}

