/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.auxiliary;

import net.railsofwar.row.stock.core.RollingStock;

public class AuxTractor<T extends RollingStock> {
    private T carrier;
    private float speedRelease;
    private float effortMax;
    private float effortFactor;
    private TractorForward<T> forward;
    private TractorCombinedEffort<T> combinedEffort;

    public AuxTractor(T carrier, float effortMax, float speedRelease, float effortFactor, TractorForward<T> forward, TractorCombinedEffort<T> combinedEffort) {
        this.carrier = carrier;
        this.speedRelease = speedRelease;
        this.effortMax = effortMax;
        this.effortFactor = effortFactor;
        this.forward = forward;
        this.combinedEffort = combinedEffort;
    }

    public float getEffortBySpeed() {
        if (Math.abs(((RollingStock)this.carrier).speed) < this.speedRelease) {
            return this.effortMax;
        }
        return Math.max(0.0f, this.effortMax - this.effortFactor * (float)((double)Math.abs(((RollingStock)this.carrier).speed) - Math.sqrt(this.speedRelease)));
    }

    public boolean getTractorForward() {
        return this.forward.get(this.carrier);
    }

    public float getEffortCombined() {
        return this.combinedEffort.get(this.carrier, this.getEffortBySpeed());
    }

    public static interface I {
        public AuxTractor get();
    }

    public static interface TractorCombinedEffort<T extends RollingStock> {
        public float get(T var1, float var2);
    }

    public static interface TractorForward<T extends RollingStock> {
        public boolean get(T var1);
    }
}

