/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.plugin;

public interface IBrakeScrew {
    public float getBrakeScrewPercentile();

    public void setBrakeScrewPercentile(float var1);

    public float getBrakeScrewPercentilePrev();

    public void setBrakeScrewPercentilePrev(float var1);

    public float getBrakeScrewIncrement();

    public float getBrakeScrewFreeStroke();

    public float getBrakeScrewRevolutions();

    public float getBrakeScrewStroke();

    default public float getBrakeScrewPercentilePartial(float partial) {
        return this.getBrakeScrewPercentilePrev() + (this.getBrakeScrewPercentile() - this.getBrakeScrewPercentilePrev()) * partial;
    }

    default public float getBrakeDelta() {
        return 0.55f;
    }

    default public float getBrakeK() {
        return 2.0f;
    }

    default public void onBrakeScrewInput(boolean apply, boolean release) {
        float f = this.getBrakeScrewPercentile();
        this.setBrakeScrewPercentilePrev(f);
        if (apply && !release) {
            if (f < 1.0f) {
                this.setBrakeScrewPercentile(Math.min(f + this.getBrakeScrewIncrement(), 1.0f));
            }
        } else if (!apply && release && f > 0.0f) {
            this.setBrakeScrewPercentile(Math.max(f - this.getBrakeScrewIncrement(), 0.0f));
        }
    }
}

