/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.plugin;

import net.railsofwar.row.common.math.rota.IRotaAngles;

public interface IReverseA
extends IRotaAngles {
    public int getReverseMax();

    public int getReverse();

    public void setReverse(int var1);

    public boolean getIsReverseZeroed();

    public void setIsReverseZeroed(boolean var1);

    default public boolean canReverseGoUp() {
        return this.getReverse() < this.getReverseMax();
    }

    default public boolean canReverseGoDown() {
        return this.getReverse() > -this.getReverseMax();
    }

    default public void reverseGoUp(int dr) {
        if (this.getReverse() + dr < this.getReverseMax()) {
            this.setReverse(this.getReverse() + dr);
        } else {
            this.setReverse(this.getReverseMax());
        }
    }

    default public void reverseGoDown(int dr) {
        if (this.getReverse() - dr > -this.getReverseMax()) {
            this.setReverse(this.getReverse() - dr);
        } else {
            this.setReverse(-this.getReverseMax());
        }
    }

    default public float getReverseMult() {
        return (float)this.getReverse() * 1.0f / (float)this.getReverseMax();
    }

    default public float getReverseMultAbs() {
        return Math.abs(this.getReverseMult());
    }

    @Override
    default public float getRotaAzimuth() {
        return 0.0f;
    }

    @Override
    default public float getRotaZenith() {
        return this.getReverseMult();
    }
}

