/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.IRotaAngles;
import net.railsofwar.row.common.math.rota.IRotaOrigin;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.block.BlockTrackGag;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailContact;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.tileentity.TileTurntable;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class RollerAxle
implements IRotaOrigin,
IRotaAngles {
    public World world;
    public float posX;
    public float posY;
    public float posZ;
    public float azimuth;
    public float zenith;
    public float posXPrev;
    public float posYPrev;
    public float posZPrev;
    public float azimuthPrev;
    public float zenithPrev;
    public final float radius;
    public final float flangeRadius;
    private BlockPos pos;
    private BlockPos posPrev;
    private EnumTrackShape shape = EnumTrackShape.STRAIGHT;
    private EnumRailway railway = EnumRailway.RW750STAGGERED;
    private int scalarA = 8;
    private int scalarB = 0;
    private boolean mirrored = false;
    private EnumDirectionSWNE direction = EnumDirectionSWNE.SOUTH;
    private boolean isOnMainline = false;
    private boolean wasOverBlades = false;
    private boolean isOnTrack = false;
    private boolean directlyOnTrack = false;

    public RollerAxle(World world, float posX, float posY, float posZ, float radius, float flangeRadius, float azimuth, float zenith) {
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.azimuth = azimuth;
        this.zenith = zenith;
        this.posXPrev = posX;
        this.posYPrev = posY;
        this.posZPrev = posZ;
        this.azimuthPrev = azimuth;
        this.zenithPrev = zenith;
        this.zenith = zenith;
        this.radius = radius;
        this.flangeRadius = flangeRadius;
    }

    public RollerAxle(World world, RotaVec pos, float radius, float flangeRadius, float azimuth, float zenith) {
        this(world, pos.getX(), pos.getY(), pos.getZ(), radius, flangeRadius, azimuth, zenith);
    }

    public void onUpdate() {
        BlockPos b = new BlockPos((double)this.posX, (double)this.posY, (double)this.posZ);
        this.directlyOnTrack = true;
        if (this.world.func_180495_p(b).func_177230_c() instanceof BlockAir || this.world.func_180495_p(b).func_177230_c() instanceof BlockLiquid) {
            this.directlyOnTrack = false;
            while (b.func_177956_o() > 0 && !(this.world.func_180495_p(b = new BlockPos(b.func_177958_n(), b.func_177956_o() - 1, b.func_177952_p())).func_177230_c() instanceof BlockTrackBase) && !(this.world.func_180495_p(b).func_177230_c() instanceof BlockTrackGag)) {
            }
        }
        if (!(this.world.func_180495_p(b).func_177230_c() instanceof BlockTrackBase) && !(this.world.func_180495_p(b).func_177230_c() instanceof BlockTrackGag)) {
            b = new BlockPos((double)this.posX, (double)this.posY, (double)this.posZ);
        }
        if (this.world.func_180495_p(b).func_177230_c() instanceof BlockTrackBase || this.world.func_180495_p(b).func_177230_c() instanceof BlockTrackGag) {
            this.posPrev = this.pos;
            this.pos = b;
            boolean isStale = this.posX == this.posXPrev && this.posY == this.posYPrev && this.posZ == this.posZPrev;
            Triple<Vector3f, Pair<Float, Float>, Boolean> triple = this.castToTrack(new Vector3f(this.posX, this.posY, this.posZ), this.azimuth, this.zenith, this.pos, this.posPrev, this.isOnMainline, isStale);
            this.setPosition((Vector3f)triple.getLeft());
            float angle = ((Float)((Pair)triple.getMiddle()).getLeft()).floatValue();
            float deltaAngle = MathHelper.func_76142_g((float)(angle - this.azimuth));
            this.azimuth = Math.abs(deltaAngle) > 90.0f ? MathHelper.func_76142_g((float)(angle - 180.0f)) : angle;
            this.zenith = ((Float)((Pair)triple.getMiddle()).getRight()).floatValue();
            this.isOnMainline = (Boolean)triple.getRight();
            this.isOnTrack = true;
        } else {
            this.isOnTrack = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Triple<Vector3f, Pair<Float, Float>, Boolean> castToTrack(Vector3f pos, float az, float zn, BlockPos trackPos, BlockPos prevPos, boolean mainline, boolean stale) {
        TileTrackSWNE track;
        boolean forceInit;
        if (trackPos == null) {
            return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
        }
        boolean bl = forceInit = prevPos == null;
        if (this.world.func_180495_p(trackPos).func_177230_c() instanceof BlockTrackGag) {
            if (RoWTracks.getTrackManager(this.world).getPieceID(trackPos) == -1) {
                return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
            }
            BlockPos origin = RoWTracks.getTrackManager(this.world).getPieceOrigin(trackPos);
            if (!(this.world.func_180495_p(origin).func_177230_c() instanceof BlockTrackBase)) return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
            trackPos = origin;
        }
        if (prevPos != null && this.world.func_180495_p(prevPos).func_177230_c() instanceof BlockTrackGag) {
            if (RoWTracks.getTrackManager(this.world).getPieceID(prevPos) == -1) {
                return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
            }
            BlockPos origin2 = RoWTracks.getTrackManager(this.world).getPieceOrigin(prevPos);
            if (!(this.world.func_180495_p(origin2).func_177230_c() instanceof BlockTrackBase)) return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
            prevPos = origin2;
        }
        if ((track = (TileTrackSWNE)this.world.func_175625_s(trackPos)) == null) return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
        if (track.shape != null) {
            this.shape = track.shape;
        }
        if (track.railway != null) {
            this.railway = track.railway;
        }
        this.scalarA = track.scalarA;
        this.scalarB = track.scalarB;
        this.mirrored = track.mirrored;
        this.direction = track.direction;
        if (this.shape == EnumTrackShape.STRAIGHT) {
            return this.castPointStraight(pos, trackPos, false);
        }
        if (this.shape == EnumTrackShape.DIAGONAL) {
            return this.castPointDiagonal(pos, trackPos, false);
        }
        if (this.shape == EnumTrackShape.CIRCULAR) {
            return this.castPointCircular(pos, trackPos, this.scalarB, this.mirrored);
        }
        if (this.shape == EnumTrackShape.SLOPE_STRAIGHT) {
            return this.castPointSlopeStraight(pos, trackPos);
        }
        if (this.shape == EnumTrackShape.SWITCH_CIRCULAR) {
            boolean overBlade;
            EnumRailway railway = UtilTrackGeometry.getRailway(this.world, trackPos);
            float radian = EnumDiagonal.byOrdinal(4).getRadian();
            float bladeHeight = UtilTrackGeometry.getSwitchPointerHeight(railway, (float)this.scalarA + 0.5f, radian) + 0.0625f;
            float[] d = new float[]{pos.x - ((float)trackPos.func_177958_n() + 0.5f), pos.z - ((float)trackPos.func_177952_p() + 0.5f)};
            d = RotationHelper.rotateByDir(d[0], d[1], this.direction);
            float height = d[1] + 0.5f;
            if (this.direction == EnumDirectionSWNE.EAST || this.direction == EnumDirectionSWNE.WEST) {
                height = -d[1] + 0.5f;
            }
            boolean bl2 = overBlade = height > bladeHeight;
            if (!trackPos.equals((Object)prevPos)) {
                Triple<Vector3f, Pair<Float, Float>, Boolean> triple;
                Vector3f v;
                float dc;
                this.wasOverBlades = overBlade;
                if (!overBlade) return this.castPointStraight(pos, trackPos, false);
                float ds = Math.abs(pos.z - ((float)trackPos.func_177952_p() + 0.5f));
                if (this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH) {
                    ds = Math.abs(pos.x - ((float)trackPos.func_177958_n() + 0.5f));
                }
                if (!(ds <= (dc = (float)Math.sqrt(((v = (Vector3f)(triple = this.castPointCircular(pos, trackPos, this.scalarB, this.mirrored)).getLeft()).getX() - pos.x) * (v.getX() - pos.x) + (v.getZ() - pos.z) * (v.getZ() - pos.z))))) return Triple.of((Object)triple.getLeft(), (Object)triple.getMiddle(), (Object)false);
                return this.castPointStraight(pos, trackPos, false);
            }
            if (this.wasOverBlades != overBlade && overBlade) {
                mainline = track.activated ^ track.mirrored;
            } else if (this.wasOverBlades != overBlade && !overBlade) {
                track.activated = !mainline ^ !track.mirrored;
                track.fast = true;
            }
            this.wasOverBlades = overBlade;
            if (!mainline) return this.castPointCircular(pos, trackPos, this.scalarB, this.mirrored);
            return this.castPointStraight(pos, trackPos, false);
        }
        if (this.shape == EnumTrackShape.SWITCH_WYE) {
            boolean overBlade;
            EnumRailway railway = UtilTrackGeometry.getRailway(this.world, trackPos);
            float bladeHeight = UtilTrackGeometry.getSwitchPointerHeight(railway, (float)this.scalarA + 0.5f, UtilTrackGeometry.ANGLE45) + 0.0625f;
            float[] d = new float[]{pos.x - ((float)trackPos.func_177958_n() + 0.5f), pos.z - ((float)trackPos.func_177952_p() + 0.5f)};
            d = RotationHelper.rotateByDir(d[0], d[1], this.direction);
            float height = d[1] + 0.5f;
            float width = d[0] + 0.5f;
            if (this.direction == EnumDirectionSWNE.EAST || this.direction == EnumDirectionSWNE.WEST) {
                height = -d[1] + 0.5f;
                width = -d[0] + 0.5f;
            }
            boolean bl3 = overBlade = height > bladeHeight;
            if (!trackPos.equals((Object)prevPos)) {
                this.wasOverBlades = overBlade;
                if (!overBlade) return this.castPointStraight(pos, trackPos, false);
                mainline = width > 0.0f;
            } else {
                if (this.wasOverBlades != overBlade && overBlade) {
                    mainline = track.activated;
                } else if (this.wasOverBlades != overBlade && !overBlade) {
                    track.activated = mainline;
                    track.fast = true;
                }
                this.wasOverBlades = overBlade;
                if (!overBlade) {
                    return this.castPointStraight(pos, trackPos, false);
                }
            }
            Triple<Vector3f, Pair<Float, Float>, Boolean> triple = this.castPointCircular(pos, trackPos, 4, mainline);
            return Triple.of((Object)triple.getLeft(), (Object)triple.getMiddle(), (Object)mainline);
        }
        if (this.shape == EnumTrackShape.DIAMOND_STRAIGHT) {
            if (prevPos == null) {
                EnumDirectionSWNE axleDir = EnumDirectionSWNE.fromAngle(az);
                mainline = axleDir == this.direction || axleDir == this.direction.getOpposite();
                return this.castPointStraight(pos, trackPos, !mainline);
            } else {
                if (trackPos.equals((Object)prevPos)) return this.castPointStraight(pos, trackPos, !mainline);
                float d1 = Math.abs(pos.z - ((float)trackPos.func_177952_p() + 0.5f));
                float d2 = Math.abs(pos.x - ((float)trackPos.func_177958_n() + 0.5f));
                mainline = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? d2 < d1 : d2 > d1;
            }
            return this.castPointStraight(pos, trackPos, !mainline);
        }
        if (this.shape == EnumTrackShape.DIAMOND_DIAGONAL) {
            if (prevPos == null) {
                EnumDirectionSWNE axleDir = EnumDirectionSWNE.fromAngle(az - 45.0f);
                mainline = axleDir == this.direction || axleDir == this.direction.getOpposite();
                return this.castPointDiagonal(pos, trackPos, !mainline);
            } else {
                if (trackPos.equals((Object)prevPos)) return this.castPointDiagonal(pos, trackPos, !mainline);
                float dx = pos.x - ((float)trackPos.func_177958_n() + 0.5f);
                float dz = pos.z - ((float)trackPos.func_177952_p() + 0.5f);
                mainline = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? dx * dz < 0.0f : dx * dz > 0.0f;
            }
            return this.castPointDiagonal(pos, trackPos, !mainline);
        }
        if (this.shape == EnumTrackShape.DIAMOND_SHARP) {
            if (prevPos == null) {
                EnumDirectionSWNE axleDir = EnumDirectionSWNE.fromAngle(az);
                mainline = axleDir == this.direction || axleDir == this.direction.getOpposite();
            } else if (!trackPos.equals((Object)prevPos)) {
                float dz;
                float dx = pos.x - ((float)trackPos.func_177958_n() + 0.5f);
                float d = Math.abs(dx / (dz = pos.z - ((float)trackPos.func_177952_p() + 0.5f)));
                boolean bl4 = mainline = d < 0.5f || d > 1.5f;
            }
            if (mainline) {
                return this.castPointStraight(pos, trackPos, false);
            }
            Triple<Vector3f, Pair<Float, Float>, Boolean> triple = this.castPointDiagonal(pos, trackPos, this.mirrored);
            return Triple.of((Object)triple.getLeft(), (Object)triple.getMiddle(), (Object)false);
        }
        if (this.shape != EnumTrackShape.TURNTABLE) return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
        TileTurntable turntable = (TileTurntable)this.world.func_175625_s(trackPos);
        if (turntable == null || trackPos.equals((Object)prevPos)) return this.castPointTurntable(pos, trackPos, turntable.azimuth, mainline, turntable.cooldown == 0);
        if (turntable.cooldown > 0) {
            this.isOnTrack = false;
            return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(az), (Object)Float.valueOf(zn)), (Object)mainline);
        }
        float da = MathHelper.func_76142_g((float)(turntable.azimuth - az));
        mainline = Math.abs(da) < 45.0f || Math.abs(da) > 135.0f;
        return this.castPointTurntable(pos, trackPos, turntable.azimuth, mainline, turntable.cooldown == 0);
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointSlopeStraight(Vector3f pos, BlockPos trackPos) {
        boolean upward;
        float radius = UtilTrackGeometry.getSlopeRadius((float)this.scalarA / 2.0f, (float)this.scalarB / 2.0f);
        float[] d = new float[]{pos.x - ((float)trackPos.func_177958_n() + 0.5f), pos.z - ((float)trackPos.func_177952_p() + 0.5f)};
        d = RotationHelper.rotateByDir(d[0], d[1], this.direction);
        float forward = d[1] + 0.5f;
        if (this.direction == EnumDirectionSWNE.EAST || this.direction == EnumDirectionSWNE.WEST) {
            forward = -d[1] + 0.5f;
        }
        boolean bl = upward = forward <= (float)this.scalarA / 2.0f;
        if (upward) {
            Triple<Vector3f, Pair<Float, Float>, Boolean> triple = this.castPointSlopeStraightUpward(pos, trackPos);
            if (((Vector3f)triple.getLeft()).getY() > (float)trackPos.func_177956_o() + this.railway.getTopOfRail() + radius) {
                return this.castPointSlopeStraightDownward(pos, trackPos);
            }
            return triple;
        }
        Triple<Vector3f, Pair<Float, Float>, Boolean> triple = this.castPointSlopeStraightDownward(pos, trackPos);
        if (((Vector3f)triple.getLeft()).getY() < (float)trackPos.func_177956_o() + this.railway.getTopOfRail() + (float)this.scalarB - radius) {
            return this.castPointSlopeStraightUpward(pos, trackPos);
        }
        return triple;
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointSlopeStraightUpward(Vector3f pos, BlockPos trackPos) {
        float radius = UtilTrackGeometry.getSlopeRadius((float)this.scalarA / 2.0f, (float)this.scalarB / 2.0f);
        Vector3f centre = new Vector3f(0.0f, this.railway.getTopOfRail() + radius, -0.5f);
        centre = RotationHelper.rotateByDir(centre, this.direction);
        centre.add((Tuple3f)new Vector3f((float)trackPos.func_177958_n() + 0.5f, (float)trackPos.func_177956_o(), (float)trackPos.func_177952_p() + 0.5f));
        if (this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH) {
            pos.setX((float)trackPos.func_177958_n() + 0.5f);
        } else {
            pos.setZ((float)trackPos.func_177952_p() + 0.5f);
        }
        pos.sub((Tuple3f)centre);
        float dist = pos.length();
        pos.scale(Math.abs(radius - this.getWorkingRadius()) / dist);
        pos.add((Tuple3f)centre);
        float yaw = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? 0.0f : 90.0f;
        return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(0.0f)), (Object)true);
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointSlopeStraightDownward(Vector3f pos, BlockPos trackPos) {
        float radius = UtilTrackGeometry.getSlopeRadius((float)this.scalarA / 2.0f, (float)this.scalarB / 2.0f);
        Vector3f centre = new Vector3f(0.0f, (float)this.scalarB + this.railway.getTopOfRail() - radius, (float)this.scalarA - 0.5f);
        centre = RotationHelper.rotateByDir(centre, this.direction);
        centre.add((Tuple3f)new Vector3f((float)trackPos.func_177958_n() + 0.5f, (float)trackPos.func_177956_o(), (float)trackPos.func_177952_p() + 0.5f));
        if (this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH) {
            pos.setX((float)trackPos.func_177958_n() + 0.5f);
        } else {
            pos.setZ((float)trackPos.func_177952_p() + 0.5f);
        }
        pos.sub((Tuple3f)centre);
        float dist = pos.length();
        pos.scale(Math.abs(radius + this.getWorkingRadius()) / dist);
        pos.add((Tuple3f)centre);
        float yaw = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? 0.0f : 90.0f;
        return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(0.0f)), (Object)true);
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointCircular(Vector3f pos, BlockPos trackPos, int base, boolean mirrored) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float radius = UtilTrackGeometry.getCircularRadius((float)this.scalarA + 0.5f, radian) * (mirrored ? -1.0f : 1.0f);
        float gap = UtilTrackGeometry.getCircularGap((float)this.scalarA + 0.5f, radian);
        float[] d = new float[]{pos.x - ((float)trackPos.func_177958_n() + 0.5f), pos.z - ((float)trackPos.func_177952_p() + 0.5f)};
        d = RotationHelper.rotateByDir(d[0], d[1], this.direction);
        float height = d[1] + 0.5f;
        if (this.direction == EnumDirectionSWNE.EAST || this.direction == EnumDirectionSWNE.WEST) {
            height = -d[1] + 0.5f;
        }
        if (height <= gap) {
            return this.castPointStraight(pos, trackPos, false);
        }
        float[] rot = RotationHelper.rotateByDir(-radius, -0.5f + gap, this.direction);
        Vector3f centre = new Vector3f((float)trackPos.func_177958_n() + 0.5f + rot[0], (float)trackPos.func_177956_o(), (float)trackPos.func_177952_p() + 0.5f + rot[1]);
        Vector3f loc = new Vector3f(pos.x, pos.y, pos.z);
        loc.sub((Tuple3f)centre);
        float yaw = (float)Math.toDegrees(Math.atan2(loc.getZ(), loc.getX()));
        float dist = (float)Math.sqrt(loc.getX() * loc.getX() + loc.getZ() * loc.getZ());
        loc.scale(Math.abs(radius) / dist);
        loc.add((Tuple3f)centre);
        loc.setY((float)trackPos.func_177956_o() + this.railway.getTopOfRail() + this.getWorkingRadius());
        return Triple.of((Object)loc, (Object)Pair.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(0.0f)), (Object)false);
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointDiagonal(Vector3f pos, BlockPos trackPos, boolean trans) {
        if (trans) {
            this.direction = this.direction.getCW();
        }
        float k1 = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? -1.0f : 1.0f;
        float k2 = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? 1.0f : -1.0f;
        float yaw = this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH ? 45.0f : -45.0f;
        float b1 = (float)trackPos.func_177952_p() + 0.5f - ((float)trackPos.func_177958_n() + 0.5f) * k1;
        float b2 = pos.z - pos.x * k2;
        float x = (b1 - b2) / (k2 - k1);
        return Triple.of((Object)new Vector3f(x, (float)trackPos.func_177956_o() + this.railway.getTopOfRail() + this.getWorkingRadius(), k2 * x + b2), (Object)Pair.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(0.0f)), (Object)(!trans ? 1 : 0));
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointStraight(Vector3f pos, BlockPos trackPos, boolean trans) {
        pos.setY((float)trackPos.func_177956_o() + this.railway.getTopOfRail() + this.getWorkingRadius());
        if (trans) {
            this.direction = this.direction.getCW();
        }
        if (this.direction == EnumDirectionSWNE.SOUTH || this.direction == EnumDirectionSWNE.NORTH) {
            pos.setX((float)trackPos.func_177958_n() + 0.5f);
            return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), (Object)(!trans ? 1 : 0));
        }
        pos.setZ((float)trackPos.func_177952_p() + 0.5f);
        return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(90.0f), (Object)Float.valueOf(0.0f)), (Object)(!trans ? 1 : 0));
    }

    private Triple<Vector3f, Pair<Float, Float>, Boolean> castPointTurntable(Vector3f pos, BlockPos trackPos, float azimuth, boolean mainline, boolean stable) {
        pos.setY((float)trackPos.func_177956_o() + this.railway.getTopOfRail() + this.getWorkingRadius());
        float dx = pos.x - ((float)trackPos.func_177958_n() + 0.5f);
        float dz = pos.z - ((float)trackPos.func_177952_p() + 0.5f);
        float radius = UtilMath.sqrt(Float.valueOf(dx * dx + dz * dz));
        if (radius <= 1.25f) {
            float a = Math.abs(azimuth = MathHelper.func_76142_g((float)(azimuth + (mainline ? 0.0f : 90.0f))));
            if (a <= 0.001f || a >= 179.999f) {
                pos.setX((float)trackPos.func_177958_n() + 0.5f);
                return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), (Object)mainline);
            }
            if (a >= 89.999f && a <= 90.001f) {
                pos.setZ((float)trackPos.func_177952_p() + 0.5f);
                return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(90.0f), (Object)Float.valueOf(0.0f)), (Object)mainline);
            }
            float k1 = UtilMath.tand(Float.valueOf(azimuth + 90.0f));
            float k2 = UtilMath.tand(Float.valueOf(azimuth));
            float b1 = (float)trackPos.func_177952_p() + 0.5f - ((float)trackPos.func_177958_n() + 0.5f) * k1;
            float b2 = pos.z - pos.x * k2;
            float x = (b1 - b2) / (k2 - k1);
            return Triple.of((Object)new Vector3f(x, (float)trackPos.func_177956_o() + this.railway.getTopOfRail() + this.getWorkingRadius(), k2 * x + b2), (Object)Pair.of((Object)Float.valueOf(azimuth), (Object)Float.valueOf(0.0f)), (Object)mainline);
        }
        if (Math.abs(dz) > Math.abs(dx)) {
            pos.setX((float)trackPos.func_177958_n() + 0.5f);
            return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), (Object)mainline);
        }
        pos.setZ((float)trackPos.func_177952_p() + 0.5f);
        return Triple.of((Object)pos, (Object)Pair.of((Object)Float.valueOf(90.0f), (Object)Float.valueOf(0.0f)), (Object)mainline);
    }

    private float getWorkingRadius() {
        return this.railway.getRailProfile().getContact() == EnumRailContact.RC_EXTENDED ? this.radius : this.flangeRadius;
    }

    public void setPosition(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void setPosition(Vector3f pos) {
        this.posX = pos.x;
        this.posY = pos.y;
        this.posZ = pos.z;
    }

    public void setPosition(RotaVec pos) {
        this.posX = pos.getX();
        this.posY = pos.getY();
        this.posZ = pos.getZ();
    }

    public void setPosition(float x, float y, float z, float az, float zn) {
        this.setPosition(x, y, z);
        this.azimuth = az;
        this.zenith = zn;
    }

    public void setPosition(Vector3f pos, float az, float zn) {
        this.setPosition(pos);
        this.azimuth = az;
        this.zenith = zn;
    }

    public void setPosition(RotaVec pos, float az, float zn) {
        this.setPosition(pos);
        this.azimuth = az;
        this.zenith = zn;
    }

    public void forceRotations(float azimuth, float zenith) {
        this.azimuth = this.azimuthPrev = azimuth;
        this.zenith = this.zenithPrev = zenith;
    }

    public void forceRotations(Entity entity) {
        this.forceRotations(entity.field_70177_z, entity.field_70125_A);
    }

    @Override
    public float getX() {
        return this.posX;
    }

    @Override
    public float getY() {
        return this.posY;
    }

    @Override
    public float getZ() {
        return this.posZ;
    }

    @Override
    public float getRotaAzimuth() {
        return this.azimuth;
    }

    @Override
    public float getRotaZenith() {
        return this.zenith;
    }

    public float getXInp(float partial) {
        return UtilMath.inp(this.posX, this.posXPrev, partial);
    }

    public float getYInp(float partial) {
        return UtilMath.inp(this.posY, this.posYPrev, partial);
    }

    public float getZInp(float partial) {
        return UtilMath.inp(this.posZ, this.posZPrev, partial);
    }

    boolean isOnSlope() {
        return this.shape == EnumTrackShape.SLOPE_STRAIGHT;
    }

    boolean isOnTrack() {
        return this.isOnTrack;
    }
}

