/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.IRotaAngles;
import net.railsofwar.row.common.math.rota.IRotaOrigin;
import net.railsofwar.row.common.math.rota.RotaVec;

public abstract class RollerFrame
implements IRotaOrigin,
IRotaAngles {
    public World world;
    public float posX;
    public float posY;
    public float posZ;
    public float azimuth;
    public float zenith;
    public float posXPrev;
    public float posYPrev;
    public float posZPrev;
    public float azimuthPrev;
    public float zenithPrev;
    public RotaVec jointPos;

    public abstract boolean isOnSlope();

    public abstract boolean isOnTrack();

    public abstract float getFrontAzimuth();

    public abstract float getRearAzimuth();

    public abstract void onUpdate();

    public abstract void forceRotations(float var1, float var2);

    public abstract void forceRotations(Entity var1);

    public void setExternally(float extX, float extY, float extZ) {
        this.jointPos.onUpdate();
        double dx = extX - this.jointPos.getX();
        double dy = extY - this.jointPos.getY();
        double dz = extZ - this.jointPos.getZ();
        this.addPosition(dx, dy, dz);
        this.jointPos.onUpdate();
    }

    public void setExternally(RotaVec extP) {
        extP.onUpdate();
        this.setExternally(extP.getX(), extP.getY(), extP.getZ());
    }

    public void setExternally(Entity e) {
        this.setExternally((float)e.field_70165_t, (float)e.field_70163_u, (float)e.field_70161_v);
    }

    public void addPosition(float dx, float dy, float dz) {
        this.setPosition(this.posX + dx, this.posY + dy, this.posZ + dz);
    }

    public void addPosition(double dx, double dy, double dz) {
        this.setPosition((double)this.posX + dx, (double)this.posY + dy, (double)this.posZ + dz);
    }

    public void checkPosition(double x, double y, double z) {
        double dx = (double)this.posX - x;
        double dy = (double)this.posY - y;
        double dz = (double)this.posZ - z;
        System.out.printf("dx: %f dy: %f dz: %f\n", dx, dy, dz);
    }

    public void setPosition(double x, double y, double z) {
        this.posX = (float)x;
        this.posY = (float)y;
        this.posZ = (float)z;
    }

    public void setPosition(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void setRotations(float az, float zn) {
        this.azimuthPrev = this.azimuth;
        this.zenithPrev = this.zenith;
        this.azimuth = az;
        this.zenith = zn;
    }

    public void setRotations(Entity e) {
        this.setRotations(e.field_70177_z, e.field_70125_A);
    }

    public void setPosition(Vector3f pos) {
        this.setPosition(pos.x, pos.y, pos.z);
    }

    public void setPosition(RotaVec pos) {
        this.setPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public void setPosition(float x, float y, float z, float az, float zn) {
        this.setPosition(x, y, z);
        this.setRotations(az, zn);
    }

    public void setPosition(Vector3f pos, float az, float zn) {
        this.setPosition(pos);
        this.setRotations(az, zn);
    }

    public void setPosition(RotaVec pos, float az, float zn) {
        this.setPosition(pos);
        this.setRotations(az, zn);
    }

    @Override
    public float getX() {
        return this.posX;
    }

    @Override
    public float getY() {
        return this.posY;
    }

    @Override
    public float getZ() {
        return this.posZ;
    }

    @Override
    public float getRotaAzimuth() {
        return this.azimuth;
    }

    @Override
    public float getRotaZenith() {
        return this.zenith;
    }

    public float getXInp(float partial) {
        return UtilMath.inp(this.posX, this.posXPrev, partial);
    }

    public float getYInp(float partial) {
        return UtilMath.inp(this.posY, this.posYPrev, partial);
    }

    public float getZInp(float partial) {
        return UtilMath.inp(this.posZ, this.posZPrev, partial);
    }
}

