/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.roller.RollerAxle;
import net.railsofwar.row.stock.core.roller.RollerFrame;

public class RollerFrame1A
extends RollerFrame {
    public RollerAxle axle;

    public RollerFrame1A(World world, float posX, float posY, float posZ, float azimuth, float zenith, float radius) {
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.azimuth = azimuth;
        this.zenith = zenith;
        this.posXPrev = posX;
        this.posYPrev = posY;
        this.posZPrev = posZ;
        this.azimuthPrev = azimuth;
        this.zenithPrev = zenith;
        this.axle = new RollerAxle(world, posX, posY, posZ, radius, radius + 0.0625f, azimuth, zenith);
        this.jointPos = new RotaVec(this, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void onUpdate() {
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        this.posZPrev = this.posZ;
        this.azimuthPrev = this.azimuth;
        this.zenithPrev = this.zenith;
        this.axle.setPosition(this.posX, this.posY, this.posZ);
        this.axle.onUpdate();
        this.setPosition(this.axle.posX, this.axle.posY, this.axle.posZ);
        this.azimuth = this.axle.azimuth;
        this.zenith = this.axle.zenith;
        this.jointPos.onUpdate();
    }

    @Override
    public boolean isOnSlope() {
        return this.axle.isOnSlope();
    }

    @Override
    public boolean isOnTrack() {
        return this.axle.isOnTrack();
    }

    @Override
    public float getFrontAzimuth() {
        return this.azimuth;
    }

    @Override
    public float getRearAzimuth() {
        return this.azimuth;
    }

    @Override
    public void forceRotations(float azimuth, float zenith) {
        this.axle.azimuth = this.axle.azimuthPrev = azimuth;
        this.azimuthPrev = this.axle.azimuthPrev;
        this.azimuth = this.axle.azimuthPrev;
        this.axle.zenith = this.axle.zenithPrev = zenith;
        this.zenithPrev = this.axle.zenithPrev;
        this.zenith = this.axle.zenithPrev;
    }

    @Override
    public void forceRotations(Entity entity) {
        this.forceRotations(entity.field_70177_z, entity.field_70125_A);
    }
}

